/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.load.FakeSubscriber;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoadManagerTest {
    private static LoadManager LOAD_MANAGER;
    private static LoadCache LOAD_CACHE;
    private static FakeSubscriber FAKE_SUBSCRIBER;
    private static Semaphore NODE_SEMAPHORE;
    private static Semaphore REGION_GROUP_SEMAPHORE;
    private static Semaphore CONSENSUS_GROUP_SEMAPHORE;

    @BeforeClass
    public static void setUp() throws IOException {
        ConfigManager CONFIG_MANAGER = new ConfigManager();
        LOAD_MANAGER = CONFIG_MANAGER.getLoadManager();
        LOAD_CACHE = LOAD_MANAGER.getLoadCache();
    }

    @Before
    public void renewFakeSubscriber() {
        NODE_SEMAPHORE = new Semaphore(0);
        REGION_GROUP_SEMAPHORE = new Semaphore(0);
        CONSENSUS_GROUP_SEMAPHORE = new Semaphore(0);
        FAKE_SUBSCRIBER = new FakeSubscriber(NODE_SEMAPHORE, REGION_GROUP_SEMAPHORE, CONSENSUS_GROUP_SEMAPHORE);
        LOAD_MANAGER.getEventService().getEventPublisher().register((Object)FAKE_SUBSCRIBER);
    }

    @Test
    public void testNodeCache() throws InterruptedException {
        LOAD_CACHE.createNodeHeartbeatCache(NodeType.ConfigNode, 0);
        LOAD_CACHE.createNodeHeartbeatCache(NodeType.DataNode, 1);
        Assert.assertEquals((Object)NodeStatus.Unknown, (Object)LOAD_CACHE.getNodeStatus(0));
        Assert.assertEquals((Object)NodeStatus.Unknown, (Object)LOAD_CACHE.getNodeStatus(1));
        LOAD_CACHE.cacheConfigNodeHeartbeatSample(0, new NodeHeartbeatSample(NodeStatus.Running));
        LOAD_CACHE.cacheDataNodeHeartbeatSample(1, new NodeHeartbeatSample(NodeStatus.Running));
        LOAD_CACHE.updateNodeStatistics(false);
        LOAD_MANAGER.getEventService().checkAndBroadcastNodeStatisticsChangeEventIfNecessary();
        NODE_SEMAPHORE.acquire();
        Assert.assertEquals((Object)NodeStatus.Running, (Object)LOAD_CACHE.getNodeStatus(0));
        Assert.assertEquals((Object)NodeStatus.Running, (Object)LOAD_CACHE.getNodeStatus(1));
        Map<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap = FAKE_SUBSCRIBER.getDifferentNodeStatisticsMap();
        Assert.assertEquals((Object)new Pair(null, (Object)new NodeStatistics(NodeStatus.Running)), differentNodeStatisticsMap.get(0));
        Assert.assertEquals((Object)new Pair(null, (Object)new NodeStatistics(NodeStatus.Running)), differentNodeStatisticsMap.get(1));
        LOAD_MANAGER.forceUpdateNodeCache(NodeType.DataNode, 1, new NodeHeartbeatSample(NodeStatus.Removing));
        NODE_SEMAPHORE.acquire();
        Assert.assertEquals((Object)NodeStatus.Removing, (Object)LOAD_CACHE.getNodeStatus(1));
        differentNodeStatisticsMap = FAKE_SUBSCRIBER.getDifferentNodeStatisticsMap();
        Assert.assertEquals((long)1L, (long)differentNodeStatisticsMap.size());
        Assert.assertEquals((Object)new Pair((Object)new NodeStatistics(NodeStatus.Running), (Object)new NodeStatistics(NodeStatus.Removing)), differentNodeStatisticsMap.get(1));
        LOAD_CACHE.cacheDataNodeHeartbeatSample(1, new NodeHeartbeatSample(NodeStatus.ReadOnly));
        LOAD_CACHE.updateNodeStatistics(false);
        LOAD_MANAGER.getEventService().checkAndBroadcastNodeStatisticsChangeEventIfNecessary();
        Assert.assertEquals((Object)NodeStatus.Removing, (Object)LOAD_CACHE.getNodeStatus(1));
        LOAD_MANAGER.removeNodeCache(1);
        NODE_SEMAPHORE.acquire();
        differentNodeStatisticsMap = FAKE_SUBSCRIBER.getDifferentNodeStatisticsMap();
        Assert.assertEquals((long)1L, (long)differentNodeStatisticsMap.size());
        Assert.assertEquals((Object)new Pair((Object)new NodeStatistics(NodeStatus.Removing), null), differentNodeStatisticsMap.get(1));
    }

    @Test
    public void testRegionGroupCache() throws InterruptedException {
        TConsensusGroupId regionGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, 0);
        Set<Integer> dataNodeIds = Stream.of(0, 1, 2).collect(Collectors.toSet());
        LOAD_CACHE.createRegionGroupHeartbeatCache("root.db", regionGroupId, dataNodeIds);
        Assert.assertEquals((Object)RegionGroupStatus.Disabled, (Object)LOAD_CACHE.getRegionGroupStatus(regionGroupId));
        dataNodeIds.forEach(dataNodeId -> Assert.assertEquals((Object)RegionStatus.Unknown, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, dataNodeId.intValue())));
        dataNodeIds.forEach(dataNodeId -> LOAD_CACHE.cacheRegionHeartbeatSample(regionGroupId, dataNodeId.intValue(), new RegionHeartbeatSample(RegionStatus.Running), false));
        LOAD_CACHE.updateRegionGroupStatistics();
        LOAD_MANAGER.getEventService().checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
        REGION_GROUP_SEMAPHORE.acquire();
        Assert.assertEquals((Object)RegionGroupStatus.Running, (Object)LOAD_CACHE.getRegionGroupStatus(regionGroupId));
        dataNodeIds.forEach(dataNodeId -> Assert.assertEquals((Object)RegionStatus.Running, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, dataNodeId.intValue())));
        Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentRegionGroupStatisticsMap();
        Map<Integer, RegionStatistics> allRunningRegionStatisticsMap = dataNodeIds.stream().collect(Collectors.toMap(dataNodeId -> dataNodeId, dataNodeId -> new RegionStatistics(RegionStatus.Running)));
        Assert.assertEquals((Object)new Pair(null, (Object)new RegionGroupStatistics(RegionGroupStatus.Running, allRunningRegionStatisticsMap)), differentRegionGroupStatisticsMap.get(regionGroupId));
        int removeDataNodeId = 0;
        LOAD_MANAGER.forceUpdateRegionCache(regionGroupId, removeDataNodeId, RegionStatus.Removing);
        REGION_GROUP_SEMAPHORE.acquire();
        Assert.assertEquals((Object)RegionStatus.Removing, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, removeDataNodeId));
        differentRegionGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentRegionGroupStatisticsMap();
        TreeMap<Integer, RegionStatistics> oneRemovingRegionStatisticsMap = new TreeMap<Integer, RegionStatistics>(allRunningRegionStatisticsMap);
        oneRemovingRegionStatisticsMap.replace(removeDataNodeId, new RegionStatistics(RegionStatus.Removing));
        Assert.assertEquals((Object)new Pair((Object)new RegionGroupStatistics(RegionGroupStatus.Running, allRunningRegionStatisticsMap), (Object)new RegionGroupStatistics(RegionGroupStatus.Running, oneRemovingRegionStatisticsMap)), differentRegionGroupStatisticsMap.get(regionGroupId));
        int addDataNodeId = 3;
        LOAD_CACHE.createRegionCache(regionGroupId, addDataNodeId);
        LOAD_MANAGER.forceUpdateRegionCache(regionGroupId, addDataNodeId, RegionStatus.Adding);
        REGION_GROUP_SEMAPHORE.acquire();
        Assert.assertEquals((Object)RegionStatus.Adding, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, addDataNodeId));
        differentRegionGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentRegionGroupStatisticsMap();
        TreeMap<Integer, RegionStatistics> oneAddingRegionStatisticsMap = new TreeMap<Integer, RegionStatistics>((Map<Integer, RegionStatistics>)oneRemovingRegionStatisticsMap);
        oneAddingRegionStatisticsMap.put(addDataNodeId, new RegionStatistics(RegionStatus.Adding));
        Assert.assertEquals((Object)new Pair((Object)new RegionGroupStatistics(RegionGroupStatus.Running, oneRemovingRegionStatisticsMap), (Object)new RegionGroupStatistics(RegionGroupStatus.Running, oneAddingRegionStatisticsMap)), differentRegionGroupStatisticsMap.get(regionGroupId));
        LOAD_CACHE.cacheRegionHeartbeatSample(regionGroupId, removeDataNodeId, new RegionHeartbeatSample(RegionStatus.Unknown), false);
        LOAD_CACHE.cacheRegionHeartbeatSample(regionGroupId, addDataNodeId, new RegionHeartbeatSample(RegionStatus.ReadOnly), false);
        LOAD_CACHE.updateRegionGroupStatistics();
        LOAD_MANAGER.getEventService().checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
        Assert.assertEquals((Object)RegionStatus.Removing, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, removeDataNodeId));
        Assert.assertEquals((Object)RegionStatus.Adding, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, addDataNodeId));
        LOAD_MANAGER.forceUpdateRegionCache(regionGroupId, addDataNodeId, RegionStatus.Running);
        REGION_GROUP_SEMAPHORE.acquire();
        Assert.assertEquals((Object)RegionStatus.Running, (Object)LOAD_CACHE.getRegionStatus(regionGroupId, addDataNodeId));
        differentRegionGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentRegionGroupStatisticsMap();
        oneRemovingRegionStatisticsMap.put(addDataNodeId, new RegionStatistics(RegionStatus.Running));
        Assert.assertEquals((Object)new Pair((Object)new RegionGroupStatistics(RegionGroupStatus.Running, oneAddingRegionStatisticsMap), (Object)new RegionGroupStatistics(RegionGroupStatus.Running, oneRemovingRegionStatisticsMap)), differentRegionGroupStatisticsMap.get(regionGroupId));
        LOAD_MANAGER.removeRegionCache(regionGroupId, removeDataNodeId);
        REGION_GROUP_SEMAPHORE.acquire();
        differentRegionGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentRegionGroupStatisticsMap();
        allRunningRegionStatisticsMap.remove(removeDataNodeId);
        allRunningRegionStatisticsMap.put(addDataNodeId, new RegionStatistics(RegionStatus.Running));
        Assert.assertEquals((Object)new Pair((Object)new RegionGroupStatistics(RegionGroupStatus.Running, oneRemovingRegionStatisticsMap), (Object)new RegionGroupStatistics(RegionGroupStatus.Running, allRunningRegionStatisticsMap)), differentRegionGroupStatisticsMap.get(regionGroupId));
    }

    @Test
    public void testConsensusGroupCache() throws InterruptedException {
        TConsensusGroupId regionGroupId = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1);
        Set dataNodeIds = Stream.of(0, 1, 2).collect(Collectors.toSet());
        LOAD_CACHE.createRegionGroupHeartbeatCache("root.db", regionGroupId, dataNodeIds);
        Assert.assertEquals((long)-1L, (long)((Integer)LOAD_CACHE.getRegionLeaderMap().get(regionGroupId)).intValue());
        int originLeaderId = 1;
        LOAD_CACHE.cacheConsensusSample(regionGroupId, new ConsensusGroupHeartbeatSample(originLeaderId));
        LOAD_CACHE.updateConsensusGroupStatistics();
        LOAD_MANAGER.getEventService().checkAndBroadcastConsensusGroupStatisticsChangeEventIfNecessary();
        CONSENSUS_GROUP_SEMAPHORE.acquire();
        Map<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> differentConsensusGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentConsensusGroupStatisticsMap();
        Assert.assertEquals((Object)new Pair(null, (Object)new ConsensusGroupStatistics(originLeaderId)), differentConsensusGroupStatisticsMap.get(regionGroupId));
        int newLeaderId = 2;
        LOAD_MANAGER.forceUpdateConsensusGroupCache(Collections.singletonMap(regionGroupId, new ConsensusGroupHeartbeatSample(newLeaderId)));
        CONSENSUS_GROUP_SEMAPHORE.acquire();
        differentConsensusGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentConsensusGroupStatisticsMap();
        Assert.assertEquals((Object)new Pair((Object)new ConsensusGroupStatistics(originLeaderId), (Object)new ConsensusGroupStatistics(newLeaderId)), differentConsensusGroupStatisticsMap.get(regionGroupId));
        LOAD_MANAGER.removeRegionGroupRelatedCache(regionGroupId);
        CONSENSUS_GROUP_SEMAPHORE.acquire();
        differentConsensusGroupStatisticsMap = FAKE_SUBSCRIBER.getDifferentConsensusGroupStatisticsMap();
        Assert.assertEquals((long)1L, (long)differentConsensusGroupStatisticsMap.size());
        Assert.assertEquals((Object)new Pair((Object)new ConsensusGroupStatistics(newLeaderId), null), differentConsensusGroupStatisticsMap.get(regionGroupId));
    }
}

