/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.subscriber.ConsensusGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.NodeStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.RegionGroupStatisticsChangeEvent;
import org.apache.tsfile.utils.Pair;

public class FakeSubscriber
implements IClusterStatusSubscriber {
    private final Semaphore nodeSemaphore;
    private final Map<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap;
    private final Semaphore regionGroupSemaphore;
    private final Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap;
    private final Semaphore consensusGroupSemaphore;
    private final Map<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> differentConsensusGroupStatisticsMap;

    public FakeSubscriber(Semaphore nodeSemaphore, Semaphore regionGroupSemaphore, Semaphore consensusGroupSemaphore) {
        this.nodeSemaphore = nodeSemaphore;
        this.regionGroupSemaphore = regionGroupSemaphore;
        this.consensusGroupSemaphore = consensusGroupSemaphore;
        this.differentNodeStatisticsMap = new TreeMap<Integer, Pair<NodeStatistics, NodeStatistics>>();
        this.differentRegionGroupStatisticsMap = new TreeMap<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>>();
        this.differentConsensusGroupStatisticsMap = new TreeMap<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>>();
    }

    public void onNodeStatisticsChanged(NodeStatisticsChangeEvent event) {
        this.differentNodeStatisticsMap.clear();
        this.differentNodeStatisticsMap.putAll(event.getDifferentNodeStatisticsMap());
        this.nodeSemaphore.release();
    }

    public void onRegionGroupStatisticsChanged(RegionGroupStatisticsChangeEvent event) {
        this.differentRegionGroupStatisticsMap.clear();
        this.differentRegionGroupStatisticsMap.putAll(event.getDifferentRegionGroupStatisticsMap());
        this.regionGroupSemaphore.release();
    }

    public void onConsensusGroupStatisticsChanged(ConsensusGroupStatisticsChangeEvent event) {
        this.differentConsensusGroupStatisticsMap.clear();
        this.differentConsensusGroupStatisticsMap.putAll(event.getDifferentConsensusGroupStatisticsMap());
        this.consensusGroupSemaphore.release();
    }

    public Map<Integer, Pair<NodeStatistics, NodeStatistics>> getDifferentNodeStatisticsMap() {
        return this.differentNodeStatisticsMap;
    }

    public Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> getDifferentRegionGroupStatisticsMap() {
        return this.differentRegionGroupStatisticsMap;
    }

    public Map<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> getDifferentConsensusGroupStatisticsMap() {
        return this.differentConsensusGroupStatisticsMap;
    }
}

