/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.hash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;

public class DeviceGroupHashExecutorManualTest {
    private static final int deviceGroupCount = 10000;
    private static final String sg = "root.SGGroup.";
    private static final int batchCount = 10000;
    private static final int batchSize = 10000;
    private static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-";

    private List<String> genBatchDevices() {
        Random random = new Random();
        ArrayList<String> devices = new ArrayList<String>();
        int fatherLength = random.nextInt(10) + 10;
        int deviceLength = random.nextInt(5) + 5;
        for (int i = 0; i < 10000; ++i) {
            StringBuilder curDevice = new StringBuilder(sg);
            for (int j = 0; j < fatherLength; ++j) {
                curDevice.append(chars.charAt(random.nextInt(chars.length())));
            }
            curDevice.append('.');
            for (int k = 0; k < deviceLength; ++k) {
                curDevice.append(chars.charAt(random.nextInt(chars.length())));
            }
            devices.add(curDevice.toString());
        }
        return devices;
    }

    public void GeneralIndexTest() throws IOException {
        PartitionManager manager = new PartitionManager((IManager)new ConfigManager(), new PartitionInfo());
        int[] bucket = new int[10000];
        Arrays.fill(bucket, 0);
        long totalTime = 0L;
        for (int i = 0; i < 10000; ++i) {
            List<String> devices = this.genBatchDevices();
            totalTime -= System.currentTimeMillis();
            for (String device : devices) {
                int n = manager.getSeriesPartitionSlot(device).getSlotId();
                bucket[n] = bucket[n] + 1;
            }
            totalTime += System.currentTimeMillis();
        }
        Arrays.sort(bucket);
        int firstNotNull = 0;
        while (bucket[firstNotNull] <= 0) {
            ++firstNotNull;
        }
        System.out.println("Empty DeviceGroup count: " + firstNotNull);
        System.out.println("Minimum DeviceGroup size: " + bucket[firstNotNull]);
        System.out.println("Maximal DeviceGroup size: " + bucket[9999]);
        System.out.println("Average size of nonempty DeviceGroup: " + 1.0E8 / (double)(10000 - firstNotNull));
        System.out.println("Median size of nonempty DeviceGroup: " + bucket[(10000 - firstNotNull) / 2]);
        System.out.println("Total time-consuming: " + (double)totalTime / 1000.0 + "s");
    }
}

