/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.RemoveDataNodeHandler;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodesProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrationPlan;
import org.apache.iotdb.db.service.RegionMigrateService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class ProcedureManagerTest {
    private static ProcedureManager PROCEDURE_MANAGER;
    private static RemoveDataNodeHandler REMOVE_DATA_NODE_HANDLER;
    private static LoadManager LOAD_MANAGER;
    private static final ConcurrentHashMap<Long, Procedure<ConfigNodeProcedureEnv>> procedureMap;
    private final TConsensusGroupId consensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, 1);
    private final TDataNodeLocation removeDataNodeLocationA = new TDataNodeLocation(10, new TEndPoint("127.0.0.1", 6667), new TEndPoint("127.0.0.1", 6668), new TEndPoint("127.0.0.1", 6669), new TEndPoint("127.0.0.1", 6670), new TEndPoint("127.0.0.1", 6671));
    private final TDataNodeLocation removeDataNodeLocationB = new TDataNodeLocation(11, new TEndPoint("127.0.0.1", 6677), new TEndPoint("127.0.0.1", 6678), new TEndPoint("127.0.0.1", 6679), new TEndPoint("127.0.0.1", 6680), new TEndPoint("127.0.0.1", 6681));
    private final TDataNodeLocation toDataNodeLocation = new TDataNodeLocation(12, new TEndPoint("127.0.0.1", 6687), new TEndPoint("127.0.0.1", 6688), new TEndPoint("127.0.0.1", 6689), new TEndPoint("127.0.0.1", 6690), new TEndPoint("127.0.0.1", 6691));
    private final TDataNodeLocation coordinatorDataNodeLocation = new TDataNodeLocation(13, new TEndPoint("127.0.0.1", 6697), new TEndPoint("127.0.0.1", 6698), new TEndPoint("127.0.0.1", 6699), new TEndPoint("127.0.0.1", 6700), new TEndPoint("127.0.0.1", 6701));
    private final List<TDataNodeLocation> removedDataNodes = new ArrayList<TDataNodeLocation>(Arrays.asList(this.removeDataNodeLocationA, this.removeDataNodeLocationB));

    @BeforeClass
    public static void setUp() throws IOException {
        ConfigManager CONFIG_MANAGER = new ConfigManager();
        ProcedureManager procedureManager = CONFIG_MANAGER.getProcedureManager();
        PROCEDURE_MANAGER = (ProcedureManager)Mockito.spy((Object)procedureManager);
        ProcedureExecutor procedureExecutor = PROCEDURE_MANAGER.getExecutor();
        ProcedureExecutor PROCEDURE_EXECUTOR = (ProcedureExecutor)Mockito.spy((Object)procedureExecutor);
        ConfigNodeProcedureEnv env = PROCEDURE_MANAGER.getEnv();
        ConfigNodeProcedureEnv ENV = (ConfigNodeProcedureEnv)Mockito.spy((Object)env);
        RemoveDataNodeHandler removeDataNodeHandler = ENV.getRemoveDataNodeHandler();
        REMOVE_DATA_NODE_HANDLER = (RemoveDataNodeHandler)Mockito.spy((Object)removeDataNodeHandler);
        LoadManager loadManager = CONFIG_MANAGER.getLoadManager();
        LOAD_MANAGER = (LoadManager)Mockito.spy((Object)loadManager);
        Mockito.when((Object)PROCEDURE_MANAGER.getExecutor()).thenReturn((Object)PROCEDURE_EXECUTOR);
        Mockito.when((Object)PROCEDURE_EXECUTOR.getProcedures()).thenReturn(procedureMap);
        Mockito.when((Object)PROCEDURE_MANAGER.getEnv()).thenReturn((Object)ENV);
        Mockito.when((Object)ENV.getRemoveDataNodeHandler()).thenReturn((Object)REMOVE_DATA_NODE_HANDLER);
    }

    @Test
    public void testCheckRemoveDataNodeWithAnotherRemoveProcedure() {
        HashMap<Integer, NodeStatus> nodeStatusMap = new HashMap<Integer, NodeStatus>();
        nodeStatusMap.put(10, NodeStatus.Running);
        RemoveDataNodesProcedure anotherRemoveProcedure = new RemoveDataNodesProcedure(this.removedDataNodes, nodeStatusMap);
        procedureMap.put(0L, (Procedure<ConfigNodeProcedureEnv>)anotherRemoveProcedure);
        TSStatus status = PROCEDURE_MANAGER.checkRemoveDataNodes(this.removedDataNodes);
        Assert.assertTrue((boolean)RegionMigrateService.isFailed((TSStatus)status));
    }

    @Test
    public void testCheckRemoveDataNodeWithConflictRegionMigrateProcedure() {
        RegionMigrateProcedure regionMigrateProcedure = new RegionMigrateProcedure(this.consensusGroupId, this.removeDataNodeLocationA, this.removeDataNodeLocationB, this.coordinatorDataNodeLocation, this.coordinatorDataNodeLocation);
        procedureMap.put(0L, (Procedure<ConfigNodeProcedureEnv>)regionMigrateProcedure);
        HashSet<TConsensusGroupId> set = new HashSet<TConsensusGroupId>();
        set.add(this.consensusGroupId);
        Mockito.when((Object)REMOVE_DATA_NODE_HANDLER.getRemovedDataNodesRegionSet(this.removedDataNodes)).thenReturn(set);
        TSStatus status = PROCEDURE_MANAGER.checkRemoveDataNodes(this.removedDataNodes);
        Assert.assertTrue((boolean)RegionMigrateService.isFailed((TSStatus)status));
    }

    @Test
    public void testCheckRemoveDataNodeWithRegionMigrateProcedureConflictsWithEachOther() {
        RegionMigrationPlan regionMigrationPlanA = new RegionMigrationPlan(this.consensusGroupId, this.removeDataNodeLocationA);
        regionMigrationPlanA.setToDataNode(this.toDataNodeLocation);
        RegionMigrationPlan regionMigrationPlanB = new RegionMigrationPlan(this.consensusGroupId, this.removeDataNodeLocationB);
        regionMigrationPlanB.setToDataNode(this.toDataNodeLocation);
        ArrayList<RegionMigrationPlan> regionMigrationPlans = new ArrayList<RegionMigrationPlan>(Arrays.asList(regionMigrationPlanA, regionMigrationPlanB));
        Mockito.when((Object)REMOVE_DATA_NODE_HANDLER.getRegionMigrationPlans(this.removedDataNodes)).thenReturn(regionMigrationPlans);
        TSStatus status = PROCEDURE_MANAGER.checkRemoveDataNodes(this.removedDataNodes);
        Assert.assertTrue((boolean)RegionMigrateService.isFailed((TSStatus)status));
    }

    @Test
    public void testCheckRemoveDataNodeWithAnotherUnknownDataNode() {
        HashSet<TDataNodeLocation> relatedDataNodes = new HashSet<TDataNodeLocation>();
        relatedDataNodes.add(this.removeDataNodeLocationA);
        relatedDataNodes.add(this.coordinatorDataNodeLocation);
        Mockito.when((Object)REMOVE_DATA_NODE_HANDLER.getRelatedDataNodeLocations(this.removeDataNodeLocationA)).thenReturn(relatedDataNodes);
        Mockito.when((Object)LOAD_MANAGER.getNodeStatus(this.removeDataNodeLocationA.getDataNodeId())).thenReturn((Object)NodeStatus.Running);
        Mockito.when((Object)LOAD_MANAGER.getNodeStatus(this.coordinatorDataNodeLocation.getDataNodeId())).thenReturn((Object)NodeStatus.Unknown);
        TSStatus status = PROCEDURE_MANAGER.checkRemoveDataNodes(this.removedDataNodes);
        Assert.assertTrue((boolean)RegionMigrateService.isFailed((TSStatus)status));
    }

    static {
        procedureMap = new ConcurrentHashMap();
    }
}

