/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.pipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.junit.Assert;
import org.junit.Test;

public class PipeTableRespTest {
    public PipeTableResp constructPipeTableResp() {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        ArrayList<PipeMeta> pipeMetaList = new ArrayList<PipeMeta>();
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        HashMap<String, String> processorAttributes = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        extractorAttributes.put("extractor", "iotdb-extractor");
        processorAttributes.put("processor", "do-nothing-processor");
        connectorAttributes.put("connector", "iotdb-thrift-connector");
        connectorAttributes.put("host", "127.0.0.1");
        connectorAttributes.put("port", "6667");
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks.put(1, pipeTaskMeta);
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("testPipe", 121L, extractorAttributes, processorAttributes, connectorAttributes);
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta(pipeTasks);
        pipeMetaList.add(new PipeMeta(pipeStaticMeta, pipeRuntimeMeta));
        HashMap<String, String> extractorAttributes1 = new HashMap<String, String>();
        HashMap<String, String> processorAttributes1 = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes1 = new HashMap<String, String>();
        extractorAttributes1.put("extractor", "iotdb-extractor");
        processorAttributes1.put("processor", "do-nothing-processor");
        connectorAttributes1.put("connector", "iotdb-thrift-connector");
        connectorAttributes1.put("host", "127.0.0.1");
        connectorAttributes1.put("port", "6667");
        PipeTaskMeta pipeTaskMeta1 = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks1 = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks1.put(1, pipeTaskMeta1);
        PipeStaticMeta pipeStaticMeta1 = new PipeStaticMeta("testPipe1", 122L, extractorAttributes1, processorAttributes1, connectorAttributes1);
        PipeRuntimeMeta pipeRuntimeMeta1 = new PipeRuntimeMeta(pipeTasks1);
        pipeMetaList.add(new PipeMeta(pipeStaticMeta1, pipeRuntimeMeta1));
        HashMap<String, String> extractorAttributes2 = new HashMap<String, String>();
        HashMap<String, String> processorAttributes2 = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes2 = new HashMap<String, String>();
        extractorAttributes2.put("extractor", "iotdb-extractor");
        processorAttributes2.put("processor", "do-nothing-processor");
        connectorAttributes2.put("connector", "iotdb-thrift-connector");
        connectorAttributes2.put("host", "172.30.30.30");
        connectorAttributes2.put("port", "6667");
        PipeTaskMeta pipeTaskMeta2 = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks2 = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks2.put(1, pipeTaskMeta2);
        PipeStaticMeta pipeStaticMeta2 = new PipeStaticMeta("testPipe2", 123L, extractorAttributes2, processorAttributes2, connectorAttributes2);
        PipeRuntimeMeta pipeRuntimeMeta2 = new PipeRuntimeMeta(pipeTasks2);
        pipeMetaList.add(new PipeMeta(pipeStaticMeta2, pipeRuntimeMeta2));
        return new PipeTableResp(status, pipeMetaList);
    }

    @Test
    public void testFilter() {
        PipeTableResp pipeTableResp = this.constructPipeTableResp();
        PipeTableResp filteredPipeTableRespByConnector = pipeTableResp.filter(Boolean.valueOf(true), "testPipe");
        Assert.assertEquals((long)2L, (long)filteredPipeTableRespByConnector.getAllPipeMeta().size());
        PipeTableResp filteredPipeTableRespByName = pipeTableResp.filter(Boolean.valueOf(false), "testPipe");
        Assert.assertEquals((long)1L, (long)filteredPipeTableRespByName.getAllPipeMeta().size());
        PipeTableResp allPipeTableResp = pipeTableResp.filter(Boolean.valueOf(true), null);
        Assert.assertEquals((long)3L, (long)allPipeTableResp.getAllPipeMeta().size());
    }
}

