/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.pipe;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.extractor.iotdb.IoTDBExtractor;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.processor.donothing.DoNothingProcessor;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.confignode.consensus.response.pipe.plugin.PipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.junit.Assert;
import org.junit.Test;

public class PipePluginTableRespTest {
    @Test
    public void testConvertToThriftResponse() throws IOException {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        ArrayList<PipePluginMeta> pipePluginMetaList = new ArrayList<PipePluginMeta>();
        pipePluginMetaList.add(new PipePluginMeta("iotdb-extractor", IoTDBExtractor.class.getName()));
        pipePluginMetaList.add(new PipePluginMeta("do-nothing-processor", DoNothingProcessor.class.getName()));
        PipePluginTableResp pipePluginTableResp = new PipePluginTableResp(status, pipePluginMetaList);
        ArrayList<ByteBuffer> pipePluginByteBuffers = new ArrayList<ByteBuffer>();
        for (PipePluginMeta pipePluginMeta : pipePluginMetaList) {
            pipePluginByteBuffers.add(pipePluginMeta.serialize());
        }
        TGetPipePluginTableResp getPipePluginTableResp = new TGetPipePluginTableResp(status, pipePluginByteBuffers);
        Assert.assertEquals((Object)pipePluginTableResp.convertToThriftResponse(), (Object)getPipePluginTableResp);
    }
}

