/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.confignode.consensus.response.function.FunctionTableResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TransferringTriggersResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TriggerLocationResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.junit.Assert;
import org.junit.Test;

public class ConvertToThriftRespTest {
    @Test
    public void convertFunctionRespTest() throws IOException {
        FunctionTableResp functionTableResp = new FunctionTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), (List)ImmutableList.of((Object)new UDFInformation("test1", "test1", false, true, "test1.jar", "12345"), (Object)new UDFInformation("test2", "test2", false, true, "test2.jar", "12342")));
        TGetUDFTableResp tGetUDFTableResp = functionTableResp.convertToThriftResponse();
        Assert.assertEquals((Object)functionTableResp.getStatus(), (Object)tGetUDFTableResp.status);
        Assert.assertEquals(functionTableResp.getAllUdfInformation().get(0), (Object)UDFInformation.deserialize((ByteBuffer)((ByteBuffer)tGetUDFTableResp.allUDFInformation.get(0))));
        Assert.assertEquals(functionTableResp.getAllUdfInformation().get(1), (Object)UDFInformation.deserialize((ByteBuffer)((ByteBuffer)tGetUDFTableResp.allUDFInformation.get(1))));
    }

    @Test
    public void convertTriggerRespTest() throws IOException, IllegalPathException {
        TransferringTriggersResp transferringTriggersResp = new TransferringTriggersResp((List)ImmutableList.of((Object)"123", (Object)"234"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"123", (Object)"234"), (Object)transferringTriggersResp.getTransferringTriggers());
        TriggerLocationResp triggerLocationResp = new TriggerLocationResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), new TDataNodeLocation(10000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)));
        TGetLocationForTriggerResp tGetLocationForTriggerResp = triggerLocationResp.convertToThriftResponse();
        Assert.assertEquals((Object)triggerLocationResp.getStatus(), (Object)tGetLocationForTriggerResp.status);
        Assert.assertEquals((Object)triggerLocationResp.getDataNodeLocation(), (Object)tGetLocationForTriggerResp.dataNodeLocation);
        TriggerTableResp triggerTableResp = new TriggerTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), (List)ImmutableList.of((Object)new TriggerInformation(new PartialPath("root.test.**"), "test1", "test1.class", true, "test1.jar", null, TriggerEvent.AFTER_INSERT, TTriggerState.INACTIVE, false, null, FailureStrategy.OPTIMISTIC, "testMD5test")));
        TGetTriggerTableResp tGetTriggerTableResp = triggerTableResp.convertToThriftResponse();
        Assert.assertEquals((Object)triggerTableResp.getStatus(), (Object)tGetTriggerTableResp.status);
        Assert.assertEquals(triggerTableResp.getAllTriggerInformation().get(0), (Object)TriggerInformation.deserialize((ByteBuffer)((ByteBuffer)tGetTriggerTableResp.allTriggerInformation.get(0))));
    }

    @Test
    public void convertJarRespTest() throws IOException {
        FunctionTableResp functionTableResp = new FunctionTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), (List)ImmutableList.of((Object)new UDFInformation("test1", "test1", false, true, "test1.jar", "12345"), (Object)new UDFInformation("test2", "test2", false, true, "test2.jar", "12342")));
        TGetUDFTableResp tGetUDFTableResp = functionTableResp.convertToThriftResponse();
        Assert.assertEquals((Object)functionTableResp.getStatus(), (Object)tGetUDFTableResp.status);
        Assert.assertEquals(functionTableResp.getAllUdfInformation().get(0), (Object)UDFInformation.deserialize((ByteBuffer)((ByteBuffer)tGetUDFTableResp.allUDFInformation.get(0))));
        Assert.assertEquals(functionTableResp.getAllUdfInformation().get(1), (Object)UDFInformation.deserialize((ByteBuffer)((ByteBuffer)tGetUDFTableResp.allUDFInformation.get(1))));
    }
}

