/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TNodeResource;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.IoTProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.commons.sync.PipeInfo;
import org.apache.iotdb.commons.sync.PipeMessage;
import org.apache.iotdb.commons.sync.PipeStatus;
import org.apache.iotdb.commons.sync.TsFilePipeInfo;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateClusterIdPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.ActiveCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.AddCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.DropCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.UpdateCQLastExecTimePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.DropFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.AddRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.AutoCleanPartitionTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.RemoveRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.CreatePipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.AlterPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.OperateMultiplePipesPlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.consensus.request.write.procedure.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetSpaceQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetThrottleQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollSpecificRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.consumer.AlterConsumerGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.consumer.runtime.ConsumerGroupHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterMultipleTopicsPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.AlterTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.CreateTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.DropTopicPlan;
import org.apache.iotdb.confignode.consensus.request.write.subscription.topic.runtime.TopicHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.CreatePipeSinkPlanV1;
import org.apache.iotdb.confignode.consensus.request.write.sync.DropPipeSinkPlanV1;
import org.apache.iotdb.confignode.consensus.request.write.sync.GetPipeSinkPlanV1;
import org.apache.iotdb.confignode.consensus.request.write.sync.PreCreatePipePlanV1;
import org.apache.iotdb.confignode.consensus.request.write.sync.RecordPipeMessagePlan;
import org.apache.iotdb.confignode.consensus.request.write.sync.SetPipeStatusPlanV1;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.AddTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggersOnTransferNodesPlan;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.impl.region.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteDatabaseProcedure;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;

public class ConfigPhysicalPlanSerDeTest {
    @Test
    public void RegisterDataNodePlanTest() throws IOException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(1);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TDataNodeConfiguration dataNodeConfiguration = new TDataNodeConfiguration();
        dataNodeConfiguration.setLocation(dataNodeLocation);
        dataNodeConfiguration.setResource(new TNodeResource(16, 0x800000000L));
        RegisterDataNodePlan plan0 = new RegisterDataNodePlan(dataNodeConfiguration);
        RegisterDataNodePlan plan1 = (RegisterDataNodePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan0.serializeToByteBuffer());
        Assert.assertEquals((Object)plan0, (Object)plan1);
    }

    @Test
    public void UpdateDataNodePlanTest() throws IOException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TNodeResource dataNodeResource = new TNodeResource();
        dataNodeResource.setCpuCoreNum(16);
        dataNodeResource.setMaxMemory(2022213861L);
        TDataNodeConfiguration dataNodeConfiguration = new TDataNodeConfiguration();
        dataNodeConfiguration.setLocation(dataNodeLocation);
        dataNodeConfiguration.setResource(dataNodeResource);
        UpdateDataNodePlan plan0 = new UpdateDataNodePlan(dataNodeConfiguration);
        UpdateDataNodePlan plan1 = (UpdateDataNodePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan0.serializeToByteBuffer());
        Assert.assertEquals((Object)plan0, (Object)plan1);
    }

    @Test
    public void CreateDatabasePlanTest() throws IOException {
        DatabaseSchemaPlan req0 = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema().setName("sg").setSchemaReplicationFactor(3).setDataReplicationFactor(3).setTimePartitionInterval(604800L));
        DatabaseSchemaPlan req1 = (DatabaseSchemaPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void AlterDatabasePlanTest() throws IOException {
        DatabaseSchemaPlan req0 = new DatabaseSchemaPlan(ConfigPhysicalPlanType.AlterDatabase, new TDatabaseSchema().setName("sg").setSchemaReplicationFactor(3).setDataReplicationFactor(3).setTimePartitionInterval(604800L).setMinSchemaRegionGroupNum(2).setMaxSchemaRegionGroupNum(5).setMinDataRegionGroupNum(3).setMaxDataRegionGroupNum(8));
        DatabaseSchemaPlan req1 = (DatabaseSchemaPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void DeleteStorageGroupPlanTest() throws IOException {
        DeleteDatabasePlan req0 = new DeleteDatabasePlan("root.sg");
        DeleteDatabasePlan req1 = (DeleteDatabasePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void SetTTLPlanTest() throws IOException {
        SetTTLPlan req0 = new SetTTLPlan(Arrays.asList("root", "sg0"), Long.MAX_VALUE);
        SetTTLPlan req1 = (SetTTLPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void SetSchemaReplicationFactorPlanTest() throws IOException {
        SetSchemaReplicationFactorPlan req0 = new SetSchemaReplicationFactorPlan("root.sg0", 3);
        SetSchemaReplicationFactorPlan req1 = (SetSchemaReplicationFactorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void SetDataReplicationFactorPlanTest() throws IOException {
        SetDataReplicationFactorPlan req0 = new SetDataReplicationFactorPlan("root.sg0", 3);
        SetDataReplicationFactorPlan req1 = (SetDataReplicationFactorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void SetTimePartitionIntervalPlanTest() throws IOException {
        SetTimePartitionIntervalPlan req0 = new SetTimePartitionIntervalPlan("root.sg0", 6048000L);
        SetTimePartitionIntervalPlan req1 = (SetTimePartitionIntervalPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void AdjustMaxRegionGroupCountPlanTest() throws IOException {
        AdjustMaxRegionGroupNumPlan req0 = new AdjustMaxRegionGroupNumPlan();
        for (int i = 0; i < 3; ++i) {
            req0.putEntry("root.sg" + i, new Pair((Object)i, (Object)i));
        }
        AdjustMaxRegionGroupNumPlan req1 = (AdjustMaxRegionGroupNumPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void CreateRegionsPlanTest() throws IOException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        CreateRegionGroupsPlan req0 = new CreateRegionGroupsPlan();
        TRegionReplicaSet dataRegionSet = new TRegionReplicaSet();
        dataRegionSet.setRegionId(new TConsensusGroupId(TConsensusGroupType.DataRegion, 0));
        dataRegionSet.setDataNodeLocations(Collections.singletonList(dataNodeLocation));
        req0.addRegionGroup("root.sg0", dataRegionSet);
        TRegionReplicaSet schemaRegionSet = new TRegionReplicaSet();
        schemaRegionSet.setRegionId(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1));
        schemaRegionSet.setDataNodeLocations(Collections.singletonList(dataNodeLocation));
        req0.addRegionGroup("root.sg1", schemaRegionSet);
        CreateRegionGroupsPlan req1 = (CreateRegionGroupsPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void OfferRegionMaintainTasksPlanTest() throws IOException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
        regionReplicaSet.setRegionId(new TConsensusGroupId(TConsensusGroupType.DataRegion, 0));
        regionReplicaSet.setDataNodeLocations(Collections.singletonList(dataNodeLocation));
        OfferRegionMaintainTasksPlan plan0 = new OfferRegionMaintainTasksPlan();
        plan0.appendRegionMaintainTask((RegionMaintainTask)new RegionCreateTask(dataNodeLocation, "root.sg", regionReplicaSet));
        plan0.appendRegionMaintainTask((RegionMaintainTask)new RegionCreateTask(dataNodeLocation, "root.sg", regionReplicaSet));
        plan0.appendRegionMaintainTask((RegionMaintainTask)new RegionDeleteTask(dataNodeLocation, new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 2)));
        OfferRegionMaintainTasksPlan plan1 = (OfferRegionMaintainTasksPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan0.serializeToByteBuffer());
        Assert.assertEquals((Object)plan0, (Object)plan1);
    }

    @Test
    public void PollRegionMaintainTaskPlan() throws IOException {
        PollRegionMaintainTaskPlan plan0 = new PollRegionMaintainTaskPlan();
        PollRegionMaintainTaskPlan plan1 = (PollRegionMaintainTaskPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan0.serializeToByteBuffer());
        Assert.assertEquals((Object)plan0, (Object)plan1);
    }

    @Test
    public void CreateSchemaPartitionPlanTest() throws IOException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        String storageGroup = "root.sg0";
        TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot(10);
        TConsensusGroupId consensusGroupId = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 0);
        HashMap<String, SchemaPartitionTable> assignedSchemaPartition = new HashMap<String, SchemaPartitionTable>();
        HashMap<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
        schemaPartitionMap.put(seriesPartitionSlot, consensusGroupId);
        assignedSchemaPartition.put(storageGroup, new SchemaPartitionTable(schemaPartitionMap));
        CreateSchemaPartitionPlan req0 = new CreateSchemaPartitionPlan();
        req0.setAssignedSchemaPartition(assignedSchemaPartition);
        CreateSchemaPartitionPlan req1 = (CreateSchemaPartitionPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void CreateDataPartitionPlanTest() throws IOException {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        String storageGroup = "root.sg0";
        TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot(10);
        TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot(100L);
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
        regionReplicaSet.setRegionId(new TConsensusGroupId(TConsensusGroupType.DataRegion, 0));
        regionReplicaSet.setDataNodeLocations(Collections.singletonList(dataNodeLocation));
        HashMap<String, DataPartitionTable> assignedDataPartition = new HashMap<String, DataPartitionTable>();
        HashMap<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap = new HashMap<TSeriesPartitionSlot, SeriesPartitionTable>();
        HashMap<TTimePartitionSlot, List<TConsensusGroupId>> seriesPartitionMap = new HashMap<TTimePartitionSlot, List<TConsensusGroupId>>();
        seriesPartitionMap.put(timePartitionSlot, Collections.singletonList(new TConsensusGroupId(TConsensusGroupType.DataRegion, 0)));
        dataPartitionMap.put(seriesPartitionSlot, new SeriesPartitionTable(seriesPartitionMap));
        assignedDataPartition.put(storageGroup, new DataPartitionTable(dataPartitionMap));
        CreateDataPartitionPlan req0 = new CreateDataPartitionPlan();
        req0.setAssignedDataPartition(assignedDataPartition);
        CreateDataPartitionPlan req1 = (CreateDataPartitionPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void AutoCleanPartitionTablePlan() throws IOException {
        TreeMap<String, Long> databaseTTLMap = new TreeMap<String, Long>();
        databaseTTLMap.put("root.db1", -1L);
        databaseTTLMap.put("root.db2", 86400000L);
        databaseTTLMap.put("root.db3", 2592000000L);
        TTimePartitionSlot currentTimeSlot = new TTimePartitionSlot(TimePartitionUtils.getTimePartitionSlot((long)System.currentTimeMillis()));
        AutoCleanPartitionTablePlan req0 = new AutoCleanPartitionTablePlan(databaseTTLMap, currentTimeSlot);
        AutoCleanPartitionTablePlan req1 = (AutoCleanPartitionTablePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void AuthorPlanTest() throws IOException, IllegalPathException {
        HashSet<Integer> permissions = new HashSet<Integer>();
        permissions.add(1);
        permissions.add(2);
        AuthorPlan req0 = new AuthorPlan(ConfigPhysicalPlanType.CreateUser, "thulab", "", "passwd", "", new HashSet(), false, new ArrayList());
        AuthorPlan req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.CreateRole, "", "admin", "", "", new HashSet(), false, new ArrayList());
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.UpdateUser, "tempuser", "", "", "newpwd", new HashSet(), false, new ArrayList());
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        ArrayList<PartialPath> nodeNameList = new ArrayList<PartialPath>();
        nodeNameList.add(new PartialPath("root.ln.**"));
        nodeNameList.add(new PartialPath("root.abc.**"));
        req0 = new AuthorPlan(ConfigPhysicalPlanType.GrantUser, "tempuser", "", "", "", permissions, false, nodeNameList);
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.GrantRoleToUser, "tempuser", "temprole", "", "", permissions, false, nodeNameList);
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.GrantRole, "", "temprole", "", "", new HashSet(), false, new ArrayList());
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.RevokeUser, "tempuser", "", "", "", permissions, false, nodeNameList);
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.RevokeRole, "", "temprole", "", "", permissions, false, nodeNameList);
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.RevokeRoleFromUser, "tempuser", "temprole", "", "", new HashSet(), false, new ArrayList());
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.DropUser, "xiaoming", "", "", "", new HashSet(), false, new ArrayList());
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
        req0 = new AuthorPlan(ConfigPhysicalPlanType.DropRole, "", "admin", "", "", new HashSet(), false, new ArrayList());
        req1 = (AuthorPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void registerConfigNodePlanTest() throws IOException {
        ApplyConfigNodePlan req0 = new ApplyConfigNodePlan(new TConfigNodeLocation(0, new TEndPoint("0.0.0.0", 22277), new TEndPoint("0.0.0.0", 22278)));
        ApplyConfigNodePlan req1 = (ApplyConfigNodePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void removeConfigNodePlanTest() throws IOException {
        RemoveConfigNodePlan req0 = new RemoveConfigNodePlan(new TConfigNodeLocation(0, new TEndPoint("0.0.0.0", 22277), new TEndPoint("0.0.0.0", 22278)));
        RemoveConfigNodePlan req1 = (RemoveConfigNodePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void updateProcedureTest() throws IOException {
        DeleteDatabaseProcedure deleteDatabaseProcedure = new DeleteDatabaseProcedure(false);
        deleteDatabaseProcedure.setDeleteDatabaseSchema(new TDatabaseSchema("root.sg"));
        UpdateProcedurePlan updateProcedurePlan0 = new UpdateProcedurePlan();
        updateProcedurePlan0.setProcedure((Procedure)deleteDatabaseProcedure);
        UpdateProcedurePlan updateProcedurePlan1 = (UpdateProcedurePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)updateProcedurePlan0.serializeToByteBuffer());
        Procedure proc = updateProcedurePlan1.getProcedure();
        Assert.assertEquals((Object)proc, (Object)deleteDatabaseProcedure);
        TDataNodeLocation dataNodeLocation0 = new TDataNodeLocation();
        dataNodeLocation0.setDataNodeId(5);
        dataNodeLocation0.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation0.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation0.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation0.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation0.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TConsensusGroupId schemaRegionGroupId = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1);
        TConsensusGroupId dataRegionGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, 0);
        TRegionReplicaSet schemaRegionSet = new TRegionReplicaSet(schemaRegionGroupId, Collections.singletonList(dataNodeLocation0));
        TRegionReplicaSet dataRegionSet = new TRegionReplicaSet(dataRegionGroupId, Collections.singletonList(dataNodeLocation0));
        HashMap<TConsensusGroupId, TRegionReplicaSet> failedRegions = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        failedRegions.put(dataRegionGroupId, dataRegionSet);
        failedRegions.put(schemaRegionGroupId, schemaRegionSet);
        CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
        createRegionGroupsPlan.addRegionGroup("root.sg0", dataRegionSet);
        createRegionGroupsPlan.addRegionGroup("root.sg1", schemaRegionSet);
        CreateRegionGroupsPlan persistPlan = new CreateRegionGroupsPlan();
        persistPlan.addRegionGroup("root.sg0", dataRegionSet);
        persistPlan.addRegionGroup("root.sg1", schemaRegionSet);
        CreateRegionGroupsProcedure procedure0 = new CreateRegionGroupsProcedure(TConsensusGroupType.DataRegion, createRegionGroupsPlan, persistPlan, failedRegions);
        updateProcedurePlan0.setProcedure((Procedure)procedure0);
        updateProcedurePlan1 = (UpdateProcedurePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)updateProcedurePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)updateProcedurePlan0, (Object)updateProcedurePlan1);
    }

    @Test
    public void UpdateProcedurePlanTest() throws IOException {
        UpdateProcedurePlan req0 = new UpdateProcedurePlan();
        DeleteDatabaseProcedure deleteDatabaseProcedure = new DeleteDatabaseProcedure(false);
        TDatabaseSchema tDatabaseSchema = new TDatabaseSchema();
        tDatabaseSchema.setName("root.sg");
        deleteDatabaseProcedure.setDeleteDatabaseSchema(tDatabaseSchema);
        req0.setProcedure((Procedure)deleteDatabaseProcedure);
        UpdateProcedurePlan req1 = (UpdateProcedurePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void DeleteProcedurePlanTest() throws IOException {
        DeleteProcedurePlan req0 = new DeleteProcedurePlan();
        req0.setProcId(1L);
        DeleteProcedurePlan req1 = (DeleteProcedurePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)req0.serializeToByteBuffer());
        Assert.assertEquals((Object)req0, (Object)req1);
    }

    @Test
    public void CreateSchemaTemplatePlanTest() throws IOException, IllegalPathException {
        Template template = this.newSchemaTemplate("template_name");
        CreateSchemaTemplatePlan createSchemaTemplatePlan0 = new CreateSchemaTemplatePlan(template.serialize().array());
        CreateSchemaTemplatePlan createSchemaTemplatePlan1 = (CreateSchemaTemplatePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)createSchemaTemplatePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)createSchemaTemplatePlan0, (Object)createSchemaTemplatePlan1);
    }

    private Template newSchemaTemplate(String name) throws IllegalPathException {
        List<String> measurements = Arrays.asList(name + "_temperature", name + "_status");
        List<TSDataType> dataTypes = Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN);
        List<TSEncoding> encodings = Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN);
        List<CompressionType> compressors = Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY);
        return new Template(name, measurements, dataTypes, encodings, compressors);
    }

    @Test
    public void ExtendSchemaTemplatePlanTest() throws IOException {
        ExtendSchemaTemplatePlan plan = new ExtendSchemaTemplatePlan(new TemplateExtendInfo("template_name", Arrays.asList("template_name_temperature", "template_name_status"), Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY)));
        Assert.assertEquals((Object)plan, (Object)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer()));
    }

    @Test
    public void SetSchemaTemplatePlanTest() throws IOException {
        SetSchemaTemplatePlan setSchemaTemplatePlanPlan0 = new SetSchemaTemplatePlan("template_name_test", "root.in.sg.dw");
        SetSchemaTemplatePlan setSchemaTemplatePlanPlan1 = (SetSchemaTemplatePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)setSchemaTemplatePlanPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)setSchemaTemplatePlanPlan0.getName().equalsIgnoreCase(setSchemaTemplatePlanPlan1.getName()), (Object)setSchemaTemplatePlanPlan0.getPath().equals(setSchemaTemplatePlanPlan1.getPath()));
    }

    @Test
    public void DropSchemaTemplateTest() throws IOException {
        DropSchemaTemplatePlan dropSchemaTemplatePlan = new DropSchemaTemplatePlan("template");
        DropSchemaTemplatePlan deserializedPlan = (DropSchemaTemplatePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropSchemaTemplatePlan.serializeToByteBuffer());
        Assert.assertEquals((Object)dropSchemaTemplatePlan.getTemplateName(), (Object)deserializedPlan.getTemplateName());
    }

    @Test
    public void CreatePipeSinkPlanTest() throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ip", "127.0.0.1");
        attributes.put("port", "6667");
        TPipeSinkInfo pipeSinkInfo = new TPipeSinkInfo().setPipeSinkName("demo").setPipeSinkType("IoTDB").setAttributes(attributes);
        CreatePipeSinkPlanV1 createPipeSinkPlan = new CreatePipeSinkPlanV1(pipeSinkInfo);
        CreatePipeSinkPlanV1 createPipeSinkPlan1 = (CreatePipeSinkPlanV1)ConfigPhysicalPlan.Factory.create((ByteBuffer)createPipeSinkPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)createPipeSinkPlan.getPipeSinkInfo(), (Object)createPipeSinkPlan1.getPipeSinkInfo());
    }

    @Test
    public void DropPipeSinkPlanTest() throws IOException {
        DropPipeSinkPlanV1 dropPipeSinkPlan = new DropPipeSinkPlanV1("demo");
        DropPipeSinkPlanV1 dropPipeSinkPlan1 = (DropPipeSinkPlanV1)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropPipeSinkPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)dropPipeSinkPlan.getPipeSinkName(), (Object)dropPipeSinkPlan1.getPipeSinkName());
    }

    @Test
    public void GetPipeSinkPlanTest() throws IOException {
        GetPipeSinkPlanV1 getPipeSinkPlan = new GetPipeSinkPlanV1("demo");
        GetPipeSinkPlanV1 getPipeSinkPlan1 = (GetPipeSinkPlanV1)ConfigPhysicalPlan.Factory.create((ByteBuffer)getPipeSinkPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)getPipeSinkPlan.getPipeSinkName(), (Object)getPipeSinkPlan1.getPipeSinkName());
        GetPipeSinkPlanV1 getPipeSinkPlanWithNullName = new GetPipeSinkPlanV1();
        GetPipeSinkPlanV1 getPipeSinkPlanWithNullName1 = (GetPipeSinkPlanV1)ConfigPhysicalPlan.Factory.create((ByteBuffer)getPipeSinkPlanWithNullName.serializeToByteBuffer());
        Assert.assertEquals((Object)getPipeSinkPlanWithNullName.getPipeSinkName(), (Object)getPipeSinkPlanWithNullName1.getPipeSinkName());
    }

    @Test
    public void PreCreatePipePlanTest() throws IOException {
        TsFilePipeInfo pipeInfo = new TsFilePipeInfo("name", "demo", PipeStatus.PARTIAL_CREATE, System.currentTimeMillis(), 999L, false);
        PreCreatePipePlanV1 PreCreatePipePlan = new PreCreatePipePlanV1((PipeInfo)pipeInfo);
        PreCreatePipePlanV1 PreCreatePipePlan1 = (PreCreatePipePlanV1)ConfigPhysicalPlan.Factory.create((ByteBuffer)PreCreatePipePlan.serializeToByteBuffer());
        Assert.assertEquals((Object)PreCreatePipePlan.getPipeInfo(), (Object)PreCreatePipePlan1.getPipeInfo());
    }

    @Test
    public void RecordPipeMessagePlanTest() throws IOException {
        RecordPipeMessagePlan recordPipeMessagePlan = new RecordPipeMessagePlan("testPipe", new PipeMessage(PipeMessage.PipeMessageType.ERROR, "testError"));
        RecordPipeMessagePlan recordPipeMessagePlan1 = (RecordPipeMessagePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)recordPipeMessagePlan.serializeToByteBuffer());
        Assert.assertEquals((Object)recordPipeMessagePlan.getPipeName(), (Object)recordPipeMessagePlan1.getPipeName());
        Assert.assertEquals((Object)recordPipeMessagePlan.getPipeMessage().getType(), (Object)recordPipeMessagePlan1.getPipeMessage().getType());
        Assert.assertEquals((Object)recordPipeMessagePlan.getPipeMessage().getMessage(), (Object)recordPipeMessagePlan1.getPipeMessage().getMessage());
    }

    @Test
    public void SetPipeStatusPlanTest() throws IOException {
        SetPipeStatusPlanV1 setPipeStatusPlan = new SetPipeStatusPlanV1("pipe", PipeStatus.PARTIAL_CREATE);
        SetPipeStatusPlanV1 setPipeStatusPlan1 = (SetPipeStatusPlanV1)ConfigPhysicalPlan.Factory.create((ByteBuffer)setPipeStatusPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)setPipeStatusPlan.getPipeName(), (Object)setPipeStatusPlan1.getPipeName());
        Assert.assertEquals((Object)setPipeStatusPlan.getPipeStatus(), (Object)setPipeStatusPlan1.getPipeStatus());
    }

    @Test
    public void CreatePipePlanV2Test() throws IOException {
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        HashMap<String, String> processorAttributes = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        extractorAttributes.put("extractor", "org.apache.iotdb.pipe.extractor.DefaultExtractor");
        processorAttributes.put("processor", "org.apache.iotdb.pipe.processor.SDTFilterProcessor");
        connectorAttributes.put("connector", "org.apache.iotdb.pipe.protocol.ThriftTransporter");
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks.put(1, pipeTaskMeta);
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("testPipe", 121L, extractorAttributes, processorAttributes, connectorAttributes);
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta(pipeTasks);
        CreatePipePlanV2 createPipePlanV2 = new CreatePipePlanV2(pipeStaticMeta, pipeRuntimeMeta);
        CreatePipePlanV2 createPipePlanV21 = (CreatePipePlanV2)ConfigPhysicalPlan.Factory.create((ByteBuffer)createPipePlanV2.serializeToByteBuffer());
        Assert.assertEquals((Object)createPipePlanV2.getPipeStaticMeta(), (Object)createPipePlanV21.getPipeStaticMeta());
        Assert.assertEquals((Object)createPipePlanV2.getPipeRuntimeMeta(), (Object)createPipePlanV21.getPipeRuntimeMeta());
    }

    @Test
    public void AlterPipePlanV2Test() throws IOException {
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        HashMap<String, String> processorAttributes = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        extractorAttributes.put("pattern", "root.db");
        processorAttributes.put("processor", "do-nothing-processor");
        connectorAttributes.put("batch.enable", "false");
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks.put(1, pipeTaskMeta);
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("testPipe", 121L, extractorAttributes, processorAttributes, connectorAttributes);
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta(pipeTasks);
        AlterPipePlanV2 alterPipePlanV2 = new AlterPipePlanV2(pipeStaticMeta, pipeRuntimeMeta);
        AlterPipePlanV2 alterPipePlanV21 = (AlterPipePlanV2)ConfigPhysicalPlan.Factory.create((ByteBuffer)alterPipePlanV2.serializeToByteBuffer());
        Assert.assertEquals((Object)alterPipePlanV2.getPipeStaticMeta(), (Object)alterPipePlanV21.getPipeStaticMeta());
        Assert.assertEquals((Object)alterPipePlanV2.getPipeRuntimeMeta(), (Object)alterPipePlanV21.getPipeRuntimeMeta());
    }

    @Test
    public void SetPipeStatusPlanV2Test() throws IOException {
        SetPipeStatusPlanV2 setPipeStatusPlanV2 = new SetPipeStatusPlanV2("pipe", org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus.RUNNING);
        SetPipeStatusPlanV2 setPipeStatusPlanV21 = (SetPipeStatusPlanV2)ConfigPhysicalPlan.Factory.create((ByteBuffer)setPipeStatusPlanV2.serializeToByteBuffer());
        Assert.assertEquals((Object)setPipeStatusPlanV2.getPipeName(), (Object)setPipeStatusPlanV21.getPipeName());
        Assert.assertEquals((Object)setPipeStatusPlanV2.getPipeStatus(), (Object)setPipeStatusPlanV21.getPipeStatus());
    }

    @Test
    public void DropPipePlanV2Test() throws IOException {
        DropPipePlanV2 dropPipePlanV2 = new DropPipePlanV2("demo");
        DropPipePlanV2 dropPipePlanV21 = (DropPipePlanV2)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropPipePlanV2.serializeToByteBuffer());
        Assert.assertEquals((Object)dropPipePlanV2.getPipeName(), (Object)dropPipePlanV21.getPipeName());
    }

    @Test
    public void OperateMultiplePipesPlanV2Test() throws IOException {
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks.put(1, pipeTaskMeta);
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("testCreate", 5L, Collections.singletonMap("k1", "v1"), Collections.singletonMap("k2", "v2"), Collections.singletonMap("k3", "v3"));
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta(pipeTasks);
        CreatePipePlanV2 createPipePlanV2 = new CreatePipePlanV2(pipeStaticMeta, pipeRuntimeMeta);
        PipeTaskMeta pipeTaskMeta1 = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 2);
        ConcurrentHashMap pipeTasks1 = new ConcurrentHashMap();
        pipeTasks.put(2, pipeTaskMeta1);
        PipeStaticMeta pipeStaticMeta1 = new PipeStaticMeta("testAlter", 6L, Collections.singletonMap("k4", "v4"), Collections.singletonMap("k5", "v5"), Collections.singletonMap("k6", "v6"));
        PipeRuntimeMeta pipeRuntimeMeta1 = new PipeRuntimeMeta(pipeTasks1);
        AlterPipePlanV2 alterPipePlanV2 = new AlterPipePlanV2(pipeStaticMeta1, pipeRuntimeMeta1);
        DropPipePlanV2 dropPipePlanV2 = new DropPipePlanV2("testDrop");
        SetPipeStatusPlanV2 setPipeStatusPlanV2 = new SetPipeStatusPlanV2("testSet", org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus.RUNNING);
        ArrayList<Object> subPlans = new ArrayList<Object>();
        subPlans.add(createPipePlanV2);
        subPlans.add(alterPipePlanV2);
        subPlans.add(dropPipePlanV2);
        subPlans.add(setPipeStatusPlanV2);
        OperateMultiplePipesPlanV2 operateMultiplePipesPlanV2 = new OperateMultiplePipesPlanV2(subPlans);
        OperateMultiplePipesPlanV2 operateMultiplePipesPlanV21 = (OperateMultiplePipesPlanV2)ConfigPhysicalPlan.Factory.create((ByteBuffer)operateMultiplePipesPlanV2.serializeToByteBuffer());
        Assert.assertEquals((Object)operateMultiplePipesPlanV2.getSubPlans(), (Object)operateMultiplePipesPlanV21.getSubPlans());
    }

    @Test
    public void CreatePipePluginPlanTest() throws IOException {
        CreatePipePluginPlan createPipePluginPlan = new CreatePipePluginPlan(new PipePluginMeta("testPlugin", "org.apache.iotdb.TestJar", false, "test.jar", "???"), new Binary("123", TSFileConfig.STRING_CHARSET));
        CreatePipePluginPlan createPipePluginPlan1 = (CreatePipePluginPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)createPipePluginPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)createPipePluginPlan.getPipePluginMeta(), (Object)createPipePluginPlan1.getPipePluginMeta());
        Assert.assertEquals((Object)createPipePluginPlan.getJarFile(), (Object)createPipePluginPlan1.getJarFile());
    }

    @Test
    public void DropPipePluginPlanTest() throws IOException {
        DropPipePluginPlan dropPipePluginPlan = new DropPipePluginPlan("testPlugin");
        DropPipePluginPlan dropPipePluginPlan1 = (DropPipePluginPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropPipePluginPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)dropPipePluginPlan.getPluginName(), (Object)dropPipePluginPlan1.getPluginName());
    }

    @Test
    public void pipeHandleLeaderChangePlanTest() throws IOException {
        HashMap<TConsensusGroupId, Integer> newLeaderMap = new HashMap<TConsensusGroupId, Integer>();
        newLeaderMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), 2);
        newLeaderMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, 2), 3);
        newLeaderMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, 3), 5);
        PipeHandleLeaderChangePlan pipeHandleLeaderChangePlan = new PipeHandleLeaderChangePlan(newLeaderMap);
        PipeHandleLeaderChangePlan pipeHandleLeaderChangePlan1 = (PipeHandleLeaderChangePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)pipeHandleLeaderChangePlan.serializeToByteBuffer());
        Assert.assertEquals((Object)pipeHandleLeaderChangePlan.getConsensusGroupId2NewLeaderIdMap(), (Object)pipeHandleLeaderChangePlan1.getConsensusGroupId2NewLeaderIdMap());
    }

    @Test
    public void pipeHandleMetaChangePlanTest() throws IOException {
        ArrayList<PipeMeta> pipeMetaList = new ArrayList<PipeMeta>();
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("pipeName", 123L, (Map)new HashMap<String, String>(){
            {
                this.put("extractor-key", "extractor-value");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("processor-key-1", "processor-value-1");
                this.put("processor-key-2", "processor-value-2");
            }
        }, (Map)new HashMap<String, String>(){});
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta((ConcurrentMap)new ConcurrentHashMap<Integer, PipeTaskMeta>(){
            {
                this.put(456, new PipeTaskMeta((ProgressIndex)new IoTProgressIndex(Integer.valueOf(1), Long.valueOf(2L)), 987));
                this.put(123, new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 789));
            }
        });
        pipeMetaList.add(new PipeMeta(pipeStaticMeta, pipeRuntimeMeta));
        PipeHandleMetaChangePlan pipeHandleMetaChangePlan1 = new PipeHandleMetaChangePlan(pipeMetaList);
        PipeHandleMetaChangePlan pipeHandleMetaChangePlan2 = (PipeHandleMetaChangePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)pipeHandleMetaChangePlan1.serializeToByteBuffer());
        Assert.assertEquals((Object)pipeHandleMetaChangePlan1.getPipeMetaList(), (Object)pipeHandleMetaChangePlan2.getPipeMetaList());
    }

    @Test
    public void CreateTopicPlanTest() throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("k1", "v1");
        attributes.put("k2", "v2");
        CreateTopicPlan createTopicPlan = new CreateTopicPlan(new TopicMeta("test_topic", 1L, attributes));
        CreateTopicPlan createTopicPlan1 = (CreateTopicPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)createTopicPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)createTopicPlan.getTopicMeta(), (Object)createTopicPlan1.getTopicMeta());
    }

    @Test
    public void DropTopicPlanTest() throws IOException {
        DropTopicPlan dropTopicPlan = new DropTopicPlan("test_topic");
        DropTopicPlan dropTopicPlan1 = (DropTopicPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropTopicPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)dropTopicPlan.getTopicName(), (Object)dropTopicPlan1.getTopicName());
    }

    @Test
    public void AlterTopicPlanTest() throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("k1", "v1");
        attributes.put("k2", "v2");
        AlterTopicPlan alterTopicPlan = new AlterTopicPlan(new TopicMeta("test_topic", 1L, attributes));
        AlterTopicPlan alterTopicPlan1 = (AlterTopicPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)alterTopicPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)alterTopicPlan.getTopicMeta(), (Object)alterTopicPlan1.getTopicMeta());
    }

    @Test
    public void AlterMultipleTopicsTopicPlanTest() throws IOException {
        ArrayList<AlterTopicPlan> subPlans = new ArrayList<AlterTopicPlan>();
        subPlans.add(new AlterTopicPlan(new TopicMeta("test_topic1", 1L, Collections.singletonMap("k1", "v1"))));
        subPlans.add(new AlterTopicPlan(new TopicMeta("test_topic2", 2L, Collections.singletonMap("k2", "v2"))));
        AlterMultipleTopicsPlan alterMultipleTopicsPlan = new AlterMultipleTopicsPlan(subPlans);
        AlterMultipleTopicsPlan alterMultipleTopicsPlan1 = (AlterMultipleTopicsPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)alterMultipleTopicsPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)alterMultipleTopicsPlan.getSubPlans(), (Object)alterMultipleTopicsPlan1.getSubPlans());
    }

    @Test
    public void TopicHandleMetaChangePlanTest() throws IOException {
        ArrayList<TopicMeta> topicMetas = new ArrayList<TopicMeta>();
        topicMetas.add(new TopicMeta("topic1", 1L, Collections.singletonMap("k1", "v1")));
        topicMetas.add(new TopicMeta("topic2", 2L, Collections.singletonMap("k2", "v2")));
        TopicHandleMetaChangePlan topicHandleMetaChangePlan = new TopicHandleMetaChangePlan(topicMetas);
        TopicHandleMetaChangePlan topicHandleMetaChangePlan1 = (TopicHandleMetaChangePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)topicHandleMetaChangePlan.serializeToByteBuffer());
        Assert.assertEquals((Object)topicHandleMetaChangePlan.getTopicMetaList(), (Object)topicHandleMetaChangePlan1.getTopicMetaList());
    }

    @Test
    public void AlterConsumerGroupPlanTest() throws IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("k1", "v1");
        attributes.put("k2", "v2");
        AlterConsumerGroupPlan alterConsumerGroupPlan = new AlterConsumerGroupPlan(new ConsumerGroupMeta("test_consumer_group", 1L, new ConsumerMeta("test_consumer", 2L, attributes)));
        AlterConsumerGroupPlan alterConsumerGroupPlan1 = (AlterConsumerGroupPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)alterConsumerGroupPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)alterConsumerGroupPlan.getConsumerGroupMeta(), (Object)alterConsumerGroupPlan1.getConsumerGroupMeta());
    }

    @Test
    public void ConsumerGroupHandleMetaChangePlanTest() throws IOException {
        ArrayList<ConsumerGroupMeta> consumerGroupMetas = new ArrayList<ConsumerGroupMeta>();
        consumerGroupMetas.add(new ConsumerGroupMeta("cg1", 1L, new ConsumerMeta("c1", 11L, Collections.singletonMap("k1", "v1"))));
        consumerGroupMetas.add(new ConsumerGroupMeta("cg2", 2L, new ConsumerMeta("c2", 22L, Collections.singletonMap("k2", "v2"))));
        ConsumerGroupHandleMetaChangePlan consumerGroupHandleMetaChangePlan = new ConsumerGroupHandleMetaChangePlan(consumerGroupMetas);
        ConsumerGroupHandleMetaChangePlan consumerGroupHandleMetaChangePlan1 = (ConsumerGroupHandleMetaChangePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)consumerGroupHandleMetaChangePlan.serializeToByteBuffer());
        Assert.assertEquals((Object)consumerGroupHandleMetaChangePlan.getConsumerGroupMetaList(), (Object)consumerGroupHandleMetaChangePlan1.getConsumerGroupMetaList());
    }

    @Test
    public void AddTriggerInTablePlanTest() throws IOException, IllegalPathException {
        TriggerInformation triggerInformation = new TriggerInformation(new PartialPath("root.test.**"), "test", "test.class", true, "test.jar", null, TriggerEvent.AFTER_INSERT, TTriggerState.INACTIVE, false, null, FailureStrategy.OPTIMISTIC, "testMD5test");
        AddTriggerInTablePlan addTriggerInTablePlan0 = new AddTriggerInTablePlan(triggerInformation, new Binary(new byte[]{1, 2, 3}));
        AddTriggerInTablePlan addTriggerInTablePlan1 = (AddTriggerInTablePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)addTriggerInTablePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)addTriggerInTablePlan0.getTriggerInformation(), (Object)addTriggerInTablePlan1.getTriggerInformation());
        Assert.assertEquals((Object)addTriggerInTablePlan0.getJarFile(), (Object)addTriggerInTablePlan1.getJarFile());
    }

    @Test
    public void DeleteTriggerInTablePlanTest() throws IOException {
        DeleteTriggerInTablePlan deleteTriggerInTablePlan0 = new DeleteTriggerInTablePlan("test");
        DeleteTriggerInTablePlan deleteTriggerInTablePlan1 = (DeleteTriggerInTablePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)deleteTriggerInTablePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)deleteTriggerInTablePlan0.getTriggerName(), (Object)deleteTriggerInTablePlan1.getTriggerName());
    }

    @Test
    public void UpdateTriggerStateInTablePlanTest() throws IOException {
        UpdateTriggerStateInTablePlan updateTriggerStateInTablePlan0 = new UpdateTriggerStateInTablePlan("test", TTriggerState.ACTIVE);
        UpdateTriggerStateInTablePlan updateTriggerStateInTablePlan1 = (UpdateTriggerStateInTablePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)updateTriggerStateInTablePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)updateTriggerStateInTablePlan0.getTriggerName(), (Object)updateTriggerStateInTablePlan1.getTriggerName());
        Assert.assertEquals((Object)updateTriggerStateInTablePlan0.getTriggerState(), (Object)updateTriggerStateInTablePlan1.getTriggerState());
    }

    @Test
    public void ActiveCQPlanTest() throws IOException {
        ActiveCQPlan activeCQPlan0 = new ActiveCQPlan("testCq", "testCq_md5");
        ActiveCQPlan activeCQPlan1 = (ActiveCQPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)activeCQPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)activeCQPlan0, (Object)activeCQPlan1);
    }

    @Test
    public void AddCQPlanTest() throws IOException {
        long executionTime = System.currentTimeMillis();
        AddCQPlan addCQPlan0 = new AddCQPlan(new TCreateCQReq("testCq1", 1000L, 0L, 1000L, 0L, 0, "select s1 into root.backup.d1.s1 from root.sg.d1", "create cq testCq1 BEGIN select s1 into root.backup.d1.s1 from root.sg.d1 END", "Asia", "root"), "testCq1_md5", executionTime);
        AddCQPlan addCQPlan1 = (AddCQPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)addCQPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)addCQPlan0, (Object)addCQPlan1);
    }

    @Test
    public void DropCQPlanTest() throws IOException {
        DropCQPlan dropCQPlan0 = new DropCQPlan("testCq1");
        DropCQPlan dropCQPlan1 = (DropCQPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropCQPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)dropCQPlan0, (Object)dropCQPlan1);
        dropCQPlan0 = new DropCQPlan("testCq1", "testCq1_md5");
        dropCQPlan1 = (DropCQPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropCQPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)dropCQPlan0, (Object)dropCQPlan1);
    }

    @Test
    public void UpdateCQLastExecTimePlanTest() throws IOException {
        UpdateCQLastExecTimePlan updateCQLastExecTimePlan0 = new UpdateCQLastExecTimePlan("testCq", System.currentTimeMillis(), "testCq_md5");
        UpdateCQLastExecTimePlan updateCQLastExecTimePlan1 = (UpdateCQLastExecTimePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)updateCQLastExecTimePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)updateCQLastExecTimePlan0, (Object)updateCQLastExecTimePlan1);
    }

    @Test
    public void RemoveDataNodePlanTest() throws IOException {
        ArrayList<TDataNodeLocation> locations = new ArrayList<TDataNodeLocation>();
        TDataNodeLocation location1 = new TDataNodeLocation();
        location1.setDataNodeId(1);
        location1.setInternalEndPoint(new TEndPoint("192.168.12.1", 6661));
        location1.setClientRpcEndPoint(new TEndPoint("192.168.12.1", 6662));
        location1.setDataRegionConsensusEndPoint(new TEndPoint("192.168.12.1", 6663));
        location1.setSchemaRegionConsensusEndPoint(new TEndPoint("192.168.12.1", 6664));
        location1.setMPPDataExchangeEndPoint(new TEndPoint("192.168.12.1", 6665));
        locations.add(location1);
        TDataNodeLocation location2 = new TDataNodeLocation();
        location2.setDataNodeId(2);
        location2.setInternalEndPoint(new TEndPoint("192.168.12.2", 6661));
        location2.setClientRpcEndPoint(new TEndPoint("192.168.12.2", 6662));
        location2.setDataRegionConsensusEndPoint(new TEndPoint("192.168.12.2", 6663));
        location2.setSchemaRegionConsensusEndPoint(new TEndPoint("192.168.12.2", 6664));
        location2.setMPPDataExchangeEndPoint(new TEndPoint("192.168.12.2", 6665));
        locations.add(location2);
        RemoveDataNodePlan removeDataNodePlan0 = new RemoveDataNodePlan(new ArrayList(locations));
        RemoveDataNodePlan removeDataNodePlan1 = (RemoveDataNodePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)removeDataNodePlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)removeDataNodePlan0, (Object)removeDataNodePlan1);
    }

    @Test
    public void UpdateTriggersOnTransferNodesPlanTest() throws IOException {
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>(2);
        dataNodeLocations.add(new TDataNodeLocation(10000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)));
        dataNodeLocations.add(new TDataNodeLocation(20000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)));
        UpdateTriggersOnTransferNodesPlan plan0 = new UpdateTriggersOnTransferNodesPlan(dataNodeLocations);
        UpdateTriggersOnTransferNodesPlan plan1 = (UpdateTriggersOnTransferNodesPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan0.serializeToByteBuffer());
        Assert.assertEquals((Object)plan0.getDataNodeLocations(), (Object)plan1.getDataNodeLocations());
    }

    @Test
    public void UpdateTriggerLocationPlanTest() throws IOException {
        UpdateTriggerLocationPlan plan0 = new UpdateTriggerLocationPlan("test", new TDataNodeLocation(10000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)));
        UpdateTriggerLocationPlan plan1 = (UpdateTriggerLocationPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan0.serializeToByteBuffer());
        Assert.assertEquals((Object)plan0.getTriggerName(), (Object)plan1.getTriggerName());
        Assert.assertEquals((Object)plan0.getDataNodeLocation(), (Object)plan1.getDataNodeLocation());
    }

    @Test
    public void CreateFunctionPlanTest() throws IOException {
        UDFInformation udfInformation = new UDFInformation("test1", "test1", false, true, "test1.jar", "12345");
        CreateFunctionPlan createFunctionPlan0 = new CreateFunctionPlan(udfInformation, new Binary(new byte[]{1, 2, 3}));
        CreateFunctionPlan createFunctionPlan1 = (CreateFunctionPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)createFunctionPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)createFunctionPlan0, (Object)createFunctionPlan1);
    }

    @Test
    public void DropFunctionPlanTest() throws IOException {
        DropFunctionPlan dropFunctionPlan0 = new DropFunctionPlan("test");
        DropFunctionPlan dropFunctionPlan1 = (DropFunctionPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)dropFunctionPlan0.serializeToByteBuffer());
        Assert.assertEquals((Object)dropFunctionPlan0, (Object)dropFunctionPlan1);
    }

    @Test
    public void PreUnsetSchemaTemplatePlanTest() throws IllegalPathException, IOException {
        PreUnsetSchemaTemplatePlan plan = new PreUnsetSchemaTemplatePlan(1, new PartialPath("root.sg"));
        PreUnsetSchemaTemplatePlan deserializedPlan = (PreUnsetSchemaTemplatePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((long)plan.getTemplateId(), (long)deserializedPlan.getTemplateId());
        Assert.assertEquals((Object)plan.getPath(), (Object)deserializedPlan.getPath());
    }

    @Test
    public void RollbackPreUnsetSchemaTemplatePlanTest() throws IllegalPathException, IOException {
        RollbackPreUnsetSchemaTemplatePlan plan = new RollbackPreUnsetSchemaTemplatePlan(1, new PartialPath("root.sg"));
        RollbackPreUnsetSchemaTemplatePlan deserializedPlan = (RollbackPreUnsetSchemaTemplatePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((long)plan.getTemplateId(), (long)deserializedPlan.getTemplateId());
        Assert.assertEquals((Object)plan.getPath(), (Object)deserializedPlan.getPath());
    }

    @Test
    public void UnsetSchemaTemplatePlanTest() throws IllegalPathException, IOException {
        UnsetSchemaTemplatePlan plan = new UnsetSchemaTemplatePlan(1, new PartialPath("root.sg"));
        UnsetSchemaTemplatePlan deserializedPlan = (UnsetSchemaTemplatePlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((long)plan.getTemplateId(), (long)deserializedPlan.getTemplateId());
        Assert.assertEquals((Object)plan.getPath(), (Object)deserializedPlan.getPath());
    }

    @Test
    public void PollSpecificRegionMaintainTaskPlanTest() throws IOException {
        HashSet<TConsensusGroupId> regionIdSet = new HashSet<TConsensusGroupId>(Arrays.asList(new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1), new TConsensusGroupId(TConsensusGroupType.DataRegion, 2), new TConsensusGroupId(TConsensusGroupType.DataRegion, 3)));
        PollSpecificRegionMaintainTaskPlan plan = new PollSpecificRegionMaintainTaskPlan(regionIdSet);
        PollSpecificRegionMaintainTaskPlan deserializedPlan = (PollSpecificRegionMaintainTaskPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((Object)deserializedPlan.getRegionIdSet(), regionIdSet);
    }

    @Test
    public void setSpaceQuotaPlanTest() throws IOException {
        TSpaceQuota spaceQuota = new TSpaceQuota();
        spaceQuota.setDeviceNum(2L);
        spaceQuota.setTimeserieNum(3L);
        spaceQuota.setDiskSize(1024L);
        SetSpaceQuotaPlan plan = new SetSpaceQuotaPlan(Collections.singletonList("root.sg"), spaceQuota);
        SetSpaceQuotaPlan deserializedPlan = (SetSpaceQuotaPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((Object)plan.getPrefixPathList(), (Object)deserializedPlan.getPrefixPathList());
        Assert.assertEquals((Object)plan.getSpaceLimit(), (Object)deserializedPlan.getSpaceLimit());
    }

    @Test
    public void setThrottleQuotaPlanTest() throws IOException {
        TTimedQuota timedQuota1 = new TTimedQuota(3600L, 5L);
        TTimedQuota timedQuota2 = new TTimedQuota(3600L, 5L);
        HashMap<ThrottleType, TTimedQuota> throttleLimit = new HashMap<ThrottleType, TTimedQuota>();
        throttleLimit.put(ThrottleType.READ_NUMBER, timedQuota1);
        throttleLimit.put(ThrottleType.READ_SIZE, timedQuota2);
        SetThrottleQuotaPlan plan = new SetThrottleQuotaPlan();
        TThrottleQuota throttleQuota = new TThrottleQuota();
        throttleQuota.setThrottleLimit(throttleLimit);
        throttleQuota.setMemLimit(1000000L);
        throttleQuota.setCpuLimit(100);
        plan.setThrottleQuota(throttleQuota);
        plan.setUserName("tempuser");
        SetThrottleQuotaPlan deserializedPlan = (SetThrottleQuotaPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((Object)plan.getUserName(), (Object)deserializedPlan.getUserName());
        Assert.assertEquals((Object)plan.getThrottleQuota(), (Object)deserializedPlan.getThrottleQuota());
    }

    @Test
    public void updateClusterIdPlanTest() throws IOException {
        String clusterId = String.valueOf(UUID.randomUUID());
        UpdateClusterIdPlan updateClusterIdPlan = new UpdateClusterIdPlan(clusterId);
        UpdateClusterIdPlan deserializedPlan = (UpdateClusterIdPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)updateClusterIdPlan.serializeToByteBuffer());
        Assert.assertEquals((Object)updateClusterIdPlan, (Object)deserializedPlan);
    }

    @Test
    public void pipeEnrichedPlanTest() throws IOException {
        PipeEnrichedPlan plan = new PipeEnrichedPlan((ConfigPhysicalPlan)new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema().setName("sg").setTTL(Long.MAX_VALUE).setSchemaReplicationFactor(3).setDataReplicationFactor(3).setTimePartitionInterval(604800L)));
        Assert.assertEquals((Object)plan, (Object)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer()));
    }

    @Test
    public void pipeUnsetSchemaTemplatePlanTest() throws IOException {
        PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlan = new PipeUnsetSchemaTemplatePlan("template0", "root.sg");
        Assert.assertEquals((Object)pipeUnsetSchemaTemplatePlan, (Object)ConfigPhysicalPlan.Factory.create((ByteBuffer)pipeUnsetSchemaTemplatePlan.serializeToByteBuffer()));
    }

    @Test
    public void pipeDeleteTimeSeriesPlanTest() throws IOException, IllegalPathException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        PipeDeleteTimeSeriesPlan pipeDeleteTimeSeriesPlan = new PipeDeleteTimeSeriesPlan(patternTree.serialize());
        Assert.assertEquals((Object)pipeDeleteTimeSeriesPlan, (Object)ConfigPhysicalPlan.Factory.create((ByteBuffer)pipeDeleteTimeSeriesPlan.serializeToByteBuffer()));
    }

    @Test
    public void pipeDeleteLogicalViewPlanTest() throws IOException, IllegalPathException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.**.s1"));
        patternTree.constructTree();
        PipeDeleteLogicalViewPlan pipeDeleteLogicalViewPlan = new PipeDeleteLogicalViewPlan(patternTree.serialize());
        Assert.assertEquals((Object)pipeDeleteLogicalViewPlan, (Object)ConfigPhysicalPlan.Factory.create((ByteBuffer)pipeDeleteLogicalViewPlan.serializeToByteBuffer()));
    }

    @Test
    public void pipeDeactivateTemplatePlanTest() throws IllegalPathException, IOException {
        PipeDeactivateTemplatePlan pipeDeactivateTemplatePlan = new PipeDeactivateTemplatePlan((Map)new HashMap<PartialPath, List<Template>>(){
            {
                this.put(new PartialPath("root.**.s1"), Collections.singletonList(ConfigPhysicalPlanSerDeTest.this.newSchemaTemplate("template_name")));
            }
        });
        Assert.assertEquals((Object)pipeDeactivateTemplatePlan, (Object)ConfigPhysicalPlan.Factory.create((ByteBuffer)pipeDeactivateTemplatePlan.serializeToByteBuffer()));
    }

    @Test
    public void addRegionLocationPlanTest() throws IOException {
        AddRegionLocationPlan plan = new AddRegionLocationPlan(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), new TDataNodeLocation(10000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)));
        AddRegionLocationPlan dePlan = (AddRegionLocationPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((Object)plan, (Object)dePlan);
    }

    @Test
    public void removeRegionLocationPlanTest() throws IOException {
        RemoveRegionLocationPlan plan = new RemoveRegionLocationPlan(new TConsensusGroupId(TConsensusGroupType.DataRegion, 1), new TDataNodeLocation(10000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)));
        RemoveRegionLocationPlan dePlan = (RemoveRegionLocationPlan)ConfigPhysicalPlan.Factory.create((ByteBuffer)plan.serializeToByteBuffer());
        Assert.assertEquals((Object)plan, (Object)dePlan);
    }
}

