/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.trigger;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;

@NotThreadSafe
public class TriggerTable {
    private final Map<String, TriggerInformation> triggerTable;

    public TriggerTable() {
        this.triggerTable = new HashMap<String, TriggerInformation>();
    }

    public TriggerTable(Map<String, TriggerInformation> triggerTable) {
        this.triggerTable = triggerTable;
    }

    public void addTriggerInformation(String triggerName, TriggerInformation triggerInformation) {
        this.triggerTable.put(triggerName, triggerInformation);
    }

    public void deleteTriggerInformation(String triggerName) {
        this.triggerTable.remove(triggerName);
    }

    public Map<String, TTriggerState> getAllTriggerStates() {
        HashMap<String, TTriggerState> allTriggerStates = new HashMap<String, TTriggerState>(this.triggerTable.size());
        this.triggerTable.forEach((k, v) -> allTriggerStates.put((String)k, v.getTriggerState()));
        return allTriggerStates;
    }

    public Map<String, TriggerInformation> getTable() {
        return this.triggerTable;
    }
}

