/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TriggerInformation {
    private PartialPath pathPattern;
    private String triggerName;
    private String className;
    private String jarName;
    private TTriggerState triggerState;
    private boolean isStateful;
    private TDataNodeLocation dataNodeLocation;

    public TriggerInformation() {
    }

    public TriggerInformation(PartialPath pathPattern, String triggerName, String className, String jarName, TTriggerState triggerState, boolean isStateful, TDataNodeLocation dataNodeLocation) {
        this.pathPattern = pathPattern;
        this.triggerName = triggerName;
        this.className = className;
        this.jarName = jarName;
        this.triggerState = triggerState;
        this.isStateful = isStateful;
        this.dataNodeLocation = dataNodeLocation;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        this.pathPattern.serialize(outputStream);
        ReadWriteIOUtils.write((String)this.triggerName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.className, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.jarName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.triggerState.getValue(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isStateful, (OutputStream)outputStream);
        if (this.isStateful) {
            ThriftCommonsSerDeUtils.serializeTDataNodeLocation(this.dataNodeLocation, outputStream);
        }
    }

    public static TriggerInformation deserialize(ByteBuffer byteBuffer) {
        boolean isStateful;
        TriggerInformation triggerInformation = new TriggerInformation();
        triggerInformation.pathPattern = PartialPath.deserialize(byteBuffer);
        triggerInformation.triggerName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        triggerInformation.className = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        triggerInformation.jarName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        triggerInformation.triggerState = TTriggerState.findByValue((int)ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        triggerInformation.isStateful = isStateful = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (isStateful) {
            triggerInformation.dataNodeLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation(byteBuffer);
        }
        return triggerInformation;
    }

    public PartialPath getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(PartialPath pathPattern) {
        this.pathPattern = pathPattern;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public TTriggerState getTriggerState() {
        return this.triggerState;
    }

    public void setTriggerState(TTriggerState triggerState) {
        this.triggerState = triggerState;
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public void setStateful(boolean stateful) {
        this.isStateful = stateful;
    }

    public TDataNodeLocation getDataNodeLocation() {
        return this.dataNodeLocation;
    }

    public void setDataNodeLocation(TDataNodeLocation dataNodeLocation) {
        this.dataNodeLocation = dataNodeLocation;
    }
}

