/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.tree.ITreeNode;

public abstract class AbstractTreeVisitor<N extends ITreeNode, R>
implements Iterator<R> {
    protected final N root;
    protected final String[] nodes;
    protected final boolean isPrefixMatch;
    protected final Deque<VisitorStackEntry<N>> visitorStack = new ArrayDeque<VisitorStackEntry<N>>();
    protected final Deque<AncestorStackEntry<N>> ancestorStack = new ArrayDeque<AncestorStackEntry<N>>();
    protected boolean shouldVisitSubtree;
    protected N nextMatchedNode;
    protected int patternIndexOfMatchedNode;
    protected int lastMultiLevelWildcardIndexOfMatchedNode;

    protected AbstractTreeVisitor(N root, PartialPath pathPattern, boolean isPrefixMatch) {
        this.root = root;
        this.nodes = this.optimizePathPattern(pathPattern);
        this.isPrefixMatch = isPrefixMatch;
        this.visitorStack.push(new VisitorStackEntry<N>(Collections.singletonList(root).iterator(), 0, 0, -1));
    }

    private String[] optimizePathPattern(PartialPath pathPattern) {
        String[] rawNodes = pathPattern.getNodes();
        ArrayList<String> optimizedNodes = new ArrayList<String>(rawNodes.length);
        for (String rawNode : rawNodes) {
            if (rawNode.equals("**")) {
                optimizedNodes.add("**");
                continue;
            }
            if (rawNode.contains("*")) {
                optimizedNodes.add(rawNode.replace("*", ".*"));
                continue;
            }
            optimizedNodes.add(rawNode);
        }
        return optimizedNodes.toArray(new String[0]);
    }

    @Override
    public boolean hasNext() {
        if (this.nextMatchedNode == null) {
            this.getNext();
        }
        return this.nextMatchedNode != null;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.consumeNextMatchedNode();
    }

    private R consumeNextMatchedNode() {
        R result = this.generateResult();
        if (this.patternIndexOfMatchedNode == this.nodes.length) {
            this.pushChildrenWhilePrefixMatch(this.nextMatchedNode, this.patternIndexOfMatchedNode, this.lastMultiLevelWildcardIndexOfMatchedNode);
        } else if (this.patternIndexOfMatchedNode == this.nodes.length - 1) {
            this.pushChildrenWhileTail(this.nextMatchedNode, this.patternIndexOfMatchedNode, this.lastMultiLevelWildcardIndexOfMatchedNode);
        } else {
            this.pushChildrenWhileInternal(this.nextMatchedNode, this.patternIndexOfMatchedNode, this.lastMultiLevelWildcardIndexOfMatchedNode);
        }
        this.nextMatchedNode = null;
        return result;
    }

    protected void getNext() {
        this.nextMatchedNode = null;
        while (!this.visitorStack.isEmpty()) {
            VisitorStackEntry<N> stackEntry = this.visitorStack.peek();
            Iterator iterator = ((VisitorStackEntry)stackEntry).iterator;
            if (!iterator.hasNext()) {
                this.popStack();
                continue;
            }
            ITreeNode node = (ITreeNode)iterator.next();
            int patternIndex = ((VisitorStackEntry)stackEntry).patternIndex;
            int lastMultiLevelWildcardIndex = ((VisitorStackEntry)stackEntry).lastMultiLevelWildcardIndex;
            if (patternIndex == this.nodes.length) {
                boolean bl = this.shouldVisitSubtree = this.processFullMatchedNode(node) && this.isInternalNode(node);
                if (this.nextMatchedNode != null) {
                    this.saveNextMatchedNodeContext(patternIndex, lastMultiLevelWildcardIndex);
                    return;
                }
                if (!this.shouldVisitSubtree) continue;
                this.pushChildrenWhilePrefixMatch(node, patternIndex, lastMultiLevelWildcardIndex);
                continue;
            }
            if (this.checkIsMatch(patternIndex, node)) {
                if (patternIndex == this.nodes.length - 1) {
                    boolean bl = this.shouldVisitSubtree = this.processFullMatchedNode(node) && this.isInternalNode(node);
                    if (this.nextMatchedNode != null) {
                        this.saveNextMatchedNodeContext(patternIndex, lastMultiLevelWildcardIndex);
                        return;
                    }
                    if (!this.shouldVisitSubtree) continue;
                    this.pushChildrenWhileTail(node, patternIndex, lastMultiLevelWildcardIndex);
                    continue;
                }
                boolean bl = this.shouldVisitSubtree = this.processInternalMatchedNode(node) && this.isInternalNode(node);
                if (this.nextMatchedNode != null) {
                    this.saveNextMatchedNodeContext(patternIndex, lastMultiLevelWildcardIndex);
                    return;
                }
                if (!this.shouldVisitSubtree) continue;
                this.pushChildrenWhileInternal(node, patternIndex, lastMultiLevelWildcardIndex);
                continue;
            }
            if (lastMultiLevelWildcardIndex == -1) continue;
            int lastMatchIndex = this.findLastMatch(node, patternIndex, lastMultiLevelWildcardIndex);
            boolean bl = this.shouldVisitSubtree = this.processInternalMatchedNode(node) && this.isInternalNode(node);
            if (this.nextMatchedNode != null) {
                this.saveNextMatchedNodeContext(lastMatchIndex, lastMultiLevelWildcardIndex);
                return;
            }
            if (!this.shouldVisitSubtree) continue;
            this.pushChildrenWhileInternal(node, lastMatchIndex, lastMultiLevelWildcardIndex);
        }
    }

    private void saveNextMatchedNodeContext(int patternIndexOfMatchedNode, int lastMultiLevelWildcardIndexOfMatchedNode) {
        this.patternIndexOfMatchedNode = patternIndexOfMatchedNode;
        this.lastMultiLevelWildcardIndexOfMatchedNode = lastMultiLevelWildcardIndexOfMatchedNode;
    }

    private int findLastMatch(N node, int patternIndex, int lastMultiLevelWildcardIndex) {
        for (int i = patternIndex - 1; i > lastMultiLevelWildcardIndex; --i) {
            AncestorStackEntry<N> ancestor;
            if (!this.checkIsMatch(i, node)) continue;
            Iterator<AncestorStackEntry<N>> ancestors = this.ancestorStack.iterator();
            boolean allMatch = true;
            for (int j = i - 1; j > lastMultiLevelWildcardIndex && !(ancestor = ancestors.next()).isMatched(j); --j) {
                if (!ancestor.hasBeenChecked(j) && this.checkIsMatch(j, (ITreeNode)((AncestorStackEntry)ancestor).node)) continue;
                ancestors = this.ancestorStack.iterator();
                for (int k = i - 1; k >= j; --k) {
                    ancestors.next().setNotMatched(k);
                }
                allMatch = false;
                break;
            }
            if (!allMatch) continue;
            ancestors = this.ancestorStack.iterator();
            for (int k = i - 1; k > lastMultiLevelWildcardIndex && !(ancestor = ancestors.next()).isMatched(k); --k) {
                ancestor.setMatched(k);
            }
            return i;
        }
        return lastMultiLevelWildcardIndex;
    }

    public void reset() {
        this.visitorStack.clear();
        this.ancestorStack.clear();
        this.nextMatchedNode = null;
        this.visitorStack.push(new VisitorStackEntry<N>(Collections.singletonList(this.root).iterator(), 0, 0, -1));
    }

    private void popStack() {
        this.visitorStack.pop();
        if (!this.visitorStack.isEmpty() && ((VisitorStackEntry)this.visitorStack.peek()).level < this.ancestorStack.size()) {
            this.ancestorStack.pop();
        }
    }

    private void pushChildrenWhilePrefixMatch(N node, int patternIndex, int lastMultiLevelWildcardIndex) {
        this.pushAllChildren(node, patternIndex, lastMultiLevelWildcardIndex);
    }

    private void pushChildrenWhileTail(N node, int patternIndex, int lastMultiLevelWildcardIndex) {
        if (this.nodes[patternIndex].equals("**")) {
            this.pushAllChildren(node, patternIndex, patternIndex);
        } else if (lastMultiLevelWildcardIndex != -1) {
            this.pushAllChildren(node, this.findLastMatch(node, patternIndex, lastMultiLevelWildcardIndex) + 1, lastMultiLevelWildcardIndex);
        } else if (this.isPrefixMatch) {
            this.pushAllChildren(node, patternIndex + 1, lastMultiLevelWildcardIndex);
        }
    }

    private void pushChildrenWhileInternal(N node, int patternIndex, int lastMultiLevelWildcardIndex) {
        if (this.nodes[patternIndex + 1].equals("**")) {
            this.pushAllChildren(node, patternIndex + 1, patternIndex + 1);
        } else if (lastMultiLevelWildcardIndex > -1) {
            this.pushAllChildren(node, patternIndex + 1, lastMultiLevelWildcardIndex);
        } else if (this.nodes[patternIndex + 1].contains("*")) {
            this.pushAllChildren(node, patternIndex + 1, lastMultiLevelWildcardIndex);
        } else {
            this.pushSingleChild(node, patternIndex + 1, lastMultiLevelWildcardIndex);
        }
    }

    protected void pushSingleChild(N parent, int patternIndex, int lastMultiLevelWildcardIndex) {
        N child = this.getChild(parent, this.nodes[patternIndex]);
        if (child != null) {
            this.ancestorStack.push(new AncestorStackEntry<N>(parent, ((VisitorStackEntry)this.visitorStack.peek()).patternIndex, ((VisitorStackEntry)this.visitorStack.peek()).lastMultiLevelWildcardIndex));
            this.visitorStack.push(new VisitorStackEntry<N>(Collections.singletonList(child).iterator(), patternIndex, this.ancestorStack.size(), lastMultiLevelWildcardIndex));
        }
    }

    protected void pushAllChildren(N parent, int patternIndex, int lastMultiLevelWildcardIndex) {
        this.ancestorStack.push(new AncestorStackEntry<N>(parent, ((VisitorStackEntry)this.visitorStack.peek()).patternIndex, ((VisitorStackEntry)this.visitorStack.peek()).lastMultiLevelWildcardIndex));
        this.visitorStack.push(new VisitorStackEntry<N>(this.getChildrenIterator(parent), patternIndex, this.ancestorStack.size(), lastMultiLevelWildcardIndex));
    }

    protected boolean checkIsMatch(int patternIndex, N node) {
        if (this.nodes[patternIndex].equals("**")) {
            return true;
        }
        if (this.nodes[patternIndex].contains("*")) {
            return this.checkOneLevelWildcardMatch(this.nodes[patternIndex], node);
        }
        return this.checkNameMatch(this.nodes[patternIndex], node);
    }

    protected boolean checkOneLevelWildcardMatch(String regex, N node) {
        return Pattern.matches(regex, node.getName());
    }

    protected boolean checkNameMatch(String targetName, N node) {
        return targetName.equals(node.getName());
    }

    protected String[] generateFullPathNodes(N node) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator<AncestorStackEntry<N>> iterator = this.ancestorStack.descendingIterator();
        while (iterator.hasNext()) {
            nodeNames.add(((ITreeNode)((AncestorStackEntry)iterator.next()).node).getName());
        }
        nodeNames.add(node.getName());
        return nodeNames.toArray(new String[0]);
    }

    protected abstract boolean isInternalNode(N var1);

    protected abstract N getChild(N var1, String var2);

    protected abstract Iterator<N> getChildrenIterator(N var1);

    protected abstract boolean processInternalMatchedNode(N var1);

    protected abstract boolean processFullMatchedNode(N var1);

    protected abstract R generateResult();

    protected static class AncestorStackEntry<N> {
        private final N node;
        private final int matchedIndex;
        private final byte[] matchStatus;

        AncestorStackEntry(N node, int matchedIndex, int lastMultiLevelWildcardIndex) {
            this.node = node;
            this.matchedIndex = matchedIndex;
            this.matchStatus = new byte[matchedIndex - lastMultiLevelWildcardIndex + 1];
            this.matchStatus[0] = 1;
            this.matchStatus[this.matchStatus.length - 1] = 1;
        }

        public N getNode() {
            return this.node;
        }

        boolean hasBeenChecked(int index) {
            return this.matchStatus[this.matchedIndex - index] != 0;
        }

        boolean isMatched(int index) {
            return this.matchStatus[this.matchedIndex - index] == 1;
        }

        void setMatched(int index) {
            this.matchStatus[this.matchedIndex - index] = 1;
        }

        void setNotMatched(int index) {
            this.matchStatus[this.matchedIndex - index] = -1;
        }
    }

    protected static class VisitorStackEntry<N> {
        private final Iterator<N> iterator;
        private final int patternIndex;
        private final int level;
        private final int lastMultiLevelWildcardIndex;

        VisitorStackEntry(Iterator<N> iterator, int patternIndex, int level, int lastMultiLevelWildcardIndex) {
            this.iterator = iterator;
            this.patternIndex = patternIndex;
            this.level = level;
            this.lastMultiLevelWildcardIndex = lastMultiLevelWildcardIndex;
        }
    }
}

