/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class SchemaPartitionTable {
    private final Map<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap;

    public SchemaPartitionTable() {
        this.schemaPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, TConsensusGroupId>();
    }

    public SchemaPartitionTable(Map<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap) {
        this.schemaPartitionMap = schemaPartitionMap;
    }

    public Map<TSeriesPartitionSlot, TConsensusGroupId> getSchemaPartitionMap() {
        return this.schemaPartitionMap;
    }

    public boolean getSchemaPartition(List<TSeriesPartitionSlot> partitionSlots, SchemaPartitionTable schemaPartitionTable) {
        AtomicBoolean result = new AtomicBoolean(true);
        if (partitionSlots.isEmpty()) {
            schemaPartitionTable.getSchemaPartitionMap().putAll(this.schemaPartitionMap);
        } else {
            partitionSlots.forEach(seriesPartitionSlot -> {
                if (this.schemaPartitionMap.containsKey(seriesPartitionSlot)) {
                    schemaPartitionTable.getSchemaPartitionMap().put((TSeriesPartitionSlot)seriesPartitionSlot, this.schemaPartitionMap.get(seriesPartitionSlot));
                } else {
                    result.set(false);
                }
            });
        }
        return result.get();
    }

    public Map<TConsensusGroupId, AtomicInteger> createSchemaPartition(SchemaPartitionTable assignedSchemaPartition) {
        ConcurrentHashMap<TConsensusGroupId, AtomicInteger> deltaMap = new ConcurrentHashMap<TConsensusGroupId, AtomicInteger>();
        assignedSchemaPartition.getSchemaPartitionMap().forEach((seriesPartitionSlot, consensusGroupId) -> {
            this.schemaPartitionMap.put((TSeriesPartitionSlot)seriesPartitionSlot, (TConsensusGroupId)consensusGroupId);
            deltaMap.computeIfAbsent((TConsensusGroupId)consensusGroupId, empty -> new AtomicInteger(0)).getAndIncrement();
        });
        return deltaMap;
    }

    public List<TSeriesPartitionSlot> filterUnassignedSchemaPartitionSlots(List<TSeriesPartitionSlot> partitionSlots) {
        Vector<TSeriesPartitionSlot> result = new Vector<TSeriesPartitionSlot>();
        partitionSlots.forEach(seriesPartitionSlot -> {
            if (!this.schemaPartitionMap.containsKey(seriesPartitionSlot)) {
                result.add((TSeriesPartitionSlot)seriesPartitionSlot);
            }
        });
        return result;
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.schemaPartitionMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionEntry : this.schemaPartitionMap.entrySet()) {
            schemaPartitionEntry.getKey().write(protocol);
            schemaPartitionEntry.getValue().write(protocol);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            this.schemaPartitionMap.put(ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot(buffer), ThriftCommonsSerDeUtils.deserializeTConsensusGroupId(buffer));
        }
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot();
            seriesPartitionSlot.read(protocol);
            TConsensusGroupId consensusGroupId = new TConsensusGroupId();
            consensusGroupId.read(protocol);
            this.schemaPartitionMap.put(seriesPartitionSlot, consensusGroupId);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaPartitionTable that = (SchemaPartitionTable)o;
        return this.schemaPartitionMap.equals(that.schemaPartitionMap);
    }

    public int hashCode() {
        return Objects.hash(this.schemaPartitionMap);
    }
}

