/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class DataPartitionTable {
    private final Map<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap;

    public DataPartitionTable() {
        this.dataPartitionMap = new ConcurrentHashMap<TSeriesPartitionSlot, SeriesPartitionTable>();
    }

    public DataPartitionTable(Map<TSeriesPartitionSlot, SeriesPartitionTable> dataPartitionMap) {
        this.dataPartitionMap = dataPartitionMap;
    }

    public Map<TSeriesPartitionSlot, SeriesPartitionTable> getDataPartitionMap() {
        return this.dataPartitionMap;
    }

    public boolean getDataPartition(Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> partitionSlots, DataPartitionTable dataPartitionTable) {
        AtomicBoolean result = new AtomicBoolean(true);
        if (partitionSlots.isEmpty()) {
            dataPartitionTable.getDataPartitionMap().putAll(this.dataPartitionMap);
        } else {
            partitionSlots.forEach((seriesPartitionSlot, timePartitionSlots) -> {
                if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
                    SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
                    if (!this.dataPartitionMap.get(seriesPartitionSlot).getDataPartition((List<TTimePartitionSlot>)timePartitionSlots, seriesPartitionTable)) {
                        result.set(false);
                    }
                    if (!seriesPartitionTable.getSeriesPartitionMap().isEmpty()) {
                        dataPartitionTable.getDataPartitionMap().put((TSeriesPartitionSlot)seriesPartitionSlot, seriesPartitionTable);
                    }
                } else {
                    result.set(false);
                }
            });
        }
        return result.get();
    }

    public TConsensusGroupId getPrecededDataPartition(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        if (this.dataPartitionMap.containsKey(seriesPartitionSlot)) {
            return this.dataPartitionMap.get(seriesPartitionSlot).getPrecededDataPartition(timePartitionSlot, timePartitionInterval);
        }
        return null;
    }

    public Map<TConsensusGroupId, AtomicInteger> createDataPartition(DataPartitionTable assignedDataPartition) {
        ConcurrentHashMap<TConsensusGroupId, AtomicInteger> deltaMap = new ConcurrentHashMap<TConsensusGroupId, AtomicInteger>();
        assignedDataPartition.getDataPartitionMap().forEach((seriesPartitionSlot, seriesPartitionTable) -> this.dataPartitionMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new SeriesPartitionTable()).createDataPartition((SeriesPartitionTable)seriesPartitionTable, (Map<TConsensusGroupId, AtomicInteger>)deltaMap));
        return deltaMap;
    }

    public Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> filterUnassignedDataPartitionSlots(Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> partitionSlots) {
        ConcurrentHashMap<TSeriesPartitionSlot, List<TTimePartitionSlot>> result = new ConcurrentHashMap<TSeriesPartitionSlot, List<TTimePartitionSlot>>();
        partitionSlots.forEach((seriesPartitionSlot, timePartitionSlots) -> result.put((TSeriesPartitionSlot)seriesPartitionSlot, this.dataPartitionMap.computeIfAbsent((TSeriesPartitionSlot)seriesPartitionSlot, empty -> new SeriesPartitionTable()).filterUnassignedDataPartitionSlots((List<TTimePartitionSlot>)timePartitionSlots)));
        return result;
    }

    public static DataPartitionTable convertFromPlainMap(Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>> dataPartitionMap) {
        DataPartitionTable result = new DataPartitionTable();
        dataPartitionMap.forEach((seriesPartitionSlot, seriesPartitionMap) -> result.getDataPartitionMap().put((TSeriesPartitionSlot)seriesPartitionSlot, new SeriesPartitionTable((Map<TTimePartitionSlot, List<TConsensusGroupId>>)seriesPartitionMap)));
        return result;
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.dataPartitionMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TSeriesPartitionSlot, SeriesPartitionTable> seriesPartitionTableEntry : this.dataPartitionMap.entrySet()) {
            seriesPartitionTableEntry.getKey().write(protocol);
            seriesPartitionTableEntry.getValue().serialize(outputStream, protocol);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = ThriftCommonsSerDeUtils.deserializeTSeriesPartitionSlot(buffer);
            SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
            seriesPartitionTable.deserialize(buffer);
            this.dataPartitionMap.put(seriesPartitionSlot, seriesPartitionTable);
        }
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot();
            seriesPartitionSlot.read(protocol);
            SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
            seriesPartitionTable.deserialize(inputStream, protocol);
            this.dataPartitionMap.put(seriesPartitionSlot, seriesPartitionTable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataPartitionTable that = (DataPartitionTable)o;
        return this.dataPartitionMap.equals(that.dataPartitionMap);
    }

    public int hashCode() {
        return Objects.hash(this.dataPartitionMap);
    }
}

