/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.sync;

import java.lang.reflect.Constructor;
import java.net.SocketException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.BaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.sync.SyncThriftClient;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncConfigNodeIServiceClient
extends IConfigNodeRPCService.Client
implements SyncThriftClient,
AutoCloseable {
    private final TEndPoint endPoint;
    private final ClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager;

    public SyncConfigNodeIServiceClient(TProtocolFactory protocolFactory, int connectionTimeout, TEndPoint endPoint, ClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, endPoint.getIp(), endPoint.getPort(), connectionTimeout))));
        this.endPoint = endPoint;
        this.clientManager = clientManager;
        this.getInputProtocol().getTransport().open();
    }

    @Override
    public void close() {
        if (this.clientManager != null) {
            this.clientManager.returnClient(this.endPoint, this);
        }
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    @Override
    public void invalidate() {
        this.getInputProtocol().getTransport().close();
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endPoint);
    }

    public int getTimeout() throws SocketException {
        return ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).getTimeOut();
    }

    public String toString() {
        return String.format("SyncConfigNodeIServiceClient{%s}", this.endPoint);
    }

    public static class Factory
    extends BaseClientFactory<TEndPoint, SyncConfigNodeIServiceClient> {
        public Factory(ClientManager<TEndPoint, SyncConfigNodeIServiceClient> clientManager, ClientFactoryProperty clientFactoryProperty) {
            super(clientManager, clientFactoryProperty);
        }

        public void destroyObject(TEndPoint endpoint, PooledObject<SyncConfigNodeIServiceClient> pooledObject) {
            ((SyncConfigNodeIServiceClient)pooledObject.getObject()).invalidate();
        }

        public PooledObject<SyncConfigNodeIServiceClient> makeObject(TEndPoint endpoint) throws Exception {
            Constructor constructor = SyncConfigNodeIServiceClient.class.getConstructor(TProtocolFactory.class, Integer.TYPE, endpoint.getClass(), this.clientManager.getClass());
            return new DefaultPooledObject((Object)SyncThriftClientWithErrorHandler.newErrorHandler(SyncConfigNodeIServiceClient.class, constructor, this.clientFactoryProperty.getProtocolFactory(), this.clientFactoryProperty.getConnectionTimeoutMs(), endpoint, this.clientManager));
        }

        public boolean validateObject(TEndPoint endpoint, PooledObject<SyncConfigNodeIServiceClient> pooledObject) {
            return pooledObject.getObject() != null && ((SyncConfigNodeIServiceClient)pooledObject.getObject()).getInputProtocol().getTransport().isOpen();
        }
    }
}

