/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientPoolProperty;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncConfigNodeHeartbeatServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeHeartbeatServiceClient;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;

public class ClientPoolFactory {
    private static final CommonConfig conf = CommonDescriptor.getInstance().getConfig();

    private ClientPoolFactory() {
    }

    public static class AsyncDataNodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeHeartbeatServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncDataNodeHeartbeatServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeHeartbeatServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeHeartbeatServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class AsyncConfigNodeHeartbeatServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncConfigNodeHeartbeatServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncConfigNodeHeartbeatServiceClient> createClientPool(ClientManager<TEndPoint, AsyncConfigNodeHeartbeatServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncConfigNodeHeartbeatServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_CONFIGNODE_HEARTBEAT_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class AsyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeInternalServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build(), ThreadName.ASYNC_DATANODE_CLIENT_POOL.getName()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class SyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeInternalServiceClient> {
        @Override
        public KeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeInternalServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataNodeInternalServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }
}

