/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.predefined.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.predefined.jvm.JvmUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class JvmMemoryMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricManager metricManager) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            metricManager.getOrCreateAutoGauge("jvm.buffer.count.buffers", MetricLevel.IMPORTANT, bufferPoolBean, BufferPoolMXBean::getCount, "id", bufferPoolBean.getName());
            metricManager.getOrCreateAutoGauge("jvm.buffer.memory.used.bytes", MetricLevel.IMPORTANT, bufferPoolBean, BufferPoolMXBean::getMemoryUsed, "id", bufferPoolBean.getName());
            metricManager.getOrCreateAutoGauge("jvm.buffer.total.capacity.bytes", MetricLevel.IMPORTANT, bufferPoolBean, BufferPoolMXBean::getTotalCapacity, "id", bufferPoolBean.getName());
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            metricManager.getOrCreateAutoGauge("jvm.memory.used.bytes", MetricLevel.IMPORTANT, memoryPoolBean, mem -> (long)JvmUtils.getUsageValue(mem, MemoryUsage::getUsed), "id", memoryPoolBean.getName(), "area", area);
            metricManager.getOrCreateAutoGauge("jvm.memory.committed.bytes", MetricLevel.IMPORTANT, memoryPoolBean, mem -> (long)JvmUtils.getUsageValue(mem, MemoryUsage::getCommitted), "id", memoryPoolBean.getName(), "area", area);
            metricManager.getOrCreateAutoGauge("jvm.memory.max.bytes", MetricLevel.IMPORTANT, memoryPoolBean, mem -> (long)JvmUtils.getUsageValue(mem, MemoryUsage::getMax), "id", memoryPoolBean.getName(), "area", area);
        }
    }

    @Override
    public PredefinedMetric getType() {
        return PredefinedMetric.JVM;
    }
}

