/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.state.ProcedureState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootProcedureStack<Env> {
    private static final Logger LOG = LoggerFactory.getLogger(RootProcedureStack.class);
    private Set<Procedure<Env>> subprocs = null;
    private ArrayList<Procedure<Env>> subprocStack = null;
    private State state = State.RUNNING;
    private int running = 0;

    public synchronized boolean isFailed() {
        switch (this.state) {
            case ROLLINGBACK: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isRollingback() {
        return this.state == State.ROLLINGBACK;
    }

    protected synchronized boolean setRollback() {
        if (this.running == 0 && this.state == State.FAILED) {
            this.state = State.ROLLINGBACK;
            return true;
        }
        return false;
    }

    protected synchronized void unsetRollback() {
        assert (this.state == State.ROLLINGBACK);
        this.state = State.FAILED;
    }

    protected synchronized long[] getSubprocedureIds() {
        if (this.subprocs == null) {
            return null;
        }
        return this.subprocs.stream().mapToLong(Procedure::getProcId).toArray();
    }

    protected synchronized List<Procedure<Env>> getSubproceduresStack() {
        return this.subprocStack;
    }

    protected synchronized ProcedureException getException() {
        if (this.subprocStack != null) {
            for (Procedure<Env> proc : this.subprocStack) {
                if (!proc.hasException()) continue;
                return proc.getException();
            }
        }
        return null;
    }

    protected synchronized boolean acquire() {
        if (this.state != State.RUNNING) {
            return false;
        }
        ++this.running;
        return true;
    }

    protected synchronized void release() {
        --this.running;
    }

    protected synchronized void abort() {
        if (this.state == State.RUNNING) {
            this.state = State.FAILED;
        }
    }

    protected synchronized void addRollbackStep(Procedure<Env> proc) {
        if (proc.isFailed()) {
            this.state = State.FAILED;
        }
        if (this.subprocStack == null) {
            this.subprocStack = new ArrayList();
        }
        proc.addStackIndex(this.subprocStack.size());
        LOG.trace("Add procedure {} as the {}th rollback step", proc, (Object)this.subprocStack.size());
        this.subprocStack.add(proc);
    }

    protected synchronized void addSubProcedure(Procedure<Env> proc) {
        if (!proc.hasParent()) {
            return;
        }
        if (this.subprocs == null) {
            this.subprocs = new HashSet<Procedure<Env>>();
        }
        this.subprocs.add(proc);
    }

    protected synchronized void loadStack(Procedure<Env> proc) {
        this.addSubProcedure(proc);
        int[] stackIndexes = proc.getStackIndexes();
        if (stackIndexes != null) {
            int diff;
            if (this.subprocStack == null) {
                this.subprocStack = new ArrayList();
            }
            if ((diff = 1 + stackIndexes[stackIndexes.length - 1] - this.subprocStack.size()) > 0) {
                this.subprocStack.ensureCapacity(1 + stackIndexes[stackIndexes.length - 1]);
                while (diff-- > 0) {
                    this.subprocStack.add(null);
                }
            }
            for (int stackIndex : stackIndexes) {
                this.subprocStack.set(stackIndex, proc);
            }
        }
        if (proc.getState() == ProcedureState.ROLLEDBACK) {
            this.state = State.ROLLINGBACK;
        } else if (proc.isFailed()) {
            this.state = State.FAILED;
        }
    }

    private static enum State {
        RUNNING,
        FAILED,
        ROLLINGBACK;

    }
}

