/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.heartbeat;

import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.mpp.rpc.thrift.THeartbeatResp;

public class NodeHeartbeatSample {
    private final long sendTimestamp;
    private final long receiveTimestamp;
    private NodeStatus status;
    private short cpu;
    private short memory;

    public NodeHeartbeatSample(long sendTimestamp, long receiveTimestamp) {
        this.sendTimestamp = sendTimestamp;
        this.receiveTimestamp = receiveTimestamp;
    }

    public NodeHeartbeatSample(THeartbeatResp heartbeatResp, long receiveTimestamp) {
        this.sendTimestamp = heartbeatResp.getHeartbeatTimestamp();
        this.receiveTimestamp = receiveTimestamp;
        this.status = NodeStatus.parse((String)heartbeatResp.getStatus());
        this.cpu = heartbeatResp.getCpu();
        this.memory = heartbeatResp.getMemory();
    }

    public long getSendTimestamp() {
        return this.sendTimestamp;
    }

    public long getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public short getCpu() {
        return this.cpu;
    }

    public short getMemory() {
        return this.memory;
    }
}

