/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.heartbeat;

import java.util.LinkedList;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.load.heartbeat.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.heartbeat.NodeHeartbeatSample;

public class ConfigNodeHeartbeatCache
extends BaseNodeCache {
    private final TConfigNodeLocation configNodeLocation;

    public ConfigNodeHeartbeatCache(TConfigNodeLocation configNodeLocation) {
        this.configNodeLocation = configNodeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheHeartbeatSample(NodeHeartbeatSample newHeartbeatSample) {
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.size() == 0 || ((NodeHeartbeatSample)this.slidingWindow.getLast()).getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateNodeStatus() {
        if (this.configNodeLocation.getInternalEndPoint().equals(NodeManager.CURRENT_NODE)) {
            this.status = NodeStatus.Running;
            return false;
        }
        long lastSendTime = 0L;
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.size() > 0) {
                lastSendTime = ((NodeHeartbeatSample)this.slidingWindow.getLast()).getSendTimestamp();
            }
        }
        String originStatus = this.status.getStatus();
        this.status = System.currentTimeMillis() - lastSendTime > 20000L ? NodeStatus.Unknown : NodeStatus.Running;
        return !this.status.getStatus().equals(originStatus);
    }

    @Override
    public long getLoadScore() {
        return this.status == NodeStatus.Running ? 0L : Long.MAX_VALUE;
    }

    @Override
    public NodeStatus getNodeStatus() {
        return NodeStatus.parse((String)this.status.getStatus());
    }
}

