/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.datanode.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.DropFunctionPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionRequest;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionRequest;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFManager.class);
    private final ConfigManager configManager;
    private final UDFInfo udfInfo;

    public UDFManager(ConfigManager configManager, UDFInfo udfInfo) {
        this.configManager = configManager;
        this.udfInfo = udfInfo;
    }

    public TSStatus createFunction(String functionName, String className, List<String> uris) {
        try {
            this.udfInfo.validateBeforeRegistration(functionName, className, uris);
            TSStatus configNodeStatus = this.configManager.getConsensusManager().write(new CreateFunctionPlan(functionName, className, uris)).getStatus();
            if (configNodeStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return configNodeStatus;
            }
            return RpcUtils.squashResponseStatusList(this.createFunctionOnDataNodes(functionName, className, uris));
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to register UDF %s(class name: %s, uris: %s), because of exception: %s", functionName, className, uris, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    private List<TSStatus> createFunctionOnDataNodes(String functionName, String className, List<String> uris) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        List<TSStatus> dataNodeResponseStatus = Collections.synchronizedList(new ArrayList(dataNodeLocationMap.size()));
        TCreateFunctionRequest request = new TCreateFunctionRequest(functionName, className, uris);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(request, dataNodeLocationMap, DataNodeRequestType.CREATE_FUNCTION, dataNodeResponseStatus);
        return dataNodeResponseStatus;
    }

    public TSStatus dropFunction(String functionName) {
        try {
            List<TSStatus> nodeResponseList = this.dropFunctionOnDataNodes(functionName);
            TSStatus configNodeStatus = this.configManager.getConsensusManager().write(new DropFunctionPlan(functionName)).getStatus();
            nodeResponseList.add(configNodeStatus);
            return RpcUtils.squashResponseStatusList(nodeResponseList);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to deregister UDF %s, because of exception: %s", functionName, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    private List<TSStatus> dropFunctionOnDataNodes(String functionName) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        List<TSStatus> dataNodeResponseStatus = Collections.synchronizedList(new ArrayList(dataNodeLocationMap.size()));
        TDropFunctionRequest request = new TDropFunctionRequest(functionName);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(request, dataNodeLocationMap, DataNodeRequestType.DROP_FUNCTION, dataNodeResponseStatus);
        return dataNodeResponseStatus;
    }
}

