/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum ColumnEncoding {
    BYTE_ARRAY(0),
    INT32_ARRAY(1),
    INT64_ARRAY(2),
    BINARY_ARRAY(3),
    RLE(4);

    private final byte value;

    private ColumnEncoding(byte value) {
        this.value = value;
    }

    public static ColumnEncoding deserializeFrom(ByteBuffer buffer) {
        return ColumnEncoding.getColumnEncoding(buffer.get());
    }

    public void serializeTo(DataOutputStream stream) throws IOException {
        stream.writeByte(this.value);
    }

    private static ColumnEncoding getColumnEncoding(byte value) {
        switch (value) {
            case 0: {
                return BYTE_ARRAY;
            }
            case 1: {
                return INT32_ARRAY;
            }
            case 2: {
                return INT64_ARRAY;
            }
            case 3: {
                return BINARY_ARRAY;
            }
            case 4: {
                return RLE;
            }
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }
}

