/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.metrics.RaftLogMetricsBase;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Preconditions;

public class MemoryRaftLog
extends RaftLogBase {
    private final EntryList entries = new EntryList();
    private final AtomicReference<RaftStorageMetadata> metadata = new AtomicReference<RaftStorageMetadata>(RaftStorageMetadata.getDefault());
    private final RaftLogMetricsBase metrics;

    public MemoryRaftLog(RaftGroupMemberId memberId, LongSupplier commitIndexSupplier, RaftProperties properties) {
        super(memberId, commitIndexSupplier, properties);
        this.metrics = new RaftLogMetricsBase(memberId);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.metrics.unregister();
    }

    public RaftLogMetricsBase getRaftLogMetrics() {
        return this.metrics;
    }

    public RaftProtos.LogEntryProto get(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            RaftProtos.LogEntryProto logEntryProto = this.entries.get(Math.toIntExact(index));
            return logEntryProto;
        }
    }

    public RaftLog.EntryWithData getEntryWithData(long index) {
        return this.newEntryWithData(this.get(index), null);
    }

    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.entries.getTermIndex(Math.toIntExact(index));
            return termIndex;
        }
    }

    public LogEntryHeader[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            if (startIndex >= (long)this.entries.size()) {
                LogEntryHeader[] logEntryHeaderArray = null;
                return logEntryHeaderArray;
            }
            int from = Math.toIntExact(startIndex);
            int to = Math.toIntExact(Math.min((long)this.entries.size(), endIndex));
            LogEntryHeader[] headers = new LogEntryHeader[to - from];
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = this.entries.getLogEntryHeader(i);
            }
            LogEntryHeader[] logEntryHeaderArray = headers;
            return logEntryHeaderArray;
        }
    }

    @Override
    protected CompletableFuture<Long> truncateImpl(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            Preconditions.assertTrue((index >= 0L ? 1 : 0) != 0);
            this.entries.truncate(Math.toIntExact(index));
        }
        return CompletableFuture.completedFuture(index);
    }

    @Override
    protected CompletableFuture<Long> purgeImpl(long index) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            Preconditions.assertTrue((index >= 0L ? 1 : 0) != 0);
            this.entries.purge(Math.toIntExact(index));
        }
        return CompletableFuture.completedFuture(index);
    }

    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.entries.getTermIndex(this.entries.size() - 1);
            return termIndex;
        }
    }

    @Override
    protected CompletableFuture<Long> appendEntryImpl(RaftProtos.LogEntryProto entry) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            this.validateLogEntry(entry);
            this.entries.add(entry);
        }
        return CompletableFuture.completedFuture(entry.getIndex());
    }

    public long getStartIndex() {
        return this.entries.size() == 0 ? -1L : this.entries.getTermIndex(0).getIndex();
    }

    @Override
    public List<CompletableFuture<Long>> appendImpl(RaftProtos.LogEntryProto ... logEntryProtos) {
        this.checkLogState();
        if (logEntryProtos == null || logEntryProtos.length == 0) {
            return Collections.emptyList();
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            ArrayList<CompletableFuture<Long>> futures;
            boolean toTruncate = false;
            int truncateIndex = (int)logEntryProtos[0].getIndex();
            int index = 0;
            while ((long)truncateIndex < this.getNextIndex() && index < logEntryProtos.length) {
                if (this.entries.get(truncateIndex).getTerm() != logEntryProtos[index].getTerm()) {
                    toTruncate = true;
                    break;
                }
                ++index;
                ++truncateIndex;
            }
            if (toTruncate) {
                futures = new ArrayList(logEntryProtos.length - index + 1);
                futures.add(this.truncate(truncateIndex));
            } else {
                futures = new ArrayList<CompletableFuture<Long>>(logEntryProtos.length - index);
            }
            for (int i = index; i < logEntryProtos.length; ++i) {
                this.entries.add(logEntryProtos[i]);
                futures.add(CompletableFuture.completedFuture(logEntryProtos[i].getIndex()));
            }
            ArrayList<CompletableFuture<Long>> arrayList = futures;
            return arrayList;
        }
    }

    public String getEntryString() {
        return "entries=" + this.entries;
    }

    public long getFlushIndex() {
        return this.getNextIndex() - 1L;
    }

    public void persistMetadata(RaftStorageMetadata newMetadata) {
        this.metadata.set(newMetadata);
    }

    public RaftStorageMetadata loadMetadata() {
        return this.metadata.get();
    }

    public CompletableFuture<Long> onSnapshotInstalled(long lastSnapshotIndex) {
        return CompletableFuture.completedFuture(lastSnapshotIndex);
    }

    static class EntryList {
        private final List<RaftProtos.LogEntryProto> entries = new ArrayList<RaftProtos.LogEntryProto>();

        EntryList() {
        }

        RaftProtos.LogEntryProto get(int i) {
            return i >= 0 && i < this.entries.size() ? this.entries.get(i) : null;
        }

        TermIndex getTermIndex(int i) {
            return TermIndex.valueOf((RaftProtos.LogEntryProto)this.get(i));
        }

        private LogEntryHeader getLogEntryHeader(int i) {
            return LogEntryHeader.valueOf((RaftProtos.LogEntryProto)this.get(i));
        }

        int size() {
            return this.entries.size();
        }

        void truncate(int index) {
            if (this.entries.size() > index) {
                this.entries.subList(index, this.entries.size()).clear();
            }
        }

        void purge(int index) {
            if (this.entries.size() > index) {
                this.entries.subList(0, index).clear();
            }
        }

        void add(RaftProtos.LogEntryProto entry) {
            this.entries.add(entry);
        }
    }
}

