/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.consensus.config.MultiLeaderConfig;
import org.apache.iotdb.consensus.multileader.logdispatcher.IndexController;
import org.apache.iotdb.consensus.multileader.logdispatcher.PendingBatch;

public class SyncStatus {
    private final MultiLeaderConfig config;
    private final IndexController controller;
    private final List<PendingBatch> pendingBatches = new LinkedList<PendingBatch>();

    public SyncStatus(IndexController controller, MultiLeaderConfig config) {
        this.controller = controller;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNextBatch(PendingBatch batch) throws InterruptedException {
        SyncStatus syncStatus = this;
        synchronized (syncStatus) {
            while (this.pendingBatches.size() >= this.config.getReplication().getMaxPendingBatch()) {
                this.wait();
            }
            this.pendingBatches.add(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBatch(PendingBatch batch) {
        SyncStatus syncStatus = this;
        synchronized (syncStatus) {
            batch.setSynced(true);
            if (this.pendingBatches.size() > 0 && this.pendingBatches.get(0).equals(batch)) {
                Iterator<PendingBatch> iterator = this.pendingBatches.iterator();
                PendingBatch current = iterator.next();
                while (current.isSynced()) {
                    this.controller.updateAndGet(current.getEndIndex());
                    iterator.remove();
                    if (!iterator.hasNext()) break;
                    current = iterator.next();
                }
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSendingIndex() {
        SyncStatus syncStatus = this;
        synchronized (syncStatus) {
            return 1L + (this.pendingBatches.isEmpty() ? this.controller.getCurrentIndex() : this.pendingBatches.get(this.pendingBatches.size() - 1).getEndIndex());
        }
    }

    public List<PendingBatch> getPendingBatches() {
        return this.pendingBatches;
    }
}

