/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.writelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.writelog.ILogReader;
import org.apache.iotdb.db.utils.writelog.SingleFileLogReader;

public class MultiFileLogReader
implements ILogReader {
    private SingleFileLogReader currentReader;
    private File[] files;
    private int fileIdx = 0;

    public MultiFileLogReader(File[] files) {
        this.files = files;
    }

    @Override
    public void close() {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    @Override
    public boolean hasNext() throws FileNotFoundException {
        if (this.files == null || this.files.length == 0) {
            return false;
        }
        if (this.currentReader == null) {
            this.currentReader = new SingleFileLogReader(this.files[this.fileIdx++]);
        }
        if (this.currentReader.hasNext()) {
            return true;
        }
        while (this.fileIdx < this.files.length) {
            this.currentReader.open(this.files[this.fileIdx++]);
            if (!this.currentReader.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PhysicalPlan next() throws FileNotFoundException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentReader.next();
    }
}

