/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.sync.SyncConstant;
import org.apache.iotdb.db.exception.SyncConnectionException;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.sender.pipe.IoTDBPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeMessage;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.db.sync.transport.client.ISyncClient;
import org.apache.iotdb.db.sync.transport.client.SyncClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    private static final Logger logger = LoggerFactory.getLogger(SenderManager.class);
    protected ISyncClient syncClient;
    private Pipe pipe;
    private PipeSink pipeSink;
    protected ExecutorService transportExecutorService;
    private Future transportFuture;

    public SenderManager(Pipe pipe, IoTDBPipeSink pipeSink) {
        this.pipe = pipe;
        this.pipeSink = pipeSink;
        this.transportExecutorService = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)(ThreadName.SYNC_SENDER_PIPE.getName() + "-" + pipe.getName()));
        this.syncClient = SyncClientFactory.createSyncClient(pipe, pipeSink);
    }

    public void start() {
        this.transportFuture = this.transportExecutorService.submit(this::takePipeDataAndTransport);
    }

    public void stop() {
        if (this.transportFuture != null) {
            this.transportFuture.cancel(true);
        }
    }

    public boolean close() throws InterruptedException {
        this.transportExecutorService.shutdownNow();
        boolean isClosed = this.transportExecutorService.awaitTermination(SyncConstant.DEFAULT_WAITING_FOR_STOP_MILLISECONDS, TimeUnit.MILLISECONDS);
        return isClosed;
    }

    private void takePipeDataAndTransport() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!this.syncClient.handshake()) {
                        SyncService.getInstance().receiveMsg(PipeMessage.MsgType.ERROR, String.format("Can not handshake with %s", this.pipeSink));
                    }
                    while (!Thread.currentThread().isInterrupted()) {
                        PipeData pipeData = this.pipe.take();
                        if (!this.syncClient.send(pipeData)) {
                            logger.error(String.format("Can not transfer pipedata %s, skip it.", pipeData));
                            SyncService.getInstance().receiveMsg(PipeMessage.MsgType.WARN, String.format("Transfer piepdata %s error, skip it.", pipeData.getSerialNumber()));
                        }
                        this.pipe.commit();
                    }
                }
                catch (SyncConnectionException e) {
                    logger.error(String.format("Connect to receiver %s error, because %s.", new Object[]{this.pipeSink, e}));
                }
            }
        }
        catch (InterruptedException e) {
            logger.info("Interrupted by pipe, exit transport.");
        }
        finally {
            this.syncClient.close();
        }
    }

    public void setSyncClient(ISyncClient syncClient) {
        this.syncClient = syncClient;
    }
}

