/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.sync.pipedata.DeletionPipeData;
import org.apache.iotdb.db.sync.pipedata.SchemaPipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeData {
    private static final Logger logger = LoggerFactory.getLogger(PipeData.class);
    protected long serialNumber;

    public PipeData() {
    }

    public PipeData(long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public abstract PipeDataType getType();

    public long serialize(DataOutputStream stream) throws IOException {
        long serializeSize = 0L;
        stream.writeByte((byte)this.getType().ordinal());
        ++serializeSize;
        stream.writeLong(this.serialNumber);
        return serializeSize += 8L;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.serialize(new DataOutputStream(byteStream));
        return byteStream.toByteArray();
    }

    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        this.serialNumber = stream.readLong();
    }

    public static PipeData createPipeData(DataInputStream stream) throws IOException, IllegalPathException {
        PipeData pipeData;
        PipeDataType type = PipeDataType.values()[stream.readByte()];
        switch (type) {
            case TSFILE: {
                pipeData = new TsFilePipeData();
                break;
            }
            case DELETION: {
                pipeData = new DeletionPipeData();
                break;
            }
            case SCHEMA: {
                pipeData = new SchemaPipeData();
                break;
            }
            default: {
                logger.error("Deserialize PipeData error because Unknown type {}.", (Object)type);
                throw new UnsupportedOperationException("Deserialize PipeData error because Unknown type " + (Object)((Object)type));
            }
        }
        pipeData.deserialize(stream);
        return pipeData;
    }

    public static PipeData createPipeData(byte[] bytes) throws IllegalPathException, IOException {
        return PipeData.createPipeData(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public abstract ILoader createLoader();

    public static enum PipeDataType {
        TSFILE,
        DELETION,
        SCHEMA;

    }
}

