/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.common.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.commons.sync.SyncPathUtil;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.sender.pipe.PipeMessage;

public class SyncLogWriter {
    private BufferedWriter pipeInfoWriter;
    private BufferedWriter pipeMsgWriter;

    private SyncLogWriter() {
    }

    public void getBufferedWriter() throws IOException {
        if (this.pipeInfoWriter == null || this.pipeMsgWriter == null) {
            File logFile = new File(SyncPathUtil.getSysDir(), "syncService.log");
            File msgFile = new File(SyncPathUtil.getSysDir(), "syncMessage.log");
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdirs();
            }
            this.pipeInfoWriter = new BufferedWriter(new FileWriter(logFile, true));
            this.pipeMsgWriter = new BufferedWriter(new FileWriter(msgFile, true));
        }
    }

    public synchronized void addPipeSink(CreatePipeSinkPlan plan) throws IOException {
        this.getBufferedWriter();
        this.pipeInfoWriter.write(Operator.OperatorType.CREATE_PIPESINK.name());
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.write(plan.toString());
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.flush();
    }

    public synchronized void addPipeSink(CreatePipeSinkStatement createPipeSinkStatement) throws IOException {
        this.getBufferedWriter();
        this.pipeInfoWriter.write(createPipeSinkStatement.getType().name());
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.write(createPipeSinkStatement.toString());
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.flush();
    }

    public synchronized void dropPipeSink(String pipeSinkName) throws IOException {
        this.getBufferedWriter();
        this.pipeInfoWriter.write(Operator.OperatorType.DROP_PIPESINK.name());
        this.pipeInfoWriter.write("#");
        this.pipeInfoWriter.write(pipeSinkName);
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.flush();
    }

    public synchronized void addPipe(CreatePipePlan plan, long pipeCreateTime) throws IOException {
        this.getBufferedWriter();
        this.pipeInfoWriter.write(Operator.OperatorType.CREATE_PIPE.name());
        this.pipeInfoWriter.write("#");
        this.pipeInfoWriter.write(String.valueOf(pipeCreateTime));
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.write(plan.toString());
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.flush();
    }

    public synchronized void addPipe(CreatePipeStatement createPipeStatement, long pipeCreateTime) throws IOException {
        this.getBufferedWriter();
        this.pipeInfoWriter.write(createPipeStatement.getType().name());
        this.pipeInfoWriter.write("#");
        this.pipeInfoWriter.write(String.valueOf(pipeCreateTime));
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.write(createPipeStatement.toString());
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.flush();
    }

    public synchronized void operatePipe(String pipeName, StatementType type) throws IOException {
        this.getBufferedWriter();
        this.pipeInfoWriter.write(type.name());
        this.pipeInfoWriter.write("#");
        this.pipeInfoWriter.write(pipeName);
        this.pipeInfoWriter.newLine();
        this.pipeInfoWriter.flush();
    }

    public void writePipeMsg(String pipeIdentifier, PipeMessage pipeMessage) throws IOException {
        this.getBufferedWriter();
        this.pipeMsgWriter.write(String.format("%s,%s,%s", new Object[]{pipeIdentifier, pipeMessage.getType(), pipeMessage.getMsg()}));
        this.pipeMsgWriter.newLine();
        this.pipeMsgWriter.flush();
    }

    public void comsumePipeMsg(String pipeIdentifier) throws IOException {
        this.getBufferedWriter();
        this.pipeMsgWriter.write(String.format("%s,read", pipeIdentifier));
        this.pipeMsgWriter.newLine();
        this.pipeMsgWriter.flush();
    }

    public void close() throws IOException {
        if (this.pipeInfoWriter != null) {
            this.pipeInfoWriter.close();
            this.pipeInfoWriter = null;
        }
        if (this.pipeMsgWriter != null) {
            this.pipeMsgWriter.close();
            this.pipeMsgWriter = null;
        }
    }

    public static SyncLogWriter getInstance() {
        return SyncLoggerHolder.INSTANCE;
    }

    private static class SyncLoggerHolder {
        private static final SyncLogWriter INSTANCE = new SyncLogWriter();

        private SyncLoggerHolder() {
        }
    }
}

