/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.groupby.SlidingWindowGroupByExecutor;
import org.apache.iotdb.db.utils.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.timerangeiterator.TimeRangeIteratorFactory;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public abstract class GroupByTimeDataSet
extends QueryDataSet {
    protected long queryId;
    protected long interval;
    protected long slidingStep;
    protected long startTime;
    protected long endTime;
    protected TimeRange curAggrTimeRange;
    protected boolean hasCachedTimeInterval;
    protected TimeRange curPreAggrTimeRange;
    protected boolean leftCRightO;
    protected boolean isIntervalByMonth = false;
    protected boolean isSlidingStepByMonth = false;
    ITimeRangeIterator aggrWindowIterator;
    ITimeRangeIterator preAggrWindowIterator;
    protected AggregateResult[] curAggregateResults;
    protected SlidingWindowGroupByExecutor[] slidingWindowGroupByExecutors;

    public GroupByTimeDataSet() {
    }

    public GroupByTimeDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(new ArrayList<PartialPath>(groupByTimePlan.getDeduplicatedPaths()), groupByTimePlan.getDeduplicatedDataTypes(), groupByTimePlan.isAscending());
        this.initGroupByTimeDataSetFields(context, groupByTimePlan);
    }

    protected void initGroupByTimeDataSetFields(QueryContext context, GroupByTimePlan groupByTimePlan) {
        this.queryId = context.getQueryId();
        this.interval = groupByTimePlan.getInterval();
        this.slidingStep = groupByTimePlan.getSlidingStep();
        if (groupByTimePlan instanceof GroupByTimeFillPlan) {
            this.startTime = ((GroupByTimeFillPlan)groupByTimePlan).getQueryStartTime();
            this.endTime = ((GroupByTimeFillPlan)groupByTimePlan).getQueryEndTime();
        } else {
            this.startTime = groupByTimePlan.getStartTime();
            this.endTime = groupByTimePlan.getEndTime();
        }
        this.leftCRightO = groupByTimePlan.isLeftCRightO();
        this.ascending = groupByTimePlan.isAscending();
        this.isIntervalByMonth = groupByTimePlan.isIntervalByMonth();
        this.isSlidingStepByMonth = groupByTimePlan.isSlidingStepByMonth();
        if (this.isIntervalByMonth) {
            this.interval /= 2592000000L;
        }
        if (this.isSlidingStepByMonth) {
            this.slidingStep /= 2592000000L;
        }
        this.aggrWindowIterator = TimeRangeIteratorFactory.getTimeRangeIterator(this.startTime, this.endTime, this.interval, this.slidingStep, this.ascending, this.isIntervalByMonth, this.isSlidingStepByMonth, false);
        this.preAggrWindowIterator = TimeRangeIteratorFactory.getTimeRangeIterator(this.startTime, this.endTime, this.interval, this.slidingStep, this.ascending, this.isIntervalByMonth, this.isSlidingStepByMonth, true);
        this.curAggrTimeRange = this.aggrWindowIterator.nextTimeRange();
        this.curPreAggrTimeRange = this.preAggrWindowIterator.nextTimeRange();
        this.hasCachedTimeInterval = true;
        this.slidingWindowGroupByExecutors = new SlidingWindowGroupByExecutor[this.paths.size()];
    }

    public boolean hasNextWithoutConstraint() {
        if (this.hasCachedTimeInterval) {
            return true;
        }
        if (!this.aggrWindowIterator.hasNextTimeRange()) {
            return false;
        }
        this.curAggrTimeRange = this.aggrWindowIterator.nextTimeRange();
        this.hasCachedTimeInterval = true;
        return true;
    }

    public abstract RowRecord nextWithoutConstraint() throws IOException;

    public long getStartTime() {
        return this.startTime;
    }

    public TimeRange nextTimePartition() {
        this.hasCachedTimeInterval = false;
        return this.curAggrTimeRange;
    }
}

