/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class InsertTabletPlan
extends InsertPlan
implements WALEntryValue {
    private static final String DATATYPE_UNSUPPORTED = "Data type %s is not supported.";
    private long[] times;
    private BitMap[] bitMaps;
    private Object[] columns;
    private int rowCount = 0;
    private List<PartialPath> paths;
    private List<Integer> range;
    private List<Object> failedColumns;

    public InsertTabletPlan() {
        super(Operator.OperatorType.BATCH_INSERT);
    }

    public InsertTabletPlan(PartialPath prefixPath, List<String> measurements) {
        super(Operator.OperatorType.BATCH_INSERT);
        this.devicePath = prefixPath;
        this.measurements = measurements.toArray(new String[0]);
        this.canBeSplit = true;
    }

    public InsertTabletPlan(PartialPath prefixPath, String[] measurements) {
        super(Operator.OperatorType.BATCH_INSERT);
        this.devicePath = prefixPath;
        this.measurements = measurements;
        this.canBeSplit = true;
    }

    public InsertTabletPlan(PartialPath prefixPath, String[] measurements, List<Integer> dataTypes) {
        super(Operator.OperatorType.BATCH_INSERT);
        this.devicePath = prefixPath;
        this.measurements = measurements;
        this.setDataTypes(dataTypes);
        this.canBeSplit = true;
    }

    public InsertTabletPlan(PartialPath prefixPath, String[] measurements, List<Integer> dataTypes, boolean isAligned) {
        super(Operator.OperatorType.BATCH_INSERT);
        this.devicePath = prefixPath;
        this.measurements = measurements;
        this.setDataTypes(dataTypes);
        this.canBeSplit = true;
        this.isAligned = isAligned;
    }

    public List<Integer> getRange() {
        return this.range;
    }

    public void setRange(List<Integer> range) {
        this.range = range;
    }

    public List<PartialPath> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        this.paths = ret;
        return ret;
    }

    @Override
    public int serializedSize() {
        int size = 1;
        return size + this.subSerializeSize(0, this.rowCount);
    }

    public int serializedSize(int start, int end) {
        int size = 1;
        return size + this.subSerializeSize(start, end);
    }

    int subSerializeSize(int start, int end) {
        int i;
        int size = 0;
        size += ReadWriteIOUtils.sizeToWrite((String)this.devicePath.getFullPath());
        size += 4;
        for (String m : this.measurements) {
            if (m == null) continue;
            size += ReadWriteIOUtils.sizeToWrite((String)m);
        }
        size += 4;
        for (i = 0; i < this.dataTypes.length; ++i) {
            if (this.columns[i] == null) continue;
            ++size;
        }
        size += 4;
        size += 8 * (end - start);
        ++size;
        if (this.bitMaps != null) {
            for (i = 0; i < this.bitMaps.length; ++i) {
                if (this.columns[i] == null) continue;
                ++size;
                if (this.bitMaps[i] == null) continue;
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                size += partBitMap.getByteArray().length;
            }
        }
        for (i = 0; i < this.dataTypes.length; ++i) {
            if (this.columns[i] == null) continue;
            size += this.getColumnSize(this.dataTypes[i], this.columns[i], start, end);
        }
        size += 8;
        return ++size;
    }

    private int getColumnSize(TSDataType dataType, Object column, int start, int end) {
        int size = 0;
        switch (dataType) {
            case INT32: {
                size += 4 * (end - start);
                break;
            }
            case INT64: {
                size += 8 * (end - start);
                break;
            }
            case FLOAT: {
                size += 4 * (end - start);
                break;
            }
            case DOUBLE: {
                size += 8 * (end - start);
                break;
            }
            case BOOLEAN: {
                size += 1 * (end - start);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    size += ReadWriteIOUtils.sizeToWrite((Binary)binaryValues[j]);
                }
                break;
            }
        }
        return size;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        stream.writeByte((byte)type);
        this.subSerialize(stream, 0, this.rowCount);
    }

    void subSerialize(DataOutputStream stream, int start, int end) throws IOException {
        this.putString(stream, this.devicePath.getFullPath());
        this.writeMeasurements(stream);
        this.writeDataTypes(stream);
        this.writeTimes(stream, start, end);
        this.writeBitMaps(stream, start, end);
        this.writeValues(stream, start, end);
        stream.write((byte)(this.isAligned ? 1 : 0));
    }

    private void writeMeasurements(DataOutputStream stream) throws IOException {
        stream.writeInt(this.measurements.length - this.getFailedMeasurementNumber());
        for (String m : this.measurements) {
            if (m == null) continue;
            this.putString(stream, m);
        }
    }

    private void writeDataTypes(DataOutputStream stream) throws IOException {
        stream.writeInt(this.dataTypes.length - this.getFailedMeasurementNumber());
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.columns[i] == null) continue;
            this.dataTypes[i].serializeTo(stream);
        }
    }

    private void writeTimes(DataOutputStream stream, int start, int end) throws IOException {
        stream.writeInt(end - start);
        for (int i = start; i < end; ++i) {
            stream.writeLong(this.times[i]);
        }
    }

    private void writeBitMaps(DataOutputStream stream, int start, int end) throws IOException {
        stream.writeBoolean(this.bitMaps != null);
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.columns[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    stream.writeBoolean(false);
                    continue;
                }
                stream.writeBoolean(true);
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                stream.write(partBitMap.getByteArray());
            }
        }
    }

    private void writeValues(DataOutputStream stream, int start, int end) throws IOException {
        this.serializeValues(stream, start, end);
        stream.writeLong(this.index);
    }

    private void serializeValues(DataOutputStream outputStream, int start, int end) throws IOException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], outputStream, start, end);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream outputStream, int start, int end) throws IOException {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = start; j < end; ++j) {
                    outputStream.writeInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = start; j < end; ++j) {
                    outputStream.writeLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = start; j < end; ++j) {
                    outputStream.writeFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = start; j < end; ++j) {
                    outputStream.writeDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = start; j < end; ++j) {
                    outputStream.writeByte(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    outputStream.writeInt(binaryValues[j].getLength());
                    outputStream.write(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        buffer.put((byte)type);
        this.subSerialize(buffer, 0, this.rowCount);
    }

    void subSerialize(ByteBuffer buffer, int start, int end) {
        this.putString(buffer, this.devicePath.getFullPath());
        this.writeMeasurements(buffer);
        this.writeDataTypes(buffer);
        this.writeTimes(buffer, 0, this.rowCount);
        this.writeBitMaps(buffer, 0, this.rowCount);
        this.writeValues(buffer, 0, this.rowCount);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    private void writeMeasurements(ByteBuffer buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        for (String m : this.measurements) {
            if (m == null) continue;
            this.putString(buffer, m);
        }
    }

    private void writeDataTypes(ByteBuffer buffer) {
        buffer.putInt(this.dataTypes.length - this.getFailedMeasurementNumber());
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.columns[i] == null) continue;
            this.dataTypes[i].serializeTo(buffer);
        }
    }

    private void writeTimes(ByteBuffer buffer, int start, int end) {
        buffer.putInt(this.rowCount);
        for (int i = start; i < end; ++i) {
            buffer.putLong(this.times[i]);
        }
    }

    private void writeBitMaps(ByteBuffer buffer, int start, int end) {
        buffer.put(BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0));
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.columns[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    buffer.put(BytesUtils.boolToByte((boolean)false));
                    continue;
                }
                buffer.put(BytesUtils.boolToByte((boolean)true));
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                buffer.put(partBitMap.getByteArray());
            }
        }
    }

    private void writeValues(ByteBuffer buffer, int start, int end) {
        this.serializeValues(buffer, start, end);
        buffer.putLong(this.index);
    }

    private void serializeValues(ByteBuffer buffer, int start, int end) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer, start, end);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, ByteBuffer buffer, int start, int end) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = start; j < end; ++j) {
                    buffer.put(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(binaryValues[j].getLength());
                    buffer.put(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        this.serializeToWAL(buffer, 0, this.rowCount);
    }

    public void serializeToWAL(IWALByteBufferView buffer, int start, int end) {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        buffer.put((byte)type);
        this.subSerialize(buffer, start, end);
    }

    void subSerialize(IWALByteBufferView buffer, int start, int end) {
        WALWriteUtils.write(this.devicePath.getFullPath(), buffer);
        this.writeMeasurements(buffer);
        this.writeDataTypes(buffer);
        this.writeTimes(buffer, start, end);
        this.writeBitMaps(buffer, start, end);
        this.writeValues(buffer, start, end);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    private void writeMeasurements(IWALByteBufferView buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        for (String m : this.measurements) {
            if (m == null) continue;
            WALWriteUtils.write(m, buffer);
        }
    }

    private void writeDataTypes(IWALByteBufferView buffer) {
        buffer.putInt(this.dataTypes.length - this.getFailedMeasurementNumber());
        int dataTypesLength = this.dataTypes.length;
        for (int i = 0; i < dataTypesLength; ++i) {
            TSDataType dataType = this.dataTypes[i];
            if (this.columns[i] == null) continue;
            WALWriteUtils.write(dataType, buffer);
        }
    }

    private void writeTimes(IWALByteBufferView buffer, int start, int end) {
        buffer.putInt(end - start);
        for (int i = start; i < end; ++i) {
            buffer.putLong(this.times[i]);
        }
    }

    private void writeBitMaps(IWALByteBufferView buffer, int start, int end) {
        buffer.put(BytesUtils.boolToByte((this.bitMaps != null ? 1 : 0) != 0));
        if (this.bitMaps != null) {
            for (int i = 0; i < this.bitMaps.length; ++i) {
                if (this.columns[i] == null) continue;
                if (this.bitMaps[i] == null) {
                    buffer.put(BytesUtils.boolToByte((boolean)false));
                    continue;
                }
                buffer.put(BytesUtils.boolToByte((boolean)true));
                int len = end - start;
                BitMap partBitMap = new BitMap(len);
                BitMap.copyOfRange((BitMap)this.bitMaps[i], (int)start, (BitMap)partBitMap, (int)0, (int)len);
                buffer.put(partBitMap.getByteArray());
            }
        }
    }

    private void writeValues(IWALByteBufferView buffer, int start, int end) {
        this.serializeValues(buffer, start, end);
        buffer.putLong(this.index);
    }

    private void serializeValues(IWALByteBufferView buffer, int start, int end) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            this.serializeColumn(this.dataTypes[i], this.columns[i], buffer, start, end);
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, IWALByteBufferView buffer, int start, int end) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(intValues[j]);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putLong(longValues[j]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putFloat(floatValues[j]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putDouble(doubleValues[j]);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])column;
                for (int j = start; j < end; ++j) {
                    buffer.put(BytesUtils.boolToByte((boolean)boolValues[j]));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])column;
                for (int j = start; j < end; ++j) {
                    buffer.putInt(binaryValues[j].getLength());
                    buffer.put(binaryValues[j].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, dataType));
            }
        }
    }

    @Override
    public void deserialize(DataInputStream stream) throws IOException, IllegalPathException {
        int rows;
        this.devicePath = new PartialPath(ReadWriteIOUtils.readString((InputStream)stream));
        int measurementSize = stream.readInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = ReadWriteIOUtils.readString((InputStream)stream);
        }
        int dataTypeSize = stream.readInt();
        this.dataTypes = new TSDataType[dataTypeSize];
        for (int i = 0; i < dataTypeSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((byte)stream.readByte());
        }
        this.rowCount = rows = stream.readInt();
        this.times = new long[rows];
        this.times = QueryDataSetUtils.readTimesFromStream(stream, rows);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)stream.readByte());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromStream(stream, dataTypeSize, rows);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromStream(stream, this.dataTypes, dataTypeSize, rows);
        this.index = stream.readLong();
        this.isAligned = stream.readByte() == 1;
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int rows;
        this.devicePath = new PartialPath(this.readString(buffer));
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        int dataTypeSize = buffer.getInt();
        this.dataTypes = new TSDataType[dataTypeSize];
        for (int i = 0; i < dataTypeSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((byte)buffer.get());
        }
        this.rowCount = rows = buffer.getInt();
        this.times = new long[rows];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, rows);
        boolean hasBitMaps = BytesUtils.byteToBool((byte)buffer.get());
        if (hasBitMaps) {
            this.bitMaps = QueryDataSetUtils.readBitMapsFromBuffer(buffer, dataTypeSize, rows);
        }
        this.columns = QueryDataSetUtils.readTabletValuesFromBuffer(buffer, this.dataTypes, dataTypeSize, rows);
        this.index = buffer.getLong();
        this.isAligned = buffer.get() == 1;
    }

    public void setDataTypes(List<Integer> dataTypes) {
        this.dataTypes = new TSDataType[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            this.dataTypes[i] = TSDataType.values()[dataTypes.get(i)];
        }
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public void setColumn(int index, Object column) {
        this.columns[index] = column;
    }

    public BitMap[] getBitMaps() {
        return this.bitMaps;
    }

    public void setBitMaps(BitMap[] bitMaps) {
        this.bitMaps = bitMaps;
    }

    @Override
    public long getMinTime() {
        return this.times.length != 0 ? this.times[0] : Long.MIN_VALUE;
    }

    public long getMaxTime() {
        return this.times.length != 0 ? this.times[this.times.length - 1] : Long.MAX_VALUE;
    }

    @Override
    public Object getFirstValueOfIndex(int index) {
        Object value;
        switch (this.dataTypes[index]) {
            case INT32: {
                int[] intValues = (int[])this.columns[index];
                value = intValues[0];
                break;
            }
            case INT64: {
                long[] longValues = (long[])this.columns[index];
                value = longValues[0];
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[index];
                value = Float.valueOf(floatValues[0]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[index];
                value = doubleValues[0];
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[index];
                value = boolValues[0];
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])this.columns[index];
                value = binaryValues[0];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[index]));
            }
        }
        return value;
    }

    public TimeValuePair composeLastTimeValuePair(int measurementIndex) {
        TsPrimitiveType.TsInt value;
        int lastIdx;
        if (measurementIndex >= this.columns.length) {
            return null;
        }
        if (this.bitMaps != null && this.bitMaps[measurementIndex] != null) {
            BitMap bitMap = this.bitMaps[measurementIndex];
            for (lastIdx = this.rowCount - 1; lastIdx >= 0 && bitMap.isMarked(lastIdx); --lastIdx) {
            }
        }
        if (lastIdx < 0) {
            return null;
        }
        switch (this.dataTypes[measurementIndex]) {
            case INT32: {
                int[] intValues = (int[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsInt(intValues[lastIdx]);
                break;
            }
            case INT64: {
                long[] longValues = (long[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsLong(longValues[lastIdx]);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsFloat(floatValues[lastIdx]);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsDouble(doubleValues[lastIdx]);
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBoolean(boolValues[lastIdx]);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])this.columns[measurementIndex];
                value = new TsPrimitiveType.TsBinary(binaryValues[lastIdx]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(DATATYPE_UNSUPPORTED, this.dataTypes[measurementIndex]));
            }
        }
        return new TimeValuePair(this.times[lastIdx], (TsPrimitiveType)value);
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int size) {
        this.rowCount = size;
    }

    public String toString() {
        return "InsertTabletPlan {prefixPath:" + this.devicePath + ", timesRange[" + this.times[0] + "," + this.times[this.times.length - 1] + "], isAligned:" + this.isAligned + '}';
    }

    @Override
    public void markFailedMeasurementInsertion(int index, Exception e) {
        if (this.measurements[index] == null) {
            return;
        }
        super.markFailedMeasurementInsertion(index, e);
        if (this.failedColumns == null) {
            this.failedColumns = new ArrayList<Object>();
        }
        this.failedColumns.add(this.columns[index]);
        this.columns[index] = null;
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        this.columns = this.failedColumns.toArray(new Object[0]);
        this.failedColumns = null;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertTabletPlan that = (InsertTabletPlan)o;
        return this.rowCount == that.rowCount && Objects.equals(this.devicePath, that.devicePath) && Arrays.equals(this.times, that.times) && Objects.equals(this.paths, that.paths) && Objects.equals(this.range, that.range) && Objects.equals(this.isAligned, that.isAligned);
    }

    public int hashCode() {
        int result = Objects.hash(this.rowCount, this.paths, this.range);
        result = 31 * result + Arrays.hashCode(this.times);
        return result;
    }

    @Override
    public void recoverFromFailure() {
        if (this.failedMeasurements == null) {
            return;
        }
        for (int i = 0; i < this.failedMeasurements.size(); ++i) {
            int index = (Integer)this.failedIndices.get(i);
            this.columns[index] = this.failedColumns.get(i);
        }
        super.recoverFromFailure();
        this.failedColumns = null;
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        super.checkIntegrity();
        if (this.columns == null || this.columns.length == 0) {
            throw new QueryProcessException("Values are null");
        }
        if (this.dataTypes.length != this.columns.length) {
            throw new QueryProcessException(String.format("Measurements length [%d] does not match columns length [%d]", this.measurements.length, this.columns.length));
        }
        for (Object value : this.columns) {
            if (value != null) continue;
            throw new QueryProcessException("Columns contain null: " + Arrays.toString(this.columns));
        }
    }
}

