/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.DropIndexPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class DropIndexOperator
extends Operator {
    private final List<PartialPath> paths;
    private IndexType indexType;

    public DropIndexOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.DROP_INDEX;
        this.paths = new ArrayList<PartialPath>();
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return new DropIndexPlan(this.paths, this.indexType);
    }
}

