/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.crud.GroupByFillClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByQueryOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.tsfile.read.expression.IExpression;

public class GroupByFillQueryOperator
extends GroupByQueryOperator {
    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan plan = this.isAlignByDevice() ? this.generateAlignByDevicePlan(generator) : super.generateRawDataQueryPlan(generator, this.initGroupByTimeFillPlan(new GroupByTimeFillPlan()));
        AggregationPlan aggregationPlan = this.isAlignByDevice() ? plan.getAggregationPlan() : (AggregationPlan)((Object)plan);
        aggregationPlan.verifyAllAggregationDataTypesMatched();
        return plan;
    }

    @Override
    protected AlignByDevicePlan generateAlignByDevicePlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan alignByDevicePlan = super.generateAlignByDevicePlan(generator);
        alignByDevicePlan.setGroupByFillPlan(this.initGroupByTimeFillPlan(new GroupByTimeFillPlan()));
        return alignByDevicePlan;
    }

    protected GroupByTimeFillPlan initGroupByTimeFillPlan(QueryPlan queryPlan) throws QueryProcessException {
        GroupByTimeFillPlan groupByTimeFillPlan = (GroupByTimeFillPlan)super.initGroupByTimePlan(queryPlan);
        GroupByFillClauseComponent groupByFillClauseComponent = (GroupByFillClauseComponent)this.specialClauseComponent;
        groupByTimeFillPlan.setSingleFill(groupByFillClauseComponent.getSingleFill());
        groupByTimeFillPlan.setFillType(groupByFillClauseComponent.getFillTypes());
        return groupByTimeFillPlan;
    }

    @Override
    protected IExpression optimizeExpression(IExpression expression, RawDataQueryPlan queryPlan) throws QueryProcessException {
        GroupByTimeFillPlan groupByFillPlan = (GroupByTimeFillPlan)queryPlan;
        groupByFillPlan.initFillRange();
        return super.optimizeExpression(expression, queryPlan);
    }
}

