/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.sys.sync;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;

public class CreatePipeSinkStatement
extends Statement
implements IConfigStatement {
    private String pipeSinkName;
    private String pipeSinkType;
    private Map<String, String> attributes;

    public CreatePipeSinkStatement(StatementType createPipeSinkStatement) {
        this.statementType = createPipeSinkStatement;
    }

    public String getPipeSinkName() {
        return this.pipeSinkName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getPipeSinkType() {
        return this.pipeSinkType;
    }

    public void setPipeSinkName(String pipeSinkName) {
        this.pipeSinkName = pipeSinkName;
    }

    public void setPipeSinkType(String pipeSinkType) {
        this.pipeSinkType = pipeSinkType;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreatePipeSink(this, context);
    }

    public static CreatePipeSinkStatement parseString(String parsedString) throws IOException {
        String[] split = parsedString.split(",");
        if (split.length < 3) {
            throw new IOException("Parsing CreatePipeSinkStatement error. Attributes is less than expected.");
        }
        CreatePipeSinkStatement createPipeSinkStatement = new CreatePipeSinkStatement(StatementType.CREATE_PIPESINK);
        createPipeSinkStatement.setPipeSinkName(split[0]);
        createPipeSinkStatement.setPipeSinkType(split[1]);
        int size = Integer.parseInt(split[2]) << 1;
        if (split.length != size + 3) {
            throw new IOException("Parsing CreatePipeSinkPlan error. Attributes number is wrong.");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < size; i += 2) {
            attributes.put(split[i + 3], split[i + 4]);
        }
        createPipeSinkStatement.setAttributes(attributes);
        return createPipeSinkStatement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.pipeSinkName).append(",");
        builder.append(this.pipeSinkType).append(",");
        builder.append(this.attributes.size()).append(",");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            builder.append(entry.getKey()).append(",");
            builder.append(entry.getValue()).append(",");
        }
        return builder.toString();
    }
}

