/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import io.airlift.concurrent.SetThreadName;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.SchemaValidator;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceDispatcher;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstance;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendFragmentInstanceResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendPlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceDispatcherImpl
implements IFragInstanceDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(FragmentInstanceDispatcherImpl.class);
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final QueryType type;
    private final MPPQueryContext queryContext;
    private final String localhostIpAddr;
    private final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public FragmentInstanceDispatcherImpl(QueryType type, MPPQueryContext queryContext, ExecutorService executor, ExecutorService writeOperationExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.type = type;
        this.queryContext = queryContext;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.internalServiceClientManager = internalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public Future<FragInstanceDispatchResult> dispatch(List<FragmentInstance> instances) {
        if (this.type == QueryType.READ) {
            return this.dispatchRead(instances);
        }
        return this.dispatchWriteSync(instances);
    }

    private Future<FragInstanceDispatchResult> dispatchRead(List<FragmentInstance> instances) {
        return this.executor.submit(() -> {
            for (FragmentInstance instance : instances) {
                try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId(), new Object[0]);){
                    this.dispatchOneInstance(instance);
                }
                catch (FragmentInstanceDispatchException e) {
                    return new FragInstanceDispatchResult(e.getFailureStatus());
                }
                catch (Throwable t) {
                    logger.error("cannot dispatch FI for read operation", t);
                    return new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage())));
                }
            }
            return new FragInstanceDispatchResult(true);
        });
    }

    private Future<FragInstanceDispatchResult> dispatchWriteSync(List<FragmentInstance> instances) {
        for (FragmentInstance instance : instances) {
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId(), new Object[0]);){
                this.dispatchOneInstance(instance);
            }
            catch (FragmentInstanceDispatchException e) {
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(e.getFailureStatus()));
            }
            catch (Throwable t) {
                logger.error("cannot dispatch FI for write operation", t);
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("Unexpected errors: " + t.getMessage()))));
            }
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }

    private void dispatchOneInstance(FragmentInstance instance) throws FragmentInstanceDispatchException {
        TEndPoint endPoint = instance.getHostDataNode().getInternalEndPoint();
        if (this.isDispatchedToLocal(endPoint)) {
            this.dispatchLocally(instance);
        } else {
            this.dispatchRemote(instance, endPoint);
        }
    }

    private boolean isDispatchedToLocal(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    private void dispatchRemote(FragmentInstance instance, TEndPoint endPoint) throws FragmentInstanceDispatchException {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            switch (instance.getType()) {
                case READ: {
                    TSendFragmentInstanceReq sendFragmentInstanceReq = new TSendFragmentInstanceReq(new TFragmentInstance(instance.serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                    TSendFragmentInstanceResp sendFragmentInstanceResp = client.sendFragmentInstance(sendFragmentInstanceReq);
                    if (!sendFragmentInstanceResp.accepted) {
                        logger.error(sendFragmentInstanceResp.message);
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)sendFragmentInstanceResp.message));
                    }
                    break;
                }
                case WRITE: {
                    TSendPlanNodeReq sendPlanNodeReq = new TSendPlanNodeReq(new TPlanNode(instance.getFragment().getPlanNodeTree().serializeToByteBuffer()), instance.getRegionReplicaSet().getRegionId());
                    TSendPlanNodeResp sendPlanNodeResp = client.sendPlanNode(sendPlanNodeReq);
                    if (!sendPlanNodeResp.accepted) {
                        logger.error(sendPlanNodeResp.getStatus().message);
                        throw new FragmentInstanceDispatchException(sendPlanNodeResp.getStatus());
                    }
                    break;
                }
                default: {
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown query type [%s]", new Object[]{instance.getType()})));
                }
            }
        }
        catch (IOException | TException e) {
            logger.error("can't connect to node {}", (Object)endPoint, (Object)e);
            TSStatus status = new TSStatus();
            status.setCode(TSStatusCode.SYNC_CONNECTION_EXCEPTION.getStatusCode());
            status.setMessage("can't connect to node {}" + endPoint);
            this.queryContext.addFailedEndPoint(endPoint);
            throw new FragmentInstanceDispatchException(status);
        }
    }

    private void dispatchLocally(FragmentInstance instance) throws FragmentInstanceDispatchException {
        ConsensusGroupId groupId;
        try {
            groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)instance.getRegionReplicaSet().getRegionId());
        }
        catch (Throwable t) {
            logger.error("Deserialize ConsensusGroupId failed. ", t);
            throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Deserialize ConsensusGroupId failed: " + t.getMessage())));
        }
        switch (instance.getType()) {
            case READ: {
                ConsensusReadResponse readResponse;
                try {
                    readResponse = groupId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().read(groupId, (IConsensusRequest)instance) : SchemaRegionConsensusImpl.getInstance().read(groupId, (IConsensusRequest)instance);
                    if (readResponse == null) {
                        logger.error("ReadResponse is null");
                        throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"ReadResponse is null"));
                    }
                }
                catch (Throwable t) {
                    logger.error("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)t);
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Execute FragmentInstance failed. " + t.getMessage())));
                }
                if (!readResponse.isSuccess()) {
                    logger.error("dispatch FragmentInstance {} locally failed. ", (Object)instance, (Object)readResponse.getException());
                    throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Execute FragmentInstance failed: " + (readResponse.getException() == null ? "" : readResponse.getException().getMessage()))));
                }
                FragmentInstanceInfo info = (FragmentInstanceInfo)readResponse.getDataset();
                if (!info.getState().isFailed()) break;
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)info.getMessage()));
            }
            case WRITE: {
                ConsensusWriteResponse writeResponse;
                PlanNode planNode = instance.getFragment().getPlanNodeTree();
                boolean hasFailedMeasurement = false;
                String partialInsertMessage = null;
                if (planNode instanceof InsertNode) {
                    InsertNode insertNode = (InsertNode)planNode;
                    try {
                        SchemaValidator.validate(insertNode);
                    }
                    catch (SemanticException e) {
                        throw new FragmentInstanceDispatchException(e);
                    }
                    hasFailedMeasurement = insertNode.hasFailedMeasurements();
                    if (hasFailedMeasurement) {
                        partialInsertMessage = String.format("Fail to insert measurements %s caused by %s", insertNode.getFailedMeasurements(), insertNode.getFailedMessages());
                        logger.warn(partialInsertMessage);
                    }
                }
                if (!(writeResponse = groupId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode) : SchemaRegionConsensusImpl.getInstance().write(groupId, (IConsensusRequest)planNode)).isSuccessful()) {
                    logger.error(writeResponse.getErrorMessage());
                    TSStatus failureStatus = writeResponse.getStatus() != null ? writeResponse.getStatus() : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)writeResponse.getErrorMessage());
                    throw new FragmentInstanceDispatchException(failureStatus);
                }
                if (!hasFailedMeasurement) break;
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), partialInsertMessage));
            }
            default: {
                throw new FragmentInstanceDispatchException(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("unknown query type [%s]", new Object[]{instance.getType()})));
            }
        }
    }

    @Override
    public void abort() {
    }
}

