/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import io.airlift.concurrent.SetThreadName;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.AbstractFragInsStateTracker;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedRateFragInsStateTracker
extends AbstractFragInsStateTracker {
    private static final Logger logger = LoggerFactory.getLogger(FixedRateFragInsStateTracker.class);
    private static final long SAME_STATE_PRINT_RATE_IN_MS = 600000L;
    private static final long STATE_FETCH_INTERVAL_IN_MS = 500L;
    private ScheduledFuture<?> trackTask;
    private final Map<FragmentInstanceId, InstanceStateMetrics> instanceStateMap = new HashMap<FragmentInstanceId, InstanceStateMetrics>();
    private volatile boolean aborted = false;

    public FixedRateFragInsStateTracker(QueryStateMachine stateMachine, ScheduledExecutorService scheduledExecutor, List<FragmentInstance> instances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        super(stateMachine, scheduledExecutor, instances, internalServiceClientManager);
    }

    @Override
    public synchronized void start() {
        if (this.aborted) {
            return;
        }
        this.trackTask = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.scheduledExecutor, this::fetchStateAndUpdate, (long)0L, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void abort() {
        this.aborted = true;
        if (this.trackTask != null) {
            boolean cancelResult = this.trackTask.cancel(true);
            if (!cancelResult) {
                logger.debug("cancel state tracking task failed. {}", (Object)this.trackTask.isCancelled());
            }
        } else {
            logger.debug("trackTask not started");
        }
    }

    private void fetchStateAndUpdate() {
        for (FragmentInstance instance : this.instances) {
            try (SetThreadName threadName = new SetThreadName(instance.getId().getFullId(), new Object[0]);){
                FragmentInstanceState state = this.fetchState(instance);
                InstanceStateMetrics metrics = this.instanceStateMap.computeIfAbsent(instance.getId(), k -> new InstanceStateMetrics(instance.isRoot()));
                if (this.needPrintState(metrics.lastState, state, metrics.durationToLastPrintInMS)) {
                    logger.info("State is {}", (Object)state);
                    metrics.reset(state);
                } else {
                    metrics.addDuration(500L);
                }
                if (state == null) continue;
                this.updateQueryState(instance.getId(), state);
            }
            catch (IOException | TException e) {
                logger.error("error happened while fetching query state", e);
            }
        }
    }

    private void updateQueryState(FragmentInstanceId instanceId, FragmentInstanceState state) {
        boolean queryFinished;
        if (state.isFailed()) {
            this.stateMachine.transitionToFailed(new RuntimeException(String.format("FragmentInstance[%s] is failed.", instanceId)));
        }
        if (queryFinished = this.instanceStateMap.values().stream().filter(instanceStateMetrics -> ((InstanceStateMetrics)instanceStateMetrics).isRootInstance).allMatch(instanceStateMetrics -> ((InstanceStateMetrics)instanceStateMetrics).lastState == FragmentInstanceState.FINISHED)) {
            this.stateMachine.transitionToFinished();
        }
    }

    private boolean needPrintState(FragmentInstanceState previous, FragmentInstanceState current, long durationToLastPrintInMS) {
        if (current != previous) {
            return true;
        }
        return durationToLastPrintInMS >= 600000L;
    }

    private static class InstanceStateMetrics {
        private final boolean isRootInstance;
        private FragmentInstanceState lastState;
        private long durationToLastPrintInMS;

        private InstanceStateMetrics(boolean isRootInstance) {
            this.isRootInstance = isRootInstance;
            this.lastState = null;
            this.durationToLastPrintInMS = 0L;
        }

        private void reset(FragmentInstanceState newState) {
            this.lastState = newState;
            this.durationToLastPrintInMS = 0L;
        }

        private void addDuration(long duration) {
            this.durationToLastPrintInMS += duration;
        }
    }
}

