/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.service.UDFRegistrationInformation;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFunctionsTask
implements IConfigTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowFunctionsTask.class);

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        SettableFuture future = SettableFuture.create();
        try {
            List outputDataTypes = ColumnHeaderConstant.showFunctionsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
            TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
            QueryDataSet showDataSet = this.generateShowFunctionsListDataSet();
            while (showDataSet.hasNextWithoutConstraint()) {
                RowRecord record = showDataSet.nextWithoutConstraint();
                builder.getTimeColumnBuilder().writeLong(0L);
                for (int i = 0; i < 3; ++i) {
                    builder.getColumnBuilder(i).writeBinary(((Field)record.getFields().get(i)).getBinaryV());
                }
                builder.declarePosition();
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), DatasetHeaderFactory.getShowFunctionsHeader()));
        }
        catch (Exception e) {
            LOGGER.error("Failed to get functions.", (Throwable)e);
            future.setException((Throwable)e);
        }
        return future;
    }

    private QueryDataSet generateShowFunctionsListDataSet() {
        ListDataSet listDataSet = new ListDataSet(Arrays.asList(new PartialPath("function name", false), new PartialPath("function type", false), new PartialPath("class name (UDF)", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        this.appendUDFs(listDataSet);
        this.appendNativeFunctions(listDataSet);
        listDataSet.sort((r1, r2) -> String.CASE_INSENSITIVE_ORDER.compare(((Field)r1.getFields().get(0)).getStringValue(), ((Field)r2.getFields().get(0)).getStringValue()));
        return listDataSet;
    }

    private void appendUDFs(ListDataSet listDataSet) {
        for (UDFRegistrationInformation info : UDFRegistrationService.getInstance().getRegistrationInformation()) {
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)info.getFunctionName()), TSDataType.TEXT);
            String functionType = "";
            try {
                if (info.isBuiltin()) {
                    if (info.isUDTF()) {
                        functionType = "built-in UDTF";
                    } else if (info.isUDAF()) {
                        functionType = "built-in UDAF";
                    }
                } else if (info.isUDTF()) {
                    functionType = "external UDTF";
                } else if (info.isUDAF()) {
                    functionType = "external UDAF";
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e.toString());
            }
            rowRecord.addField((Object)Binary.valueOf((String)functionType), TSDataType.TEXT);
            rowRecord.addField((Object)Binary.valueOf((String)info.getClassName()), TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
    }

    private void appendNativeFunctions(ListDataSet listDataSet) {
        Binary functionType = Binary.valueOf((String)"native");
        Binary className = Binary.valueOf((String)"");
        for (String functionName : BuiltinAggregationFunction.getNativeFunctionNames()) {
            RowRecord rowRecord = new RowRecord(0L);
            rowRecord.addField((Object)Binary.valueOf((String)functionName.toUpperCase()), TSDataType.TEXT);
            rowRecord.addField((Object)functionType, TSDataType.TEXT);
            rowRecord.addField((Object)className, TSDataType.TEXT);
            listDataSet.putRecord(rowRecord);
        }
    }
}

