/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import io.airlift.concurrent.SetThreadName;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDriverThread
extends Thread
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDriverThread.class);
    private final IndexedBlockingQueue<DriverTask> queue;
    protected final ITaskScheduler scheduler;
    private volatile boolean closed;

    public AbstractDriverThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler) {
        super(tg, workerId);
        this.queue = queue;
        this.scheduler = scheduler;
        this.closed = false;
    }

    @Override
    public void run() {
        while (!this.closed && !Thread.currentThread().isInterrupted()) {
            DriverTask next;
            try {
                next = this.queue.poll();
            }
            catch (InterruptedException e) {
                logger.error("Executor " + this.getName() + "failed to poll driver task from queue");
                Thread.currentThread().interrupt();
                break;
            }
            try (SetThreadName fragmentInstanceName = new SetThreadName(next.getFragmentInstance().getInfo().getFullId(), new Object[0]);){
                this.execute(next);
            }
            catch (Throwable t) {
                logger.error("execute failed", t);
                if (next == null) continue;
                next.setAbortCause("internal error scheduled");
                this.scheduler.toAborted(next);
            }
        }
    }

    protected abstract void execute(DriverTask var1) throws InterruptedException, ExecutionException;

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

