/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class LastCacheScanOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private TsBlock tsBlock;

    public LastCacheScanOperator(OperatorContext operatorContext, PlanNodeId sourceId, TsBlock tsBlock) {
        this.operatorContext = operatorContext;
        this.sourceId = sourceId;
        this.tsBlock = tsBlock;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        TsBlock res = this.tsBlock;
        this.tsBlock = null;
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.tsBlock != null && !this.tsBlock.isEmpty();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.tsBlock.getRetainedSizeInBytes();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.tsBlock.getRetainedSizeInBytes();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }
}

