/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.SingleInputAggregationOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Pair;

public class RawDataAggregationOperator
extends SingleInputAggregationOperator {
    public RawDataAggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, Operator child, boolean ascending, long maxReturnSize) {
        super(operatorContext, aggregators, child, ascending, timeRangeIterator, maxReturnSize);
    }

    @Override
    protected boolean calculateNextAggregationResult() {
        while (!this.calcFromRawData()) {
            this.inputTsBlock = null;
            if (this.child.hasNext() && this.canCallNext) {
                this.inputTsBlock = this.child.next();
                this.canCallNext = false;
                continue;
            }
            if (!this.child.hasNext()) break;
            return false;
        }
        this.updateResultTsBlock();
        return true;
    }

    private boolean calcFromRawData() {
        Pair<Boolean, TsBlock> calcResult = AggregationUtil.calculateAggregationFromRawData(this.inputTsBlock, this.aggregators, this.curTimeRange, this.ascending);
        this.inputTsBlock = (TsBlock)calcResult.getRight();
        return (Boolean)calcResult.getLeft();
    }
}

