/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.common.filter.FilterDeserializeUtil;
import org.apache.iotdb.db.mpp.common.filter.FilterTypes;
import org.apache.iotdb.db.mpp.plan.constant.FilterConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class QueryFilter
implements Comparable<QueryFilter> {
    protected FilterConstant.FilterType filterType;
    private List<QueryFilter> childOperators = new ArrayList<QueryFilter>();
    protected boolean isLeaf = false;
    boolean isSingle = false;
    PartialPath singlePath = null;
    Set<PartialPath> pathSet;

    public QueryFilter() {
    }

    public QueryFilter(FilterConstant.FilterType filterType) {
        this.filterType = filterType;
    }

    public QueryFilter(FilterConstant.FilterType filterType, boolean isSingle) {
        this.filterType = filterType;
        this.isSingle = isSingle;
    }

    public FilterConstant.FilterType getFilterType() {
        return this.filterType;
    }

    public void setFilterType(FilterConstant.FilterType filterType) {
        this.filterType = filterType;
    }

    public String getFilterName() {
        return FilterConstant.filterNames.get((Object)this.filterType);
    }

    public String getFilterSymbol() {
        return FilterConstant.filterSymbol.get((Object)this.filterType);
    }

    public List<QueryFilter> getChildren() {
        return this.childOperators;
    }

    public void setChildren(List<QueryFilter> children) {
        this.childOperators = children;
    }

    public void setIsSingle(boolean b) {
        this.isSingle = b;
    }

    public PartialPath getSinglePath() {
        return this.singlePath;
    }

    public void setSinglePath(PartialPath singlePath) {
        this.singlePath = singlePath;
    }

    public void addChildOperator(QueryFilter op) {
        this.childOperators.add(op);
    }

    public void setPathSet(Set<PartialPath> pathSet) {
        this.pathSet = pathSet;
    }

    public Set<PartialPath> getPathSet() {
        return this.pathSet;
    }

    public IExpression transformToExpression(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws StatementAnalyzeException {
        if (this.isSingle) {
            Pair<IUnaryExpression, String> ret;
            try {
                ret = this.transformToSingleQueryFilter(pathTSDataTypeHashMap);
            }
            catch (MetadataException e) {
                throw new StatementAnalyzeException("Meet error when transformToSingleQueryFilter");
            }
            return (IExpression)ret.left;
        }
        if (this.childOperators.isEmpty()) {
            throw new StatementAnalyzeException(String.valueOf((Object)this.filterType), "this filter is not leaf, but it's empty");
        }
        IExpression retFilter = this.childOperators.get(0).transformToExpression(pathTSDataTypeHashMap);
        block6: for (int i = 1; i < this.childOperators.size(); ++i) {
            IExpression currentFilter = this.childOperators.get(i).transformToExpression(pathTSDataTypeHashMap);
            switch (this.filterType) {
                case KW_AND: {
                    retFilter = BinaryExpression.and((IExpression)retFilter, (IExpression)currentFilter);
                    continue block6;
                }
                case KW_OR: {
                    retFilter = BinaryExpression.or((IExpression)retFilter, (IExpression)currentFilter);
                    continue block6;
                }
                default: {
                    throw new StatementAnalyzeException(String.valueOf((Object)this.filterType), "Maybe it means " + this.getFilterName());
                }
            }
        }
        return retFilter;
    }

    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws StatementAnalyzeException, MetadataException {
        if (this.childOperators.isEmpty()) {
            throw new StatementAnalyzeException(String.valueOf((Object)this.filterType), "TransformToSingleFilter: this filter is not a leaf, but it's empty.");
        }
        Pair<IUnaryExpression, String> currentPair = this.childOperators.get(0).transformToSingleQueryFilter(pathTSDataTypeHashMap);
        IUnaryExpression retFilter = (IUnaryExpression)currentPair.left;
        String path = (String)currentPair.right;
        block4: for (int i = 1; i < this.childOperators.size(); ++i) {
            currentPair = this.childOperators.get(i).transformToSingleQueryFilter(pathTSDataTypeHashMap);
            if (!path.equals(currentPair.right)) {
                throw new StatementAnalyzeException("TransformToSingleFilter: paths among children are not inconsistent: one is: " + path + ", another is: " + (String)currentPair.right);
            }
            switch (this.filterType) {
                case KW_AND: {
                    retFilter.setFilter((Filter)FilterFactory.and((Filter)retFilter.getFilter(), (Filter)((IUnaryExpression)currentPair.left).getFilter()));
                    continue block4;
                }
                case KW_OR: {
                    retFilter.setFilter((Filter)FilterFactory.or((Filter)retFilter.getFilter(), (Filter)((IUnaryExpression)currentPair.left).getFilter()));
                    continue block4;
                }
                default: {
                    throw new StatementAnalyzeException(String.valueOf((Object)this.filterType), "Maybe it means " + this.getFilterName());
                }
            }
        }
        return new Pair((Object)retFilter, (Object)path);
    }

    @Override
    public int compareTo(QueryFilter fil) {
        if (this.singlePath == null && fil.singlePath == null) {
            return 0;
        }
        if (this.singlePath == null) {
            return 1;
        }
        if (fil.singlePath == null) {
            return -1;
        }
        return fil.singlePath.getFullPath().compareTo(this.singlePath.getFullPath());
    }

    public boolean equals(Object fil) {
        if (!(fil instanceof QueryFilter)) {
            return false;
        }
        QueryFilter operator = (QueryFilter)fil;
        return this.filterType == operator.filterType && this.getChildren().equals(operator.getChildren());
    }

    public int hashCode() {
        return this.getFilterSymbol().hashCode();
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public String showTree() {
        return this.showTree(0);
    }

    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.getFilterName()});
        if (this.isSingle) {
            sc.addTail(new String[]{"[single:", this.getSinglePath().getFullPath(), "]"});
        }
        sc.addTail(new String[]{"\n"});
        for (QueryFilter filter : this.childOperators) {
            sc.addTail(new String[]{filter.showTree(spaceNum + 1)});
        }
        return sc.toString();
    }

    public String toString() {
        StringContainer sc = new StringContainer();
        sc.addTail(new String[]{"[", FilterConstant.filterNames.get((Object)this.filterType)});
        if (this.isSingle) {
            sc.addTail(new String[]{"[single:", this.getSinglePath().getFullPath(), "]"});
        }
        sc.addTail(new String[]{" "});
        for (QueryFilter filter : this.childOperators) {
            sc.addTail(new String[]{filter.toString()});
        }
        sc.addTail(new String[]{"]"});
        return sc.toString();
    }

    public QueryFilter copy() {
        QueryFilter ret = new QueryFilter(this.filterType);
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        if (this.singlePath != null) {
            ret.singlePath = this.singlePath.clone();
        }
        for (QueryFilter filterOperator : this.childOperators) {
            ret.addChildOperator(filterOperator.copy());
        }
        return ret;
    }

    public void serialize(ByteBuffer byteBuffer) {
        FilterTypes.Query.serialize(byteBuffer);
        this.serializeWithoutType(byteBuffer);
    }

    protected void serializeWithoutType(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.filterType.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.childOperators.size(), (ByteBuffer)byteBuffer);
        for (QueryFilter queryFilter : this.childOperators) {
            queryFilter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.isLeaf, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isSingle, (ByteBuffer)byteBuffer);
        if (this.isSingle) {
            this.singlePath.serialize(byteBuffer);
        }
        if (this.pathSet == null) {
            ReadWriteIOUtils.write((int)-1, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.pathSet.size(), (ByteBuffer)byteBuffer);
            for (PartialPath partialPath : this.pathSet) {
                partialPath.serialize(byteBuffer);
            }
        }
    }

    public static QueryFilter deserialize(ByteBuffer byteBuffer) {
        int filterTypeIndex = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int childSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<QueryFilter> queryFilters = new ArrayList<QueryFilter>();
        for (int i = 0; i < childSize; ++i) {
            queryFilters.add(FilterDeserializeUtil.deserialize(byteBuffer));
        }
        boolean isLeaf = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean isSingle = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PartialPath singlePath = null;
        if (isSingle) {
            singlePath = (PartialPath)PathDeserializeUtil.deserialize(byteBuffer);
        }
        int pathSetSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashSet<PartialPath> pathSet = null;
        if (pathSetSize != -1) {
            pathSet = new HashSet<PartialPath>();
        }
        for (int i = 0; i < pathSetSize; ++i) {
            pathSet.add((PartialPath)PathDeserializeUtil.deserialize(byteBuffer));
        }
        QueryFilter queryFilter = new QueryFilter(FilterConstant.FilterType.values()[filterTypeIndex], isSingle);
        queryFilter.setChildren(queryFilters);
        queryFilter.setPathSet(pathSet);
        queryFilter.setSinglePath(singlePath);
        queryFilter.isLeaf = isLeaf;
        return queryFilter;
    }
}

