/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.ConfigMTree;
import org.apache.iotdb.db.metadata.rescon.SchemaResourceManager;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.RSchemaRegionLoader;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegionMemoryImpl;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegionSchemaFileImpl;
import org.apache.iotdb.db.metadata.visitor.SchemaExecutionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.external.api.ISeriesNumerLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaEngine {
    private static final Logger logger = LoggerFactory.getLogger(SchemaEngine.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ConfigMTree sharedPrefixTree;
    private Map<SchemaRegionId, ISchemaRegion> schemaRegionMap;
    private SchemaEngineMode schemaRegionStoredMode;
    private ScheduledExecutorService timedForceMLogThread;
    private ISeriesNumerLimiter seriesNumerLimiter = new ISeriesNumerLimiter(){

        public void init(Properties properties) {
        }

        public boolean addTimeSeries(int number) {
            return true;
        }

        public void deleteTimeSeries(int number) {
        }
    };

    public TSStatus write(SchemaRegionId schemaRegionId, PlanNode planNode) {
        return planNode.accept(new SchemaExecutionVisitor(), this.schemaRegionMap.get(schemaRegionId));
    }

    private SchemaEngine() {
    }

    public static SchemaEngine getInstance() {
        return SchemaEngineManagerHolder.INSTANCE;
    }

    public void init() {
        try {
            this.initForLocalConfigNode();
        }
        catch (MetadataException e) {
            e.printStackTrace();
            logger.error("Error occurred during SchemaEngine initialization.", (Throwable)e);
        }
    }

    public Map<PartialPath, List<SchemaRegionId>> initForLocalConfigNode() throws MetadataException {
        this.schemaRegionStoredMode = SchemaEngineMode.valueOf(config.getSchemaEngineMode());
        logger.info("used schema engine mode: {}.", (Object)this.schemaRegionStoredMode);
        SchemaResourceManager.initSchemaResource();
        this.schemaRegionMap = new ConcurrentHashMap<SchemaRegionId, ISchemaRegion>();
        this.sharedPrefixTree = new ConfigMTree();
        Map<PartialPath, List<SchemaRegionId>> schemaRegionInfo = this.initSchemaRegion();
        if (!(config.isClusterMode() && config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") || config.getSyncMlogPeriodInMs() == 0L)) {
            this.timedForceMLogThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"SchemaEngine-TimedForceMLog-Thread");
            ScheduledExecutorUtil.unsafelyScheduleAtFixedRate((ScheduledExecutorService)this.timedForceMLogThread, this::forceMlog, (long)config.getSyncMlogPeriodInMs(), (long)config.getSyncMlogPeriodInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return schemaRegionInfo;
    }

    private Map<PartialPath, List<SchemaRegionId>> initSchemaRegion() throws MetadataException {
        HashMap<PartialPath, List<SchemaRegionId>> partitionTable = new HashMap<PartialPath, List<SchemaRegionId>>();
        File schemaDir = new File(config.getSchemaDir());
        File[] sgDirList = schemaDir.listFiles();
        if (sgDirList == null) {
            return partitionTable;
        }
        ExecutorService schemaRegionRecoverPools = IoTDBThreadPoolFactory.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)"SchemaRegion-recover-task");
        ArrayList<Future<ISchemaRegion>> futures = new ArrayList<Future<ISchemaRegion>>();
        for (File file : sgDirList) {
            File[] schemaRegionDirs;
            PartialPath storageGroup;
            if (!file.isDirectory()) continue;
            try {
                storageGroup = new PartialPath(file.getName());
            }
            catch (IllegalPathException illegalPathException) {
                continue;
            }
            ArrayList<SchemaRegionId> schemaRegionIdList = new ArrayList<SchemaRegionId>();
            partitionTable.put(storageGroup, schemaRegionIdList);
            File sgDir = new File(config.getSchemaDir(), storageGroup.getFullPath());
            if (!sgDir.exists() || (schemaRegionDirs = sgDir.listFiles()) == null) continue;
            for (File schemaRegionDir : schemaRegionDirs) {
                SchemaRegionId schemaRegionId;
                try {
                    schemaRegionId = new SchemaRegionId(Integer.parseInt(schemaRegionDir.getName()));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                futures.add(schemaRegionRecoverPools.submit(this.recoverSchemaRegionTask(storageGroup, schemaRegionId)));
                schemaRegionIdList.add(schemaRegionId);
            }
        }
        for (Future future : futures) {
            try {
                ISchemaRegion schemaRegion = (ISchemaRegion)future.get();
                this.schemaRegionMap.put(schemaRegion.getSchemaRegionId(), schemaRegion);
            }
            catch (InterruptedException | RuntimeException | ExecutionException e) {
                logger.error("Something wrong happened during SchemaRegion recovery: " + e.getMessage());
                e.printStackTrace();
            }
        }
        schemaRegionRecoverPools.shutdown();
        return partitionTable;
    }

    public void forceMlog() {
        if (this.schemaRegionMap != null) {
            for (ISchemaRegion schemaRegion : this.schemaRegionMap.values()) {
                schemaRegion.forceMlog();
            }
        }
    }

    public void clear() {
        SchemaResourceManager.clearSchemaResource();
        if (this.timedForceMLogThread != null) {
            this.timedForceMLogThread.shutdown();
            this.timedForceMLogThread = null;
        }
        if (this.schemaRegionMap != null) {
            for (ISchemaRegion schemaRegion : this.schemaRegionMap.values()) {
                schemaRegion.clear();
            }
            this.schemaRegionMap.clear();
            this.schemaRegionMap = null;
        }
        if (this.sharedPrefixTree != null) {
            this.sharedPrefixTree.clear();
            this.sharedPrefixTree = null;
        }
    }

    public ISchemaRegion getSchemaRegion(SchemaRegionId regionId) {
        return this.schemaRegionMap.get(regionId);
    }

    public Collection<ISchemaRegion> getAllSchemaRegions() {
        return this.schemaRegionMap.values();
    }

    public synchronized void createSchemaRegion(PartialPath storageGroup, SchemaRegionId schemaRegionId) throws MetadataException {
        ISchemaRegion schemaRegion = this.schemaRegionMap.get(schemaRegionId);
        if (schemaRegion != null) {
            if (schemaRegion.getStorageGroupFullPath().equals(storageGroup.getFullPath())) {
                return;
            }
            throw new MetadataException(String.format("SchemaRegion [%s] is duplicated between [%s] and [%s], and the former one has been recovered.", schemaRegionId, schemaRegion.getStorageGroupFullPath(), storageGroup.getFullPath()));
        }
        this.schemaRegionMap.put(schemaRegionId, this.createSchemaRegionWithoutExistenceCheck(storageGroup, schemaRegionId));
    }

    private Callable<ISchemaRegion> recoverSchemaRegionTask(PartialPath storageGroup, SchemaRegionId schemaRegionId) {
        return () -> {
            long timeRecord = System.currentTimeMillis();
            try {
                ISchemaRegion schemaRegion = this.createSchemaRegionWithoutExistenceCheck(storageGroup, schemaRegionId);
                timeRecord = System.currentTimeMillis() - timeRecord;
                logger.info(String.format("Recover [%s] spend: %s ms", storageGroup.concatNode(schemaRegionId.toString()), timeRecord));
                return schemaRegion;
            }
            catch (MetadataException e) {
                logger.error(String.format("SchemaRegion [%d] in StorageGroup [%s] failed to recover.", schemaRegionId.getId(), storageGroup.getFullPath()));
                throw new RuntimeException(e);
            }
        };
    }

    private ISchemaRegion createSchemaRegionWithoutExistenceCheck(PartialPath storageGroup, SchemaRegionId schemaRegionId) throws MetadataException {
        ISchemaRegion schemaRegion;
        IStorageGroupMNode storageGroupMNode = this.ensureStorageGroupByStorageGroupPath(storageGroup);
        switch (this.schemaRegionStoredMode) {
            case Memory: {
                schemaRegion = new SchemaRegionMemoryImpl(storageGroup, schemaRegionId, storageGroupMNode, this.seriesNumerLimiter);
                break;
            }
            case Schema_File: {
                schemaRegion = new SchemaRegionSchemaFileImpl(storageGroup, schemaRegionId, storageGroupMNode, this.seriesNumerLimiter);
                break;
            }
            case Rocksdb_based: {
                schemaRegion = new RSchemaRegionLoader().loadRSchemaRegion(storageGroup, schemaRegionId, storageGroupMNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("This mode [%s] is not supported. Please check and modify it.", new Object[]{this.schemaRegionStoredMode}));
            }
        }
        return schemaRegion;
    }

    private IStorageGroupMNode ensureStorageGroupByStorageGroupPath(PartialPath storageGroup) throws MetadataException {
        try {
            return this.sharedPrefixTree.getStorageGroupNodeByStorageGroupPath(storageGroup);
        }
        catch (StorageGroupNotSetException e) {
            block4: {
                try {
                    this.sharedPrefixTree.setStorageGroup(storageGroup);
                }
                catch (StorageGroupAlreadySetException storageGroupAlreadySetException) {
                    if (!storageGroupAlreadySetException.isHasChild()) break block4;
                    throw storageGroupAlreadySetException;
                }
            }
            return this.sharedPrefixTree.getStorageGroupNodeByStorageGroupPath(storageGroup);
        }
    }

    public synchronized void deleteSchemaRegion(SchemaRegionId schemaRegionId) throws MetadataException {
        ISchemaRegion schemaRegion = this.schemaRegionMap.get(schemaRegionId);
        if (schemaRegion == null) {
            logger.warn("SchemaRegion(id = {}) has been deleted, skiped", (Object)schemaRegionId);
            return;
        }
        schemaRegion.deleteSchemaRegion();
        this.schemaRegionMap.remove(schemaRegionId);
        File sgDir = new File(config.getSchemaDir(), schemaRegion.getStorageGroupFullPath());
        File[] regionDirList = sgDir.listFiles((dir, name) -> {
            try {
                Integer.parseInt(name);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        if (regionDirList == null || regionDirList.length == 0) {
            if (sgDir.exists()) {
                FileUtils.deleteDirectory((File)sgDir);
            }
            this.sharedPrefixTree.deleteStorageGroup(new PartialPath(schemaRegion.getStorageGroupFullPath()));
        }
    }

    public void setSeriesNumerLimiter(ISeriesNumerLimiter seriesNumerLimiter) {
        this.seriesNumerLimiter = seriesNumerLimiter;
    }

    private static class SchemaEngineManagerHolder {
        private static final SchemaEngine INSTANCE = new SchemaEngine();

        private SchemaEngineManagerHolder() {
        }
    }
}

