/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSchemaRegionLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSchemaRegionLoader.class);
    private static URLClassLoader urlClassLoader = null;
    private static final String RSCHEMA_REGION_CLASS_NAME = "org.apache.iotdb.db.metadata.schemaregion.rocksdb.RSchemaRegion";
    private static final String RSCHEMA_CONF_LOADER_CLASS_NAME = "org.apache.iotdb.db.metadata.schemaregion.rocksdb.RSchemaConfLoader";
    private static final String LIB_PATH = ".." + File.separator + "lib" + File.separator + "rschema-region" + File.separator;

    public ISchemaRegion loadRSchemaRegion(PartialPath storageGroup, SchemaRegionId schemaRegionId, IStorageGroupMNode node) {
        ISchemaRegion region = null;
        LOGGER.info("Creating instance for schema-engine-rocksdb");
        try {
            this.loadRSchemaRegionJar();
            Class<?> classForRSchemaRegion = urlClassLoader.loadClass(RSCHEMA_REGION_CLASS_NAME);
            Class<?> classForRSchemaConfLoader = urlClassLoader.loadClass(RSCHEMA_CONF_LOADER_CLASS_NAME);
            Constructor<?> constructor = classForRSchemaRegion.getConstructor(PartialPath.class, SchemaRegionId.class, IStorageGroupMNode.class, classForRSchemaConfLoader);
            Object rSchemaLoader = classForRSchemaConfLoader.getConstructor(new Class[0]).newInstance(new Object[0]);
            region = (ISchemaRegion)constructor.newInstance(storageGroup, schemaRegionId, node, rSchemaLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException | MalformedURLException e) {
            LOGGER.error("Cannot initialize RSchemaRegion", (Throwable)e);
            return null;
        }
        return region;
    }

    private void loadRSchemaRegionJar() throws MalformedURLException {
        LOGGER.info("Loading jar for schema-engine-rocksdb");
        if (urlClassLoader == null) {
            File[] jars = new File(LIB_PATH).listFiles();
            if (jars == null) {
                throw new RuntimeException(String.format("Cannot get jars from %s", new File(LIB_PATH).getAbsolutePath()));
            }
            LinkedList<URL> dependentJars = new LinkedList<URL>();
            for (File jar : jars) {
                if (!jar.getName().endsWith(".jar")) continue;
                dependentJars.add(new URL("file:" + jar.getAbsolutePath()));
            }
            urlClassLoader = new URLClassLoader(dependentJars.toArray(new URL[0]));
        }
    }
}

