/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaFileNotExists;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaPage;
import org.apache.iotdb.db.metadata.template.TemplateManager;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFile
implements ISchemaFile {
    private static final Logger logger = LoggerFactory.getLogger(SchemaFile.class);
    public static int FILE_HEADER_SIZE = 256;
    public static int PAGE_LENGTH = 16384;
    public static long PAGE_INDEX_MASK = 0xFFFFFFFFL;
    public static short PAGE_HEADER_SIZE = (short)16;
    public static int PAGE_CACHE_SIZE = IoTDBDescriptor.getInstance().getConfig().getPageCacheSizeInSchemaFile();
    public static int ROOT_INDEX = 0;
    public static int INDEX_LENGTH = 4;
    public static short SEG_OFF_DIG = (short)2;
    public static short SEG_MAX_SIZ = (short)(16384 - PAGE_HEADER_SIZE - SEG_OFF_DIG);
    public static short[] SEG_SIZE_LST = new short[]{1024, 2048, 4096, 8192, SEG_MAX_SIZ};
    public static short SEG_MIN_SIZ = IoTDBDescriptor.getInstance().getConfig().getMinimumSegmentInSchemaFile() > SEG_MAX_SIZ ? SEG_MAX_SIZ : IoTDBDescriptor.getInstance().getConfig().getMinimumSegmentInSchemaFile();
    public static int SEG_INDEX_DIGIT = 16;
    public static long SEG_INDEX_MASK = 65535L;
    public static String SCHEMA_FOLDER = IoTDBDescriptor.getInstance().getConfig().getSchemaDir();
    private String filePath;
    private String storageGroupName;
    private long dataTTL;
    boolean isEntity;
    private int templateHash;
    private ByteBuffer headerContent;
    private int lastPageIndex;
    private long lastSGAddr;
    private final Map<Integer, ISchemaPage> pageInstCache;
    private final ReentrantLock evictLock;
    private final PageLocks pageLocks;
    private ISchemaPage rootPage;
    private final Map<Integer, ISchemaPage> dirtyPages;
    private File pmtFile;
    private FileChannel channel;

    private SchemaFile(String sgName, int schemaRegionId, boolean override, long ttl, boolean isEntity) throws IOException, MetadataException {
        this.storageGroupName = sgName;
        this.filePath = SCHEMA_FOLDER + File.separator + sgName + File.separator + schemaRegionId + File.separator + "schema_file.pst";
        this.pmtFile = SystemFileFactory.INSTANCE.getFile(this.filePath);
        if (!this.pmtFile.exists() && !override) {
            throw new SchemaFileNotExists(this.filePath);
        }
        if (this.pmtFile.exists() && override) {
            logger.warn(String.format("Schema File [%s] will be overwritten since already exists.", this.filePath));
            Files.delete(Paths.get(this.pmtFile.toURI()));
            this.pmtFile.createNewFile();
        }
        if (!this.pmtFile.exists() || !this.pmtFile.isFile()) {
            File folder = SystemFileFactory.INSTANCE.getFile(SCHEMA_FOLDER + File.separator + sgName + File.separator + schemaRegionId);
            folder.mkdirs();
            this.pmtFile.createNewFile();
        }
        this.channel = new RandomAccessFile(this.pmtFile, "rw").getChannel();
        this.headerContent = ByteBuffer.allocate(FILE_HEADER_SIZE);
        this.pageInstCache = Collections.synchronizedMap(new LinkedHashMap(PAGE_CACHE_SIZE, 1.0f, true));
        this.dirtyPages = new ConcurrentHashMap<Integer, ISchemaPage>();
        this.evictLock = new ReentrantLock();
        this.pageLocks = new PageLocks();
        this.dataTTL = ttl;
        this.isEntity = isEntity;
        this.templateHash = 0;
        this.initFileHeader();
    }

    private SchemaFile(File file) throws IOException, MetadataException {
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        this.headerContent = ByteBuffer.allocate(FILE_HEADER_SIZE);
        this.pageInstCache = Collections.synchronizedMap(new LinkedHashMap(PAGE_CACHE_SIZE, 1.0f, true));
        this.dirtyPages = new ConcurrentHashMap<Integer, ISchemaPage>();
        this.evictLock = new ReentrantLock();
        this.pageLocks = new PageLocks();
        if (this.channel.size() <= 0L) {
            this.channel.close();
            throw new SchemaFileNotExists(file.getAbsolutePath());
        }
        this.initFileHeader();
    }

    public static ISchemaFile initSchemaFile(String sgName, int schemaRegionId) throws IOException, MetadataException {
        return new SchemaFile(sgName, schemaRegionId, true, CommonDescriptor.getInstance().getConfig().getDefaultTTL(), false);
    }

    public static ISchemaFile loadSchemaFile(String sgName, int schemaRegionId) throws IOException, MetadataException {
        return new SchemaFile(sgName, schemaRegionId, false, -1L, false);
    }

    public static ISchemaFile loadSchemaFile(File file) throws IOException, MetadataException {
        return new SchemaFile(file);
    }

    @Override
    public IMNode init() throws MetadataException {
        String[] sgPathNodes = PathUtils.splitPathToDetachedNodes((String)this.storageGroupName);
        IMNode resNode = this.isEntity ? SchemaFile.setNodeAddress(new StorageGroupEntityMNode(null, sgPathNodes[sgPathNodes.length - 1], this.dataTTL), 0L) : SchemaFile.setNodeAddress(new StorageGroupMNode(null, sgPathNodes[sgPathNodes.length - 1], this.dataTTL), 0L);
        resNode.setFullPath(this.storageGroupName);
        if (this.templateHash != 0) {
            resNode.setSchemaTemplate(TemplateManager.getInstance().getTemplateFromHash(this.templateHash));
        }
        return resNode;
    }

    @Override
    public boolean updateStorageGroupNode(IStorageGroupMNode sgNode) throws IOException {
        this.dataTTL = sgNode.getDataTTL();
        this.isEntity = sgNode.isEntity();
        this.templateHash = sgNode.getSchemaTemplate() == null ? 0 : sgNode.getSchemaTemplate().hashCode();
        this.updateHeader();
        return true;
    }

    @Override
    public void writeMNode(IMNode node) throws MetadataException, IOException {
        ByteBuffer childBuffer;
        IMNode child;
        short curSegIdx;
        int pageIndex;
        ISchemaPage curPage = null;
        long curSegAddr = SchemaFile.getNodeAddress(node);
        if (node.isStorageGroup()) {
            curSegAddr = this.lastSGAddr;
            pageIndex = SchemaFile.getPageIndex(this.lastSGAddr);
            curSegIdx = SchemaFile.getSegIndex(this.lastSGAddr);
            this.isEntity = node.isEntity();
            SchemaFile.setNodeAddress(node, this.lastSGAddr);
        } else {
            if ((curSegAddr & Long.MIN_VALUE) != 0L) {
                throw new MetadataException(String.format("Cannot store a node with segment address [%s] except for StorageGroupNode.", curSegAddr));
            }
            pageIndex = SchemaFile.getPageIndex(curSegAddr);
            curSegIdx = SchemaFile.getSegIndex(curSegAddr);
        }
        for (Map.Entry<String, IMNode> entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getNewChildBuffer().entrySet()) {
            child = entry.getValue();
            if (!child.isMeasurement()) {
                if (SchemaFile.getNodeAddress(child) < 0L) {
                    short estSegSize = SchemaFile.estimateSegmentSize(child);
                    long glbIndex = this.preAllocateSegment(estSegSize);
                    SchemaFile.setNodeAddress(child, glbIndex);
                } else {
                    throw new MetadataException("A child in newChildBuffer shall not have segmentAddress.");
                }
            }
            childBuffer = RecordUtils.node2Buffer(child);
            try {
                curPage = this.getPageInstance(pageIndex);
                this.dirtyPages.putIfAbsent(curPage.getPageIndex(), curPage);
                long npAddress = curPage.write(curSegIdx, entry.getKey(), childBuffer);
                while (npAddress > 0L) {
                    pageIndex = SchemaFile.getPageIndex(npAddress);
                    curSegIdx = SchemaFile.getSegIndex(npAddress);
                    curPage = this.getPageInstance(pageIndex);
                    npAddress = curPage.write(curSegIdx, entry.getKey(), childBuffer);
                }
                this.dirtyPages.putIfAbsent(curPage.getPageIndex(), curPage);
            }
            catch (SchemaPageOverflowException e) {
                short newSegSize = SchemaFile.reEstimateSegSize(curPage.getSegmentSize(curSegIdx));
                ISchemaPage newPage = this.getMinApplicablePageInMem(newSegSize);
                if (newSegSize == curPage.getSegmentSize(curSegIdx)) {
                    short newSegId = newPage.allocNewSegment(newSegSize);
                    long newSegAddr = SchemaFile.getGlobalIndex(newPage.getPageIndex(), newSegId);
                    newPage.setPrevSegAddress(newSegId, curSegAddr);
                    curPage.setNextSegAddress(curSegIdx, newSegAddr);
                    curSegAddr = newSegAddr;
                } else {
                    curSegAddr = newPage.transplantSegment(curPage, curSegIdx, newSegSize);
                    curPage.deleteSegment(curSegIdx);
                    curSegIdx = SchemaFile.getSegIndex(curSegAddr);
                }
                SchemaFile.setNodeAddress(node, curSegAddr);
                this.updateParentalRecord(node.getParent(), node.getName(), curSegAddr);
                this.dirtyPages.putIfAbsent(curPage.getPageIndex(), curPage);
                curPage = newPage;
                pageIndex = curPage.getPageIndex();
                curPage.write(curSegIdx, entry.getKey(), childBuffer);
            }
        }
        curSegAddr = SchemaFile.getNodeAddress(node);
        for (Map.Entry<String, IMNode> entry : ICachedMNodeContainer.getCachedMNodeContainer(node).getUpdatedChildBuffer().entrySet()) {
            child = entry.getValue();
            childBuffer = RecordUtils.node2Buffer(child);
            long actualSegAddr = this.getTargetSegmentAddress(curSegAddr, entry.getKey());
            if (actualSegAddr < 0L) {
                throw new MetadataException(String.format("Node[%s] has no child[%s] in schema file.", node.getName(), entry.getKey()));
            }
            try {
                curPage = this.getPageInstance(SchemaFile.getPageIndex(actualSegAddr));
                curSegIdx = SchemaFile.getSegIndex(actualSegAddr);
                this.dirtyPages.putIfAbsent(curPage.getPageIndex(), curPage);
                curPage.update(curSegIdx, entry.getKey(), childBuffer);
            }
            catch (SchemaPageOverflowException e) {
                short newSegSize = SchemaFile.reEstimateSegSize(curPage.getSegmentSize(curSegIdx));
                if (curPage.getSegmentSize(curSegIdx) != newSegSize) {
                    ISchemaPage newPage = this.getMinApplicablePageInMem(newSegSize);
                    long newSegAddr = newPage.transplantSegment(curPage, curSegIdx, newSegSize);
                    newPage.update(SchemaFile.getSegIndex(newSegAddr), entry.getKey(), childBuffer);
                    curPage.deleteSegment(curSegIdx);
                    SchemaFile.setNodeAddress(node, newSegAddr);
                    this.updateParentalRecord(node.getParent(), node.getName(), newSegAddr);
                    this.dirtyPages.putIfAbsent(curPage.getPageIndex(), curPage);
                    continue;
                }
                long existedSegAddr = this.getApplicableLinkedSegments(curPage, curSegIdx, entry.getKey(), childBuffer);
                if (existedSegAddr < 0L) {
                    ISchemaPage newPage = this.getMinApplicablePageInMem(newSegSize);
                    existedSegAddr = SchemaFile.getGlobalIndex(newPage.getPageIndex(), newPage.allocNewSegment(newSegSize));
                    long nextSegAddr = curPage.getNextSegAddress(curSegIdx);
                    if (nextSegAddr != -1L) {
                        ISchemaPage nextPage = this.getPageInstance(SchemaFile.getPageIndex(nextSegAddr));
                        nextPage.setPrevSegAddress(SchemaFile.getSegIndex(nextSegAddr), existedSegAddr);
                        this.dirtyPages.putIfAbsent(nextPage.getPageIndex(), nextPage);
                    }
                    newPage.setNextSegAddress(SchemaFile.getSegIndex(existedSegAddr), nextSegAddr);
                    newPage.setPrevSegAddress(SchemaFile.getSegIndex(existedSegAddr), actualSegAddr);
                    curPage.setNextSegAddress(SchemaFile.getSegIndex(actualSegAddr), existedSegAddr);
                }
                ISchemaPage existedPage = this.getPageInstance(SchemaFile.getPageIndex(existedSegAddr));
                existedPage.write(SchemaFile.getSegIndex(existedSegAddr), entry.getKey(), childBuffer);
                curPage.removeRecord(SchemaFile.getSegIndex(actualSegAddr), entry.getKey());
                this.dirtyPages.putIfAbsent(curPage.getPageIndex(), curPage);
                this.dirtyPages.putIfAbsent(existedPage.getPageIndex(), existedPage);
            }
        }
        this.flushAllDirtyPages();
    }

    @Override
    public void delete(IMNode node) throws IOException, MetadataException {
        long recSegAddr = node.getParent() == null ? (long)ROOT_INDEX : SchemaFile.getNodeAddress(node.getParent());
        recSegAddr = this.getTargetSegmentAddress(recSegAddr, node.getName());
        ISchemaPage tarPage = this.getPageInstance(SchemaFile.getPageIndex(recSegAddr));
        this.dirtyPages.putIfAbsent(tarPage.getPageIndex(), tarPage);
        tarPage.removeRecord(SchemaFile.getSegIndex(recSegAddr), node.getName());
        if (!node.isMeasurement()) {
            long delSegAddr = SchemaFile.getNodeAddress(node);
            tarPage = this.getPageInstance(SchemaFile.getPageIndex(delSegAddr));
            this.dirtyPages.putIfAbsent(tarPage.getPageIndex(), tarPage);
            tarPage.deleteSegment(SchemaFile.getSegIndex(delSegAddr));
        }
        this.flushAllDirtyPages();
    }

    @Override
    public IMNode getChildNode(IMNode parent, String childName) throws MetadataException, IOException {
        if (SchemaFile.getNodeAddress(parent) < 0L) {
            throw new MetadataException(String.format("Node [%s] has no valid segment address in schema file.", parent.getFullPath()));
        }
        long actualSegAddr = this.getTargetSegmentAddress(SchemaFile.getNodeAddress(parent), childName);
        if (actualSegAddr < 0L) {
            return null;
        }
        try {
            return this.getPageInstance(SchemaFile.getPageIndex(actualSegAddr)).read(SchemaFile.getSegIndex(actualSegAddr), childName);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            int pIdx = SchemaFile.getPageIndex(actualSegAddr);
            short sIdx = SchemaFile.getSegIndex(actualSegAddr);
            logger.error(String.format("Get child[%s] from parent[%s] failed, actualAddress:%s(%d, %d)", childName, parent.getName(), actualSegAddr, pIdx, sIdx));
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public Iterator<IMNode> getChildren(IMNode parent) throws MetadataException, IOException {
        if (parent.isMeasurement() || SchemaFile.getNodeAddress(parent) < 0L) {
            throw new MetadataException(String.format("Node [%s] has no child in schema file.", parent.getFullPath()));
        }
        int pageIdx = SchemaFile.getPageIndex(SchemaFile.getNodeAddress(parent));
        final short segId = SchemaFile.getSegIndex(SchemaFile.getNodeAddress(parent));
        final ISchemaPage page = this.getPageInstance(pageIdx);
        return new Iterator<IMNode>(){
            long nextSeg;
            long prevSeg;
            final Queue<IMNode> children;
            {
                this.nextSeg = page.getNextSegAddress(segId);
                this.prevSeg = page.getPrevSegAddress(segId);
                this.children = page.getChildren(segId);
            }

            @Override
            public boolean hasNext() {
                if (this.children.size() == 0) {
                    if (this.nextSeg < 0L && this.prevSeg < 0L) {
                        return false;
                    }
                    try {
                        if (this.nextSeg >= 0L) {
                            ISchemaPage newPage = SchemaFile.this.getPageInstance(SchemaFile.getPageIndex(this.nextSeg));
                            this.children.addAll(newPage.getChildren(SchemaFile.getSegIndex(this.nextSeg)));
                            this.nextSeg = newPage.getNextSegAddress(SchemaFile.getSegIndex(this.nextSeg));
                            return true;
                        }
                        if (this.prevSeg >= 0L) {
                            ISchemaPage newPage = SchemaFile.this.getPageInstance(SchemaFile.getPageIndex(this.prevSeg));
                            this.children.addAll(newPage.getChildren(SchemaFile.getSegIndex(this.prevSeg)));
                            this.prevSeg = newPage.getPrevSegAddress(SchemaFile.getSegIndex(this.prevSeg));
                            return true;
                        }
                    }
                    catch (IOException | MetadataException e) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public IMNode next() {
                return this.children.poll();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.updateHeader();
        this.flushPageToFile(this.rootPage);
        for (Map.Entry<Integer, ISchemaPage> entry : this.dirtyPages.entrySet()) {
            this.flushPageToFile(entry.getValue());
        }
        this.channel.close();
    }

    @Override
    public void sync() throws IOException {
        this.updateHeader();
        this.flushPageToFile(this.rootPage);
        for (Map.Entry<Integer, ISchemaPage> entry : this.dirtyPages.entrySet()) {
            this.flushPageToFile(entry.getValue());
        }
    }

    @Override
    public void clear() throws IOException, MetadataException {
        this.pageInstCache.clear();
        this.dirtyPages.clear();
        this.channel.close();
        this.rootPage = null;
        if (this.pmtFile.exists()) {
            Files.delete(Paths.get(this.pmtFile.toURI()));
        }
        this.pmtFile.createNewFile();
        this.channel = new RandomAccessFile(this.pmtFile, "rw").getChannel();
        this.headerContent = ByteBuffer.allocate(FILE_HEADER_SIZE);
        this.initFileHeader();
    }

    public String inspect() throws MetadataException, IOException {
        StringBuilder builder = new StringBuilder(String.format("=============================\n== Schema File Sketch Tool ==\n=============================\n== Notice: \n==  Internal/Entity presents as (name, is_aligned, child_segment_address)\n==  Measurement presents as (name, data_type, encoding, compressor, alias_if_exist)\n=============================\nBelong to StorageGroup: [%s], segment of SG:%s, total pages:%d\n", this.storageGroupName == null ? "NOT SPECIFIED" : this.storageGroupName, Long.toHexString(this.lastSGAddr), this.lastPageIndex + 1));
        for (int cnt = 0; cnt <= this.lastPageIndex; ++cnt) {
            ISchemaPage page = this.getPageInstance(cnt);
            builder.append(String.format("---------------------\n%s\n", page.inspect()));
        }
        return builder.toString();
    }

    private void initFileHeader() throws IOException, MetadataException {
        if (this.channel.size() == 0L) {
            this.lastPageIndex = 0;
            ReadWriteIOUtils.write((int)this.lastPageIndex, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((long)this.dataTTL, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((Boolean)this.isEntity, (ByteBuffer)this.headerContent);
            ReadWriteIOUtils.write((int)this.templateHash, (ByteBuffer)this.headerContent);
            this.lastSGAddr = 0L;
            this.initRootPage();
        } else {
            this.channel.read(this.headerContent);
            this.headerContent.clear();
            this.lastPageIndex = ReadWriteIOUtils.readInt((ByteBuffer)this.headerContent);
            this.dataTTL = ReadWriteIOUtils.readLong((ByteBuffer)this.headerContent);
            this.isEntity = ReadWriteIOUtils.readBool((ByteBuffer)this.headerContent);
            this.templateHash = ReadWriteIOUtils.readInt((ByteBuffer)this.headerContent);
            this.lastSGAddr = ReadWriteIOUtils.readLong((ByteBuffer)this.headerContent);
            this.rootPage = this.getPageInstance(0);
        }
    }

    private void updateHeader() throws IOException {
        this.headerContent.clear();
        ReadWriteIOUtils.write((int)this.lastPageIndex, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((long)this.dataTTL, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((Boolean)this.isEntity, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((int)this.templateHash, (ByteBuffer)this.headerContent);
        ReadWriteIOUtils.write((long)this.lastSGAddr, (ByteBuffer)this.headerContent);
        this.headerContent.clear();
        this.channel.write(this.headerContent, 0L);
        this.channel.force(true);
    }

    private void initRootPage() throws IOException, MetadataException {
        if (this.rootPage == null) {
            this.rootPage = SchemaPage.initPage(ByteBuffer.allocate(PAGE_LENGTH), 0);
            this.rootPage.allocNewSegment(SEG_MAX_SIZ);
            this.lastPageIndex = 0;
            this.pageInstCache.put(this.rootPage.getPageIndex(), this.rootPage);
            this.dirtyPages.putIfAbsent(this.rootPage.getPageIndex(), this.rootPage);
        }
    }

    private boolean isStorageGroupNode(IMNode node) {
        return node.getFullPath().equals(this.storageGroupName);
    }

    private long getTargetSegmentAddress(long curSegAddr, String recKey) throws IOException, MetadataException {
        short curSegId = SchemaFile.getSegIndex(curSegAddr);
        ISchemaPage curPage = this.getPageInstance(SchemaFile.getPageIndex(curSegAddr));
        if (curPage.hasRecordKeyInSegment(recKey, curSegId)) {
            return curSegAddr;
        }
        long nextSegAddr = curPage.getNextSegAddress(curSegId);
        while (nextSegAddr >= 0L) {
            short pSegId;
            ISchemaPage pivotPage = this.getPageInstance(SchemaFile.getPageIndex(nextSegAddr));
            if (pivotPage.hasRecordKeyInSegment(recKey, pSegId = SchemaFile.getSegIndex(nextSegAddr))) {
                return nextSegAddr;
            }
            nextSegAddr = pivotPage.getNextSegAddress(pSegId);
        }
        long prevSegAddr = curPage.getPrevSegAddress(curSegId);
        while (prevSegAddr >= 0L) {
            short pSegId;
            ISchemaPage pivotPage = this.getPageInstance(SchemaFile.getPageIndex(prevSegAddr));
            if (pivotPage.hasRecordKeyInSegment(recKey, pSegId = SchemaFile.getSegIndex(prevSegAddr))) {
                return prevSegAddr;
            }
            prevSegAddr = pivotPage.getPrevSegAddress(pSegId);
        }
        return -1L;
    }

    private long getApplicableLinkedSegments(ISchemaPage curPage, short curSegId, String key, ByteBuffer buffer) throws IOException, MetadataException {
        if (curPage.getSegmentSize(curSegId) < SEG_MAX_SIZ) {
            return -1L;
        }
        short totalSize = (short)(key.getBytes().length + buffer.capacity() + 4 + 2);
        long nextSegAddr = curPage.getNextSegAddress(curSegId);
        while (nextSegAddr >= 0L) {
            ISchemaPage nextPage = this.getPageInstance(SchemaFile.getPageIndex(nextSegAddr));
            if (nextPage.isSegmentCapableFor(SchemaFile.getSegIndex(nextSegAddr), totalSize)) {
                return nextSegAddr;
            }
            nextSegAddr = nextPage.getNextSegAddress(SchemaFile.getSegIndex(nextSegAddr));
        }
        long prevSegAddr = curPage.getPrevSegAddress(curSegId);
        while (prevSegAddr >= 0L) {
            ISchemaPage prevPage = this.getPageInstance(SchemaFile.getPageIndex(prevSegAddr));
            if (prevPage.isSegmentCapableFor(SchemaFile.getSegIndex(prevSegAddr), totalSize)) {
                return prevSegAddr;
            }
            prevSegAddr = prevPage.getPrevSegAddress(SchemaFile.getSegIndex(prevSegAddr));
        }
        return -1L;
    }

    private long preAllocateSegment(short size) throws IOException, MetadataException {
        ISchemaPage page = this.getMinApplicablePageInMem(size);
        return SchemaFile.getGlobalIndex(page.getPageIndex(), page.allocNewSegment(size));
    }

    private ISchemaPage getMinApplicablePageInMem(short size) throws IOException {
        for (Map.Entry<Integer, ISchemaPage> entry : this.dirtyPages.entrySet()) {
            if (!entry.getValue().isCapableForSize(size)) continue;
            return this.dirtyPages.get(entry.getKey());
        }
        for (Map.Entry<Integer, ISchemaPage> entry : this.pageInstCache.entrySet()) {
            if (!entry.getValue().isCapableForSize(size)) continue;
            this.dirtyPages.putIfAbsent(entry.getKey(), entry.getValue());
            return this.pageInstCache.get(entry.getKey());
        }
        return this.allocateNewPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchemaPage getPageInstance(int pageIdx) throws IOException, MetadataException {
        if (pageIdx > this.lastPageIndex) {
            throw new MetadataException(String.format("Page index %d out of range.", pageIdx));
        }
        if (pageIdx == ROOT_INDEX && this.rootPage != null) {
            return this.rootPage;
        }
        this.pageLocks.readLock(pageIdx);
        try {
            if (this.dirtyPages.containsKey(pageIdx)) {
                ISchemaPage iSchemaPage = this.dirtyPages.get(pageIdx);
                return iSchemaPage;
            }
            if (this.pageInstCache.containsKey(pageIdx)) {
                ISchemaPage iSchemaPage = this.pageInstCache.get(pageIdx);
                return iSchemaPage;
            }
        }
        finally {
            this.pageLocks.readUnlock(pageIdx);
        }
        try {
            this.pageLocks.writeLock(pageIdx);
            ByteBuffer newBuf = ByteBuffer.allocate(PAGE_LENGTH);
            this.loadFromFile(newBuf, pageIdx);
            ISchemaPage iSchemaPage = this.addPageToCache(pageIdx, SchemaPage.loadPage(newBuf, pageIdx));
            return iSchemaPage;
        }
        finally {
            this.pageLocks.writeUnlock(pageIdx);
        }
    }

    private int loadFromFile(ByteBuffer dst, int pageIndex) throws IOException {
        dst.clear();
        return this.channel.read(dst, this.getPageAddress(pageIndex));
    }

    private synchronized ISchemaPage allocateNewPage() throws IOException {
        ++this.lastPageIndex;
        ISchemaPage newPage = SchemaPage.initPage(ByteBuffer.allocate(PAGE_LENGTH), this.lastPageIndex);
        this.dirtyPages.putIfAbsent(newPage.getPageIndex(), newPage);
        return this.addPageToCache(newPage.getPageIndex(), newPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchemaPage addPageToCache(int pageIndex, ISchemaPage page) throws IOException {
        this.pageInstCache.put(pageIndex, page);
        if (this.evictLock.tryLock()) {
            try {
                if (this.pageInstCache.size() > PAGE_CACHE_SIZE) {
                    int removeCnt = (int)(0.2 * (double)this.pageInstCache.size()) > 0 ? (int)(0.2 * (double)this.pageInstCache.size()) : 1;
                    List<Integer> rmvIds = new ArrayList<Integer>(this.pageInstCache.keySet()).subList(0, removeCnt);
                    for (Integer id : rmvIds) {
                        if (!this.pageLocks.findLock(id).writeLock().tryLock()) continue;
                        try {
                            this.pageInstCache.remove(id);
                        }
                        finally {
                            this.pageLocks.findLock(id).writeLock().unlock();
                        }
                    }
                }
            }
            finally {
                this.evictLock.unlock();
            }
        }
        return page;
    }

    public static long getGlobalIndex(int pageIndex, short segIndex) {
        return (PAGE_INDEX_MASK & (long)pageIndex) << SEG_INDEX_DIGIT | (long)segIndex & SEG_INDEX_MASK;
    }

    public static int getPageIndex(long globalIndex) {
        return (int)((globalIndex & PAGE_INDEX_MASK << SEG_INDEX_DIGIT) >> SEG_INDEX_DIGIT);
    }

    public static short getSegIndex(long globalIndex) {
        return (short)(globalIndex & SEG_INDEX_MASK);
    }

    private void updateParentalRecord(IMNode parent, String key, long newSegAddr) throws IOException, MetadataException {
        if (parent == null || parent.getChild(key).isStorageGroup()) {
            this.lastSGAddr = newSegAddr;
            this.updateHeader();
            return;
        }
        long parSegAddr = parent.getParent() == null ? (long)ROOT_INDEX : SchemaFile.getNodeAddress(parent);
        parSegAddr = this.getTargetSegmentAddress(parSegAddr, key);
        ISchemaPage page = this.getPageInstance(SchemaFile.getPageIndex(parSegAddr));
        ((SchemaPage)page).updateRecordSegAddr(SchemaFile.getSegIndex(parSegAddr), key, newSegAddr);
        this.dirtyPages.putIfAbsent(page.getPageIndex(), page);
    }

    static short reEstimateSegSize(int oldSize) {
        for (short size : SEG_SIZE_LST) {
            if (oldSize >= size) continue;
            return size;
        }
        return SEG_MAX_SIZ;
    }

    static short estimateSegmentSize(IMNode node) {
        int childNum = node.getChildren().size();
        int tier = SEG_SIZE_LST.length;
        if (childNum > 300) {
            return SEG_SIZE_LST[tier - 1] > SEG_MIN_SIZ ? SEG_SIZE_LST[tier - 1] : SEG_MIN_SIZ;
        }
        if (childNum > 150) {
            return SEG_SIZE_LST[tier - 2] > SEG_MIN_SIZ ? SEG_SIZE_LST[tier - 2] : SEG_MIN_SIZ;
        }
        if (childNum > 75) {
            return SEG_SIZE_LST[tier - 3] > SEG_MIN_SIZ ? SEG_SIZE_LST[tier - 3] : SEG_MIN_SIZ;
        }
        if (childNum > 40) {
            return SEG_SIZE_LST[tier - 4] > SEG_MIN_SIZ ? SEG_SIZE_LST[tier - 4] : SEG_MIN_SIZ;
        }
        if (childNum > 20) {
            return SEG_SIZE_LST[tier - 5] > SEG_MIN_SIZ ? SEG_SIZE_LST[tier - 5] : SEG_MIN_SIZ;
        }
        int totalSize = 25;
        for (IMNode child : node.getChildren().values()) {
            totalSize += child.getName().getBytes().length;
            totalSize += 6;
            if (child.isMeasurement()) {
                totalSize += child.getAsMeasurementMNode().getAlias() == null ? 4 : child.getAsMeasurementMNode().getAlias().getBytes().length + 4;
                totalSize += 24;
                continue;
            }
            totalSize += 16;
        }
        return (short)totalSize > SEG_MIN_SIZ ? (short)totalSize : SEG_MIN_SIZ;
    }

    private long getPageAddress(int pageIndex) {
        return (PAGE_INDEX_MASK & (long)pageIndex) * (long)PAGE_LENGTH + (long)FILE_HEADER_SIZE;
    }

    public static long getNodeAddress(IMNode node) {
        return ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress();
    }

    public static IMNode setNodeAddress(IMNode node, long addr) {
        ICachedMNodeContainer.getCachedMNodeContainer(node).setSegmentAddress(addr);
        return node;
    }

    private void flushPageToFile(ISchemaPage src) throws IOException {
        if (src == null) {
            return;
        }
        src.syncPageBuffer();
        ByteBuffer srcBuf = ByteBuffer.allocate(PAGE_LENGTH);
        src.getPageBuffer(srcBuf);
        srcBuf.clear();
        this.channel.write(srcBuf, this.getPageAddress(src.getPageIndex()));
    }

    private synchronized void flushAllDirtyPages() throws IOException {
        for (ISchemaPage page : this.dirtyPages.values()) {
            this.flushPageToFile(page);
        }
        this.updateHeader();
        this.dirtyPages.clear();
    }

    public SchemaPage getPageOnTest(int index) throws IOException, MetadataException {
        return (SchemaPage)this.getPageInstance(index);
    }

    public long getTargetSegmentOnTest(long srcSegAddr, String key) throws IOException, MetadataException {
        return this.getTargetSegmentAddress(srcSegAddr, key);
    }

    private class PageLocks {
        private static final int NUM_OF_LOCKS = 1039;
        private ReentrantReadWriteLock[] locks = new ReentrantReadWriteLock[1039];

        protected PageLocks() {
            for (int i = 0; i < 1039; ++i) {
                this.locks[i] = new ReentrantReadWriteLock();
            }
        }

        public void readLock(int hash) {
            this.findLock(hash).readLock().lock();
        }

        public void readUnlock(int hash) {
            this.findLock(hash).readLock().unlock();
        }

        public void writeLock(int hash) {
            this.findLock(hash).writeLock().lock();
        }

        public void writeUnlock(int hash) {
            this.findLock(hash).writeLock().unlock();
        }

        private ReentrantReadWriteLock findLock(int hash) {
            return this.locks[hash % 1039];
        }
    }
}

