/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.snapshot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLogAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotLogAnalyzer.class);
    private File snapshotLogFile;
    private BufferedReader reader;

    public SnapshotLogAnalyzer(File snapshotLogFile) throws FileNotFoundException {
        this.snapshotLogFile = snapshotLogFile;
        this.reader = new BufferedReader(new FileReader(snapshotLogFile));
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            LOGGER.error("Exception occurs when closing log analyzer", (Throwable)e);
        }
    }

    public boolean hasNext() {
        try {
            return this.reader != null && this.reader.ready();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Pair<String, String> getNextPairs() {
        if (this.reader == null) {
            return null;
        }
        try {
            String fileInfo = this.reader.readLine();
            String[] filesPath = fileInfo.split("#");
            if (filesPath.length != 2) {
                LOGGER.warn("Illegal file info: {} in snapshot log", (Object)fileInfo);
                return null;
            }
            return new Pair((Object)filesPath[0], (Object)filesPath[1]);
        }
        catch (IOException e) {
            LOGGER.error("Exception occurs when analyzing snapshot log", (Throwable)e);
            return null;
        }
    }
}

