/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.snapshot.SnapshotFileSet;
import org.apache.iotdb.db.engine.snapshot.SnapshotLogAnalyzer;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLoader {
    private Logger LOGGER = LoggerFactory.getLogger(SnapshotLoader.class);
    private String storageGroupName;
    private String snapshotPath;
    private String dataRegionId;
    private SnapshotLogAnalyzer logAnalyzer;

    public SnapshotLoader(String snapshotPath, String storageGroupName, String dataRegionId) {
        this.snapshotPath = snapshotPath;
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
    }

    private DataRegion loadSnapshot() {
        try {
            return new DataRegion(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "storage_groups" + File.separator + this.storageGroupName, this.dataRegionId, StorageEngineV2.getInstance().getFileFlushPolicy(), this.storageGroupName);
        }
        catch (Exception e) {
            this.LOGGER.error("Exception occurs while load snapshot from {}", (Object)this.snapshotPath, (Object)e);
            return null;
        }
    }

    private File getSnapshotLogFile() {
        File sourceDataDir = new File(this.snapshotPath);
        if (sourceDataDir.exists()) {
            Object[] files = sourceDataDir.listFiles((dir, name) -> name.equals("snapshot.log"));
            if (files == null || files.length == 0) {
                this.LOGGER.warn("Failed to find snapshot log file, cannot recover it");
            } else if (files.length > 1) {
                this.LOGGER.warn("Found more than one snapshot log file, cannot recover it. {}", (Object)Arrays.toString(files));
            } else {
                this.LOGGER.info("Reading snapshot log file {}", files[0]);
                return files[0];
            }
        }
        return null;
    }

    public DataRegion loadSnapshotForStateMachine() {
        this.LOGGER.info("Loading snapshot for {}-{}, source directory is {}", new Object[]{this.storageGroupName, this.dataRegionId, this.snapshotPath});
        File snapshotLogFile = this.getSnapshotLogFile();
        if (snapshotLogFile == null) {
            return this.loadSnapshotWithoutLog();
        }
        return this.loadSnapshotWithLog(snapshotLogFile);
    }

    private DataRegion loadSnapshotWithoutLog() {
        try {
            try {
                this.deleteAllFilesInDataDirs();
                this.LOGGER.info("Remove all data files in original data dir");
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to remove origin data files", (Throwable)e);
                return null;
            }
            this.LOGGER.info("Moving snapshot file to data dirs");
            this.createLinksFromSnapshotDirToDataDirWithoutLog(new File(this.snapshotPath));
            return this.loadSnapshot();
        }
        catch (IOException | DiskSpaceInsufficientException e) {
            this.LOGGER.error("Exception occurs when loading snapshot for {}-{}", new Object[]{this.storageGroupName, this.dataRegionId, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRegion loadSnapshotWithLog(File logFile) {
        try {
            this.logAnalyzer = new SnapshotLogAnalyzer(logFile);
        }
        catch (Exception e) {
            this.LOGGER.error("Exception occurs when reading snapshot file", (Throwable)e);
            return null;
        }
        try {
            try {
                this.deleteAllFilesInDataDirs();
                this.LOGGER.info("Remove all data files in original data dir");
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to remove origin data files", (Throwable)e);
                DataRegion dataRegion = null;
                this.logAnalyzer.close();
                return dataRegion;
            }
            this.createLinksFromSnapshotDirToDataDirWithLog();
            DataRegion dataRegion = this.loadSnapshot();
            return dataRegion;
        }
        finally {
            this.logAnalyzer.close();
        }
    }

    private void deleteAllFilesInDataDirs() throws IOException {
        String[] dataDirPaths = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        ArrayList<File> timePartitions = new ArrayList<File>();
        for (String dataDirPath : dataDirPaths) {
            File[] files;
            File unseqDataDirForThisRegion;
            File[] files2;
            File seqDataDirForThisRegion = new File(dataDirPath + File.separator + "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId);
            if (seqDataDirForThisRegion.exists() && (files2 = seqDataDirForThisRegion.listFiles()) != null) {
                timePartitions.addAll(Arrays.asList(files2));
            }
            if (!(unseqDataDirForThisRegion = new File(dataDirPath + File.separator + "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId)).exists() || (files = unseqDataDirForThisRegion.listFiles()) == null) continue;
            timePartitions.addAll(Arrays.asList(files));
        }
        try {
            for (File timePartition : timePartitions) {
                FileUtils.forceDelete((File)timePartition);
            }
        }
        catch (IOException e) {
            this.LOGGER.error("Exception occurs when deleting time partition directory for {}-{}", new Object[]{this.storageGroupName, this.dataRegionId, e});
            throw e;
        }
    }

    private void createLinksFromSnapshotDirToDataDirWithoutLog(File sourceDir) throws IOException, DiskSpaceInsufficientException {
        File[] unseqRegionDirs;
        File seqFileDir = new File(sourceDir, "sequence" + File.separator + this.storageGroupName);
        File unseqFileDir = new File(sourceDir, "unsequence" + File.separator + this.storageGroupName);
        if (!seqFileDir.exists() && !unseqFileDir.exists()) {
            throw new IOException(String.format("Cannot find %s or %s", seqFileDir.getAbsolutePath(), unseqFileDir.getAbsolutePath()));
        }
        File[] seqRegionDirs = seqFileDir.listFiles();
        if (seqRegionDirs != null && seqRegionDirs.length > 0) {
            for (File seqRegionDir : seqRegionDirs) {
                if (!seqRegionDir.isDirectory()) {
                    this.LOGGER.info("Skip {}, because it is not a directory", (Object)seqRegionDir);
                    continue;
                }
                File[] seqPartitionDirs = seqRegionDir.listFiles();
                if (seqPartitionDirs == null || seqPartitionDirs.length <= 0) continue;
                for (File seqPartitionDir : seqPartitionDirs) {
                    String[] splitPath = seqPartitionDir.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : File.separator);
                    long timePartition = Long.parseLong(splitPath[splitPath.length - 1]);
                    File[] files = seqPartitionDir.listFiles();
                    if (files == null || files.length <= 0) continue;
                    Arrays.sort(files, Comparator.comparing(File::getName));
                    String currDir = DirectoryManager.getInstance().getNextFolderForSequenceFile();
                    for (File file : files) {
                        File targetFile;
                        if (file.getName().endsWith(".tsfile")) {
                            currDir = DirectoryManager.getInstance().getNextFolderForSequenceFile();
                        }
                        if (!(targetFile = new File(currDir, this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartition + File.separator + file.getName())).getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                            throw new IOException(String.format("Failed to create dir %s", targetFile.getParent()));
                        }
                        try {
                            Files.createLink(targetFile.toPath(), file.toPath());
                        }
                        catch (FileSystemException e) {
                            Files.copy(file.toPath(), targetFile.toPath(), new CopyOption[0]);
                        }
                    }
                }
            }
        }
        if ((unseqRegionDirs = unseqFileDir.listFiles()) != null && unseqRegionDirs.length > 0) {
            for (File unseqRegionDir : unseqRegionDirs) {
                if (!unseqRegionDir.isDirectory()) {
                    this.LOGGER.info("Skip {}, because it is not a directory", (Object)unseqRegionDir);
                    continue;
                }
                File[] unseqPartitionDirs = unseqRegionDir.listFiles();
                if (unseqPartitionDirs == null || unseqPartitionDirs.length <= 0) continue;
                for (File unseqPartitionDir : unseqPartitionDirs) {
                    String[] splitPath = unseqPartitionDir.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : File.separator);
                    long timePartition = Long.parseLong(splitPath[splitPath.length - 1]);
                    File[] files = unseqPartitionDir.listFiles();
                    if (files == null || files.length <= 0) continue;
                    Arrays.sort(files, Comparator.comparing(File::getName));
                    String currDir = DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
                    for (File file : files) {
                        File targetFile;
                        if (file.getName().endsWith(".tsfile")) {
                            currDir = DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
                        }
                        if (!(targetFile = new File(currDir, this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartition + File.separator + file.getName())).getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                            throw new IOException(String.format("Failed to create dir %s", targetFile.getParent()));
                        }
                        try {
                            Files.createLink(targetFile.toPath(), file.toPath());
                        }
                        catch (FileSystemException e) {
                            Files.copy(file.toPath(), targetFile.toPath(), new CopyOption[0]);
                        }
                    }
                }
            }
        }
    }

    private void createLinksFromSnapshotDirToDataDirWithLog() {
        while (this.logAnalyzer.hasNext()) {
            Pair<String, String> filesPath = this.logAnalyzer.getNextPairs();
            File sourceFile = new File((String)filesPath.left);
            File linkedFile = new File((String)filesPath.right);
            if (!linkedFile.exists()) {
                this.LOGGER.warn("Snapshot file {} does not exist, skip it", (Object)linkedFile);
                continue;
            }
            if (!sourceFile.getParentFile().exists() && !sourceFile.getParentFile().mkdirs()) {
                this.LOGGER.error("Failed to create folder {}", (Object)sourceFile.getParentFile());
                continue;
            }
            try {
                Files.createLink(sourceFile.toPath(), linkedFile.toPath());
            }
            catch (IOException e) {
                this.LOGGER.error("Failed to create link from {} to {}", new Object[]{linkedFile, sourceFile, e});
            }
        }
    }

    public List<File> getSnapshotFileInfo() throws IOException {
        File snapshotLogFile = this.getSnapshotLogFile();
        if (snapshotLogFile == null) {
            return this.getSnapshotFileWithoutLog();
        }
        return this.getSnapshotFileWithLog(snapshotLogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getSnapshotFileWithLog(File logFile) throws IOException {
        try (SnapshotLogAnalyzer analyzer = new SnapshotLogAnalyzer(logFile);){
            LinkedList<File> fileList = new LinkedList<File>();
            while (analyzer.hasNext()) {
                fileList.add(new File((String)analyzer.getNextPairs().right));
            }
            LinkedList<File> linkedList = fileList;
            return linkedList;
        }
    }

    private List<File> getSnapshotFileWithoutLog() {
        return new LinkedList<File>(Arrays.asList(Objects.requireNonNull(new File(this.snapshotPath).listFiles((dir, name) -> SnapshotFileSet.isDataFile(new File(dir, name))))));
    }
}

