/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.exception.runtime.FlushRunTimeException;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemTableFlushTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemTableFlushTask.class);
    private static final FlushSubTaskPoolManager SUB_TASK_POOL_MANAGER = FlushSubTaskPoolManager.getInstance();
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Future<?> encodingTaskFuture;
    private final Future<?> ioTaskFuture;
    private RestorableTsFileIOWriter writer;
    private final LinkedBlockingQueue<Object> encodingTaskQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Object> ioTaskQueue = config.isEnableMemControl() && SystemInfo.getInstance().isEncodingFasterThanIo() ? new LinkedBlockingQueue(config.getIoTaskQueueSizeForFlushing()) : new LinkedBlockingQueue();
    private String storageGroup;
    private IMemTable memTable;
    private volatile long memSerializeTime = 0L;
    private volatile long ioTime = 0L;
    private Runnable encodingTask = new Runnable(){

        @Override
        public void run() {
            LOGGER.debug("Storage group {} memtable flushing to file {} starts to encoding data.", (Object)MemTableFlushTask.this.storageGroup, (Object)MemTableFlushTask.this.writer.getFile().getName());
            while (true) {
                Object task;
                try {
                    task = MemTableFlushTask.this.encodingTaskQueue.take();
                }
                catch (InterruptedException e1) {
                    LOGGER.error("Take task into ioTaskQueue Interrupted");
                    Thread.currentThread().interrupt();
                    break;
                }
                if (task instanceof StartFlushGroupIOTask || task instanceof EndChunkGroupIoTask) {
                    try {
                        MemTableFlushTask.this.ioTaskQueue.put(task);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Storage group {} memtable flushing to file {}, encoding task is interrupted.", new Object[]{MemTableFlushTask.this.storageGroup, MemTableFlushTask.this.writer.getFile().getName(), e});
                        break;
                    }
                }
                if (task instanceof TaskEnd) break;
                long starTime = System.currentTimeMillis();
                IWritableMemChunk writableMemChunk = (IWritableMemChunk)task;
                IChunkWriter seriesWriter = writableMemChunk.createIChunkWriter();
                writableMemChunk.encode(seriesWriter);
                seriesWriter.sealCurrentPage();
                seriesWriter.clearPageWriter();
                try {
                    MemTableFlushTask.this.ioTaskQueue.put(seriesWriter);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Put task into ioTaskQueue Interrupted");
                    Thread.currentThread().interrupt();
                }
                MemTableFlushTask.this.memSerializeTime += System.currentTimeMillis() - starTime;
            }
            try {
                MemTableFlushTask.this.ioTaskQueue.put(new TaskEnd());
            }
            catch (InterruptedException e) {
                LOGGER.error("Put task into ioTaskQueue Interrupted");
                Thread.currentThread().interrupt();
            }
            LOGGER.debug("Storage group {}, flushing memtable {} into disk: Encoding data cost {} ms.", new Object[]{MemTableFlushTask.this.storageGroup, MemTableFlushTask.this.writer.getFile().getName(), MemTableFlushTask.this.memSerializeTime});
        }
    };
    private Runnable ioTask = () -> {
        LOGGER.debug("Storage group {} memtable flushing to file {} start io.", (Object)this.storageGroup, (Object)this.writer.getFile().getName());
        while (true) {
            Object ioMessage = null;
            try {
                ioMessage = this.ioTaskQueue.take();
            }
            catch (InterruptedException e1) {
                LOGGER.error("take task from ioTaskQueue Interrupted");
                Thread.currentThread().interrupt();
                break;
            }
            long starTime = System.currentTimeMillis();
            try {
                if (ioMessage instanceof StartFlushGroupIOTask) {
                    this.writer.startChunkGroup(((StartFlushGroupIOTask)ioMessage).deviceId);
                } else {
                    if (ioMessage instanceof TaskEnd) break;
                    if (ioMessage instanceof EndChunkGroupIoTask) {
                        this.writer.setMinPlanIndex(this.memTable.getMinPlanIndex());
                        this.writer.setMaxPlanIndex(this.memTable.getMaxPlanIndex());
                        this.writer.endChunkGroup();
                    } else {
                        ((IChunkWriter)ioMessage).writeToFileWriter((TsFileIOWriter)this.writer);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Storage group {} memtable {}, io task meets error.", new Object[]{this.storageGroup, this.memTable, e});
                throw new FlushRunTimeException(e);
            }
            this.ioTime += System.currentTimeMillis() - starTime;
        }
        LOGGER.debug("flushing a memtable to file {} in storage group {}, io cost {}ms", new Object[]{this.writer.getFile().getName(), this.storageGroup, this.ioTime});
    };

    public MemTableFlushTask(IMemTable memTable, RestorableTsFileIOWriter writer, String storageGroup) {
        this.memTable = memTable;
        this.writer = writer;
        this.storageGroup = storageGroup;
        this.encodingTaskFuture = SUB_TASK_POOL_MANAGER.submit(this.encodingTask);
        this.ioTaskFuture = SUB_TASK_POOL_MANAGER.submit(this.ioTask);
        LOGGER.debug("flush task of Storage group {} memtable is created, flushing to file {}.", (Object)storageGroup, (Object)writer.getFile().getName());
    }

    public void syncFlushMemTable() throws ExecutionException, InterruptedException {
        LOGGER.info("The memTable size of SG {} is {}, the avg series points num in chunk is {}, total timeseries number is {}", new Object[]{this.storageGroup, this.memTable.memSize(), this.memTable.getSeriesNumber() == 0 ? 0L : this.memTable.getTotalPointsNum() / (long)this.memTable.getSeriesNumber(), this.memTable.getSeriesNumber()});
        long estimatedTemporaryMemSize = 0L;
        if (config.isEnableMemControl() && SystemInfo.getInstance().isEncodingFasterThanIo()) {
            estimatedTemporaryMemSize = this.memTable.getSeriesNumber() == 0 ? 0L : this.memTable.memSize() / (long)this.memTable.getSeriesNumber() * (long)config.getIoTaskQueueSizeForFlushing();
            SystemInfo.getInstance().applyTemporaryMemoryForFlushing(estimatedTemporaryMemSize);
        }
        long start = System.currentTimeMillis();
        long sortTime = 0L;
        for (Map.Entry<IDeviceID, IWritableMemChunkGroup> memTableEntry : this.memTable.getMemTableMap().entrySet()) {
            this.encodingTaskQueue.put(new StartFlushGroupIOTask(memTableEntry.getKey().toStringID()));
            Map<String, IWritableMemChunk> value = memTableEntry.getValue().getMemChunkMap();
            for (Map.Entry<String, IWritableMemChunk> iWritableMemChunkEntry : value.entrySet()) {
                long startTime = System.currentTimeMillis();
                IWritableMemChunk series = iWritableMemChunkEntry.getValue();
                series.sortTvListForFlush();
                sortTime += System.currentTimeMillis() - startTime;
                this.encodingTaskQueue.put(series);
            }
            this.encodingTaskQueue.put(new EndChunkGroupIoTask());
        }
        this.encodingTaskQueue.put(new TaskEnd());
        LOGGER.debug("Storage group {} memtable flushing into file {}: data sort time cost {} ms.", new Object[]{this.storageGroup, this.writer.getFile().getName(), sortTime});
        try {
            this.encodingTaskFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.ioTaskFuture.cancel(true);
            throw e;
        }
        this.ioTaskFuture.get();
        try {
            this.writer.writePlanIndices();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        if (config.isEnableMemControl()) {
            if (estimatedTemporaryMemSize != 0L) {
                SystemInfo.getInstance().releaseTemporaryMemoryForFlushing(estimatedTemporaryMemSize);
            }
            SystemInfo.getInstance().setEncodingFasterThanIo(this.ioTime >= this.memSerializeTime);
        }
        MetricService.getInstance().timer(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "flush"});
        LOGGER.info("Storage group {} memtable {} flushing a memtable has finished! Time consumption: {}ms", new Object[]{this.storageGroup, this.memTable, System.currentTimeMillis() - start});
    }

    static class StartFlushGroupIOTask {
        private final String deviceId;

        StartFlushGroupIOTask(String deviceId) {
            this.deviceId = deviceId;
        }
    }

    static class EndChunkGroupIoTask {
        EndChunkGroupIoTask() {
        }
    }

    static class TaskEnd {
        TaskEnd() {
        }
    }
}

