/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cq;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.DropContinuousQueryPlan;
import org.apache.iotdb.db.utils.writelog.LogWriter;

public class CQLogWriter
implements AutoCloseable {
    private static final String TOO_LARGE_RECORD_EXCEPTION = "Current CQ management operation plan is too large to write into buffer, please increase cqlog_buffer_size.";
    private final ByteBuffer logBuffer = ByteBuffer.allocate(IoTDBDescriptor.getInstance().getConfig().getTlogBufferSize());
    private final LogWriter logWriter;

    public CQLogWriter(String logFilePath) throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.logWriter = new LogWriter(logFile, true);
    }

    public synchronized void createContinuousQuery(CreateContinuousQueryPlan createContinuousQueryPlan) throws IOException {
        try {
            createContinuousQueryPlan.serialize(this.logBuffer);
            this.logWriter.write(this.logBuffer);
        }
        catch (BufferOverflowException e) {
            throw new IOException(TOO_LARGE_RECORD_EXCEPTION, e);
        }
        finally {
            this.logBuffer.clear();
        }
    }

    public synchronized void dropContinuousQuery(DropContinuousQueryPlan dropContinuousQueryPlan) throws IOException {
        try {
            dropContinuousQueryPlan.serialize(this.logBuffer);
            this.logWriter.write(this.logBuffer);
        }
        catch (BufferOverflowException e) {
            throw new IOException(TOO_LARGE_RECORD_EXCEPTION, e);
        }
        finally {
            this.logBuffer.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.logWriter.close();
    }
}

