/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.strategy;

import java.time.ZoneId;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class SessionTimeWindowAccessStrategy
implements AccessStrategy {
    private final long displayWindowBegin;
    private final long displayWindowEnd;
    private final long sessionTimeGap;
    private ZoneId zoneId;

    public SessionTimeWindowAccessStrategy(long displayWindowBegin, long displayWindowEnd, long sessionTimeGap) {
        this.displayWindowBegin = displayWindowBegin;
        this.displayWindowEnd = displayWindowEnd;
        this.sessionTimeGap = sessionTimeGap;
    }

    public SessionTimeWindowAccessStrategy(long sessionTimeGap) {
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
        this.sessionTimeGap = sessionTimeGap;
    }

    @Override
    public void check() {
        if (this.sessionTimeGap <= 0L) {
            throw new RuntimeException(String.format("Parameter sessionTimeGap(%d) should be positive.", this.sessionTimeGap));
        }
        if (this.displayWindowEnd < this.displayWindowBegin) {
            throw new RuntimeException(String.format("displayWindowEnd(%d) < displayWindowBegin(%d)", this.displayWindowEnd, this.displayWindowBegin));
        }
    }

    @Override
    public AccessStrategy.AccessStrategyType getAccessStrategyType() {
        return AccessStrategy.AccessStrategyType.SESSION_TIME_WINDOW;
    }

    public long getDisplayWindowBegin() {
        return this.displayWindowBegin;
    }

    public long getDisplayWindowEnd() {
        return this.displayWindowEnd;
    }

    public long getSessionTimeGap() {
        return this.sessionTimeGap;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

