/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.datanode.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.sync.confignode.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.client.sync.datanode.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.DeleteRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.exception.AddConsensusGroupException;
import org.apache.iotdb.confignode.exception.AddPeerException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.procedure.env.DataNodeRemoveHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.scheduler.LockQueue;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.rpc.thrift.TAddConsensusGroupReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeProcedureEnv {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigNodeProcedureEnv.class);
    private final LockQueue nodeLock = new LockQueue();
    private final ReentrantLock schedulerLock = new ReentrantLock();
    private final ConfigManager configManager;
    private final ProcedureScheduler scheduler;
    private final DataNodeRemoveHandler dataNodeRemoveHandler;
    private static boolean skipForTest = false;
    private static boolean invalidCacheResult = true;
    private final ReentrantLock removeConfigNodeLock;

    public static void setSkipForTest(boolean skipForTest) {
        ConfigNodeProcedureEnv.skipForTest = skipForTest;
    }

    public static void setInvalidCacheResult(boolean result) {
        invalidCacheResult = result;
    }

    public ConfigNodeProcedureEnv(ConfigManager configManager, ProcedureScheduler scheduler) {
        this.configManager = configManager;
        this.scheduler = scheduler;
        this.dataNodeRemoveHandler = new DataNodeRemoveHandler(configManager);
        this.removeConfigNodeLock = new ReentrantLock();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public TSStatus deleteConfig(String name) {
        DeleteStorageGroupPlan deleteStorageGroupPlan = new DeleteStorageGroupPlan(name);
        return this.getClusterSchemaManager().deleteStorageGroup(deleteStorageGroupPlan);
    }

    public void preDelete(PreDeleteStorageGroupPlan.PreDeleteType preDeleteType, String deleteSgName) {
        this.getPartitionManager().preDeleteStorageGroup(deleteSgName, preDeleteType);
    }

    public boolean invalidateCache(String storageGroupName) throws IOException, TException {
        if (skipForTest) {
            return invalidCacheResult;
        }
        List<TDataNodeConfiguration> allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes();
        TInvalidateCacheReq invalidateCacheReq = new TInvalidateCacheReq();
        invalidateCacheReq.setStorageGroup(true);
        invalidateCacheReq.setFullPath(storageGroupName);
        for (TDataNodeConfiguration dataNodeConfiguration : allDataNodes) {
            TSStatus invalidateSchemaStatus = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeConfiguration.getLocation().getInternalEndPoint(), invalidateCacheReq, DataNodeRequestType.INVALIDATE_SCHEMA_CACHE);
            TSStatus invalidatePartitionStatus = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(dataNodeConfiguration.getLocation().getInternalEndPoint(), invalidateCacheReq, DataNodeRequestType.INVALIDATE_PARTITION_CACHE);
            if (this.verifySucceed(invalidatePartitionStatus, invalidateSchemaStatus)) continue;
            LOG.error("Invalidate cache failed, invalidate partition cache status is {}\uff0c invalidate schema cache status is {}", (Object)invalidatePartitionStatus, (Object)invalidateSchemaStatus);
            return false;
        }
        return true;
    }

    public boolean verifySucceed(TSStatus ... status) {
        return Arrays.stream(status).allMatch(tsStatus -> tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public void addConsensusGroup(TConfigNodeLocation tConfigNodeLocation) throws AddConsensusGroupException {
        ArrayList<TConfigNodeLocation> configNodeLocations = new ArrayList<TConfigNodeLocation>(this.configManager.getNodeManager().getRegisteredConfigNodes());
        configNodeLocations.add(tConfigNodeLocation);
        TSStatus status = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), new TAddConsensusGroupReq(configNodeLocations), ConfigNodeRequestType.ADD_CONSENSUS_GROUP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new AddConsensusGroupException(tConfigNodeLocation);
        }
    }

    public void addConfigNodePeer(TConfigNodeLocation configNodeLocation) throws AddPeerException {
        this.configManager.getConsensusManager().addConfigNodePeer(configNodeLocation);
    }

    public void removeConfigNodePeer(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        this.removeConfigNodeLock.tryLock();
        try {
            TSStatus tsStatus = this.getConsensusManager().removeConfigNodePeer(tConfigNodeLocation) ? this.getConsensusManager().write(new RemoveConfigNodePlan(tConfigNodeLocation)).getStatus() : new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because update ConsensusGroup peer information failed.");
            if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new ProcedureException(tsStatus.getMessage());
            }
        }
        finally {
            this.removeConfigNodeLock.unlock();
        }
    }

    public void removeConsensusGroup(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        TSStatus tsStatus = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), tConfigNodeLocation, ConfigNodeRequestType.REMOVE_CONSENSUS_GROUP);
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(tsStatus.getMessage());
        }
    }

    public void stopConfigNode(TConfigNodeLocation tConfigNodeLocation) throws ProcedureException {
        TSStatus tsStatus = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(tConfigNodeLocation.getInternalEndPoint(), tConfigNodeLocation, ConfigNodeRequestType.STOP_CONFIG_NODE);
        this.getNodeManager().removeNodeCache(tConfigNodeLocation.getConfigNodeId());
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(tsStatus.getMessage());
        }
    }

    public void applyConfigNode(TConfigNodeLocation configNodeLocation) {
        this.configManager.getNodeManager().applyConfigNode(configNodeLocation);
    }

    public void notifyRegisterSuccess(TConfigNodeLocation configNodeLocation) {
        SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(configNodeLocation.getInternalEndPoint(), null, ConfigNodeRequestType.NOTIFY_REGISTER_SUCCESS);
    }

    public void broadCastTheLatestConfigNodeGroup() {
        AsyncDataNodeClientPool.getInstance().broadCastTheLatestConfigNodeGroup(this.configManager.getNodeManager().getRegisteredDataNodeLocations(), this.configManager.getNodeManager().getRegisteredConfigNodes());
    }

    public void markDataNodeAsRemovingAndBroadCast(TDataNodeLocation dataNodeLocation) {
        int dataNodeId = dataNodeLocation.getDataNodeId();
        this.configManager.getNodeManager().setNodeRemovingStatus(dataNodeId, true);
        this.configManager.getLoadManager().broadcastLatestRegionRouteMap();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> doRegionCreation(CreateRegionGroupsPlan createRegionGroupsPlan) {
        HashMap<String, Long> ttlMap = new HashMap<String, Long>();
        for (String storageGroup : createRegionGroupsPlan.getRegionGroupMap().keySet()) {
            try {
                ttlMap.put(storageGroup, this.getClusterSchemaManager().getStorageGroupSchemaByName(storageGroup).getTTL());
            }
            catch (StorageGroupNotExistsException e) {
                LOG.error("StorageGroup doesn't exist", (Throwable)e);
            }
        }
        return AsyncDataNodeClientPool.getInstance().createRegionGroups(createRegionGroupsPlan, ttlMap);
    }

    public void persistAndBroadcastRegionGroup(CreateRegionGroupsPlan createRegionGroupsPlan) {
        this.getConsensusManager().write(createRegionGroupsPlan);
        this.getLoadManager().broadcastLatestRegionRouteMap();
    }

    public void submitFailedRegionReplicas(DeleteRegionGroupsPlan deleteRegionGroupsPlan) {
        this.getConsensusManager().write(deleteRegionGroupsPlan);
    }

    public LockQueue getNodeLock() {
        return this.nodeLock;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public LockQueue getRegionMigrateLock() {
        return this.dataNodeRemoveHandler.getRegionMigrateLock();
    }

    public ReentrantLock getSchedulerLock() {
        return this.schedulerLock;
    }

    public DataNodeRemoveHandler getDataNodeRemoveHandler() {
        return this.dataNodeRemoveHandler;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }
}

