/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeInfo.class);
    private static final int minimumDataNode = Math.max(ConfigNodeDescriptor.getInstance().getConf().getSchemaReplicationFactor(), ConfigNodeDescriptor.getInstance().getConf().getDataReplicationFactor());
    private final ReentrantReadWriteLock configNodeInfoReadWriteLock;
    private final Set<TConfigNodeLocation> registeredConfigNodes;
    private final ReentrantReadWriteLock dataNodeInfoReadWriteLock;
    private final AtomicInteger nextNodeId = new AtomicInteger(-1);
    private final ConcurrentNavigableMap<Integer, TDataNodeConfiguration> registeredDataNodes = new ConcurrentSkipListMap<Integer, TDataNodeConfiguration>();
    private final Set<TDataNodeLocation> drainingDataNodes = new HashSet<TDataNodeLocation>();
    private final String snapshotFileName = "node_info.bin";

    public NodeInfo() {
        this.dataNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.configNodeInfoReadWriteLock = new ReentrantReadWriteLock();
        this.registeredConfigNodes = new HashSet<TConfigNodeLocation>();
    }

    public void addMetrics() {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, this.registeredConfigNodes, o -> this.getRegisteredConfigNodeCount(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, this.registeredDataNodes, Map::size, new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegisteredDataNode(TDataNodeLocation dataNodeLocation) {
        boolean result = false;
        int originalDataNodeId = dataNodeLocation.getDataNodeId();
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            for (Map.Entry entry : this.registeredDataNodes.entrySet()) {
                dataNodeLocation.setDataNodeId(((Integer)entry.getKey()).intValue());
                if (!((TDataNodeConfiguration)entry.getValue()).getLocation().equals(dataNodeLocation)) continue;
                result = true;
                break;
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        dataNodeLocation.setDataNodeId(originalDataNodeId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus registerDataNode(RegisterDataNodePlan registerDataNodePlan) {
        TSStatus result;
        TDataNodeConfiguration info = registerDataNodePlan.getInfo();
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        try {
            AtomicInteger atomicInteger = this.nextNodeId;
            synchronized (atomicInteger) {
                if (this.nextNodeId.get() < info.getLocation().getDataNodeId()) {
                    this.nextNodeId.set(info.getLocation().getDataNodeId());
                }
            }
            this.registeredDataNodes.put(info.getLocation().getDataNodeId(), info);
            result = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            if (this.nextNodeId.get() < minimumDataNode) {
                result.setMessage(String.format("To enable IoTDB-Cluster's data service, please register %d more IoTDB-DataNode", minimumDataNode - this.nextNodeId.get()));
            } else if (this.nextNodeId.get() == minimumDataNode) {
                result.setMessage("IoTDB-Cluster could provide data service, now enjoy yourself!");
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    public TSStatus removeDataNode(RemoveDataNodePlan req) {
        LOGGER.info("there are {} data node in cluster before remove some", (Object)this.registeredDataNodes.size());
        try {
            this.dataNodeInfoReadWriteLock.writeLock().lock();
            req.getDataNodeLocations().forEach(removeDataNodes -> {
                this.registeredDataNodes.remove(removeDataNodes.getDataNodeId());
                LOGGER.info("removed the datanode {} from cluster", removeDataNodes);
            });
        }
        finally {
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
        LOGGER.info("there are {} data node in cluster after remove some", (Object)this.registeredDataNodes.size());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNodeConfigurationResp getDataNodeConfiguration(GetDataNodeConfigurationPlan getDataNodeConfigurationPlan) {
        DataNodeConfigurationResp result = new DataNodeConfigurationResp();
        result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        int dataNodeId = getDataNodeConfigurationPlan.getDataNodeId();
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            if (dataNodeId == -1) {
                result.setDataNodeConfigurationMap(new HashMap<Integer, TDataNodeConfiguration>(this.registeredDataNodes));
            } else {
                result.setDataNodeConfigurationMap(this.registeredDataNodes.get(dataNodeId) == null ? new HashMap<Integer, TDataNodeConfiguration>(0) : Collections.singletonMap(dataNodeId, (TDataNodeConfiguration)this.registeredDataNodes.get(dataNodeId)));
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int getRegisteredDataNodeCount() {
        int result;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = this.registeredDataNodes.size();
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int getRegisteredConfigNodeCount() {
        int result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            result = this.registeredConfigNodes.size();
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int getRegisteredNodeCount() {
        int result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = this.registeredConfigNodes.size() + this.registeredDataNodes.size();
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCpuCoreCount() {
        int result = 0;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            for (TDataNodeConfiguration dataNodeConfiguration : this.registeredDataNodes.values()) {
                result += dataNodeConfiguration.getResource().getCpuCoreNum();
            }
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public List<TDataNodeConfiguration> getRegisteredDataNodes() {
        ArrayList<TDataNodeConfiguration> result;
        this.dataNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TDataNodeConfiguration>(this.registeredDataNodes.values());
        }
        finally {
            this.dataNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus applyConfigNode(ApplyConfigNodePlan applyConfigNodePlan) {
        TSStatus status = new TSStatus();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            AtomicInteger atomicInteger = this.nextNodeId;
            synchronized (atomicInteger) {
                if (this.nextNodeId.get() < applyConfigNodePlan.getConfigNodeLocation().getConfigNodeId()) {
                    this.nextNodeId.set(applyConfigNodePlan.getConfigNodeLocation().getConfigNodeId());
                }
            }
            this.registeredConfigNodes.add(applyConfigNodePlan.getConfigNodeLocation());
            SystemPropertiesUtils.storeConfigNodeList(new ArrayList<TConfigNodeLocation>(this.registeredConfigNodes));
            LOGGER.info("Successfully apply ConfigNode: {}. Current ConfigNodeGroup: {}", (Object)applyConfigNodePlan.getConfigNodeLocation(), this.registeredConfigNodes);
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (IOException e) {
            LOGGER.error("Update online ConfigNode failed.", (Throwable)e);
            status.setCode(TSStatusCode.APPLY_CONFIGNODE_FAILED.getStatusCode());
            status.setMessage("Apply new ConfigNode failed because current ConfigNode can't store ConfigNode information.");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        TSStatus status = new TSStatus();
        this.configNodeInfoReadWriteLock.writeLock().lock();
        try {
            this.registeredConfigNodes.remove(removeConfigNodePlan.getConfigNodeLocation());
            SystemPropertiesUtils.storeConfigNodeList(new ArrayList<TConfigNodeLocation>(this.registeredConfigNodes));
            LOGGER.info("Successfully remove ConfigNode: {}. Current ConfigNodeGroup: {}", (Object)removeConfigNodePlan.getConfigNodeLocation(), this.registeredConfigNodes);
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (IOException e) {
            LOGGER.error("Remove online ConfigNode failed.", (Throwable)e);
            status.setCode(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode());
            status.setMessage("Remove ConfigNode failed because current ConfigNode can't store ConfigNode information.");
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
        }
        return status;
    }

    public List<TConfigNodeLocation> getRegisteredConfigNodes() {
        ArrayList<TConfigNodeLocation> result;
        this.configNodeInfoReadWriteLock.readLock().lock();
        try {
            result = new ArrayList<TConfigNodeLocation>(this.registeredConfigNodes);
        }
        finally {
            this.configNodeInfoReadWriteLock.readLock().unlock();
        }
        return result;
    }

    public int generateNextNodeId() {
        return this.nextNodeId.incrementAndGet();
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException, TException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void serializeRegisteredConfigNode(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.registeredConfigNodes.size(), (OutputStream)outputStream);
        for (TConfigNodeLocation configNodeLocation : this.registeredConfigNodes) {
            configNodeLocation.write(protocol);
        }
    }

    private void serializeRegisteredDataNode(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.registeredDataNodes.size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.registeredDataNodes.entrySet()) {
            ReadWriteIOUtils.write((int)((Integer)entry.getKey()), (OutputStream)outputStream);
            ((TDataNodeConfiguration)entry.getValue()).write(protocol);
        }
    }

    private void serializeDrainingDataNodes(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)this.drainingDataNodes.size(), (OutputStream)outputStream);
        for (TDataNodeLocation tDataNodeLocation : this.drainingDataNodes) {
            tDataNodeLocation.write(protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException, TException {
        File snapshotFile = new File(snapshotDir, "node_info.bin");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.configNodeInfoReadWriteLock.writeLock().lock();
        this.dataNodeInfoReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             TIOStreamTransport tioStreamTransport = new TIOStreamTransport((InputStream)fileInputStream);){
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tioStreamTransport);
            this.clear();
            this.nextNodeId.set(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
            this.deserializeRegisteredConfigNode(fileInputStream, (TProtocol)protocol);
            this.deserializeRegisteredDataNode(fileInputStream, (TProtocol)protocol);
            this.deserializeDrainingDataNodes(fileInputStream, (TProtocol)protocol);
        }
        finally {
            this.configNodeInfoReadWriteLock.writeLock().unlock();
            this.dataNodeInfoReadWriteLock.writeLock().unlock();
        }
    }

    private void deserializeRegisteredConfigNode(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            TConfigNodeLocation configNodeLocation = new TConfigNodeLocation();
            configNodeLocation.read(protocol);
            this.registeredConfigNodes.add(configNodeLocation);
        }
    }

    private void deserializeRegisteredDataNode(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            int dataNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            TDataNodeConfiguration dataNodeInfo = new TDataNodeConfiguration();
            dataNodeInfo.read(protocol);
            this.registeredDataNodes.put(dataNodeId, dataNodeInfo);
        }
    }

    private void deserializeDrainingDataNodes(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            TDataNodeLocation tDataNodeLocation = new TDataNodeLocation();
            tDataNodeLocation.read(protocol);
            this.drainingDataNodes.add(tDataNodeLocation);
        }
    }

    public void setDrainingDataNodes(Set<TDataNodeLocation> tDataNodeLocations) {
        this.drainingDataNodes.addAll(tDataNodeLocations);
    }

    public int getNextNodeId() {
        return this.nextNodeId.get();
    }

    public static int getMinimumDataNode() {
        return minimumDataNode;
    }

    public Set<TDataNodeLocation> getDrainingDataNodes() {
        return this.drainingDataNodes;
    }

    public void clear() {
        this.nextNodeId.set(-1);
        this.registeredDataNodes.clear();
        this.drainingDataNodes.clear();
        this.registeredConfigNodes.clear();
    }
}

