/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionAllocator;

public class GreedyRegionAllocator
implements IRegionAllocator {
    @Override
    public TRegionReplicaSet allocateRegion(List<TDataNodeConfiguration> onlineDataNodes, List<TRegionReplicaSet> allocatedRegions, int replicationFactor, TConsensusGroupId consensusGroupId) {
        List<TDataNodeLocation> weightList = this.buildWeightList(onlineDataNodes, allocatedRegions);
        return new TRegionReplicaSet(consensusGroupId, weightList.stream().limit(replicationFactor).collect(Collectors.toList()));
    }

    private List<TDataNodeLocation> buildWeightList(List<TDataNodeConfiguration> onlineDataNodes, List<TRegionReplicaSet> allocatedRegions) {
        HashMap<TDataNodeLocation, Integer> countMap = new HashMap<TDataNodeLocation, Integer>();
        for (TDataNodeConfiguration dataNodeInfo : onlineDataNodes) {
            countMap.put(dataNodeInfo.getLocation(), 0);
        }
        for (TRegionReplicaSet regionReplicaSet : allocatedRegions) {
            for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                countMap.computeIfPresent(dataNodeLocation, (dataNode, count) -> count + 1);
            }
        }
        return countMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(e -> ((TDataNodeLocation)e.getKey()).deepCopy()).collect(Collectors.toList());
    }
}

